/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.NettyKt;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class NettyUtil {
    public static final int MAX_CONTENT_LENGTH = 0x6400000;
    public static final int DEFAULT_CONNECT_ATTEMPT_COUNT = 20;
    public static final int MIN_START_TIME = 100;

    public static void logAndClose(@NotNull Throwable error, @NotNull Logger log2, @NotNull Channel channel) {
        try {
            if (error instanceof ConnectException) {
                log2.debug(error);
            } else {
                NettyUtil.log(error, log2);
            }
        }
        finally {
            log2.info("Channel will be closed due to error");
            channel.close();
        }
    }

    public static void log(@NotNull Throwable throwable, @NotNull Logger log2) {
        if (NettyUtil.isAsWarning(throwable)) {
            log2.warn(throwable);
        } else {
            log2.error(throwable);
        }
    }

    private static boolean isAsWarning(@NotNull Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            return false;
        }
        if (throwable instanceof IOException) {
            return throwable instanceof BindException || message.equals("An existing connection was forcibly closed by the remote host") || message.equals("\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439 \u0445\u043e\u0441\u0442 \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0440\u0430\u0437\u043e\u0440\u0432\u0430\u043b \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435");
        }
        return throwable instanceof ChannelException && message.startsWith("Failed to bind to: ") || message.startsWith("Connection reset") || message.equals("Operation timed out") || message.equals("Connection timed out");
    }

    @NotNull
    public static Bootstrap nioClientBootstrap() {
        return NettyUtil.nioClientBootstrap((EventLoopGroup)NettyKt.MultiThreadEventLoopGroup(2));
    }

    @NotNull
    public static Bootstrap nioClientBootstrap(@NotNull EventLoopGroup eventLoopGroup) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        return bootstrap;
    }

    public static void addHttpServerCodec(@NotNull ChannelPipeline pipeline) {
        pipeline.addLast("httpRequestEncoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("httpRequestDecoder", (ChannelHandler)new HttpRequestDecoder(16384, 16384, 8192));
        pipeline.addLast("httpObjectAggregator", (ChannelHandler)new HttpObjectAggregator(0x6400000));
        if (pipeline.get(ChunkedWriteHandler.class) == null) {
            pipeline.addLast("chunkedWriteHandler", (ChannelHandler)new ChunkedWriteHandler());
        }
        pipeline.addLast("corsHandler", (ChannelHandler)new CorsHandlerDoNotUseOwnLogger(CorsConfigBuilder.forAnyOrigin().shortCircuit().allowCredentials().allowNullOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.HEAD, HttpMethod.PATCH}).allowedRequestHeaders(new String[]{"origin", "accept", "authorization", "content-type", "x-ijt", "x-requested-with"}).build()));
    }

    public static void awaitQuiescenceOfGlobalEventExecutor(long timeout, @NotNull TimeUnit unit) {
        try {
            GlobalEventExecutor executor = GlobalEventExecutor.INSTANCE;
            executor.awaitInactivity(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static final class CorsHandlerDoNotUseOwnLogger
    extends CorsHandler {
        CorsHandlerDoNotUseOwnLogger(@NotNull CorsConfig config2) {
            super(config2);
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            context.fireExceptionCaught(cause);
        }
    }
}

