/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"unpackTarGz", "", "inputStream", "Ljava/io/InputStream;", "to", "Ljava/nio/file/Path;", "intellij.platform.ide.impl"})
public final class TarKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unpackTarGz(@NotNull InputStream inputStream, @NotNull Path to) {
        Closeable closeable = (Closeable)new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(inputStream));
        Throwable throwable = null;
        try {
            TarArchiveInputStream input = (TarArchiveInputStream)closeable;
            boolean bl = false;
            while (input.getNextTarEntry() != null) {
                TarArchiveEntry entry;
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                Path destination = to.resolve(name);
                Object object = entry.getLinkName();
                if (object == null || StringsKt.isBlank((CharSequence)object)) {
                    object = PathKt.outputStream((Path)destination);
                    Throwable throwable2 = null;
                    try {
                        OutputStream it = (OutputStream)object;
                        boolean bl2 = false;
                        FileUtil.copy((InputStream)((InputStream)input), (long)entry.getSize(), (OutputStream)it);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                    }
                    if (!SystemInfo.isUnix || (entry.getMode() & 0x49) == 0) continue;
                    Files.setPosixFilePermissions(destination, SetsKt.setOf((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE}));
                    continue;
                }
                if (SystemInfo.isWindows) {
                    Logger.getInstance((String)"#org.jetbrains.io").warn("Skipped " + entry.getLinkName() + " in " + destination + ". Creating symbolic links on Windows requires admin permissions");
                    continue;
                }
                PathKt.createSymbolicLink((Path)destination, (Path)destination.getParent().resolve(entry.getLinkName()));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

