/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoop;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.jsonRpc.ExceptionHandler;

public abstract class Client
extends UserDataHolderBase {
    protected final Channel channel;
    final IntObjectMap<AsyncPromise<Object>> messageCallbackMap = ContainerUtil.createConcurrentIntObjectMap();

    protected Client(@NotNull Channel channel) {
        this.channel = channel;
    }

    @NotNull
    public final EventLoop getEventLoop() {
        return this.channel.eventLoop();
    }

    @NotNull
    public final ByteBufAllocator getByteBufAllocator() {
        return this.channel.alloc();
    }

    @NotNull
    protected abstract ChannelFuture send(@NotNull ByteBuf var1);

    public abstract void sendHeartbeat();

    @Nullable
    final <T> Promise<T> send(int messageId, @NotNull ByteBuf message) {
        ChannelFuture channelFuture = this.send(message);
        if (messageId == -1) {
            return null;
        }
        AsyncPromise promise = (AsyncPromise)new AsyncPromise().onError(error -> {
            AsyncPromise cfr_ignored_0 = (AsyncPromise)this.messageCallbackMap.remove(messageId);
        });
        channelFuture.addListener(future2 -> {
            if (!future2.isSuccess()) {
                Throwable cause = future2.cause();
                if (cause == null) {
                    promise.setError("No success");
                } else {
                    promise.setError(cause);
                }
            }
        });
        this.messageCallbackMap.put(messageId, (Object)promise);
        return promise;
    }

    final void rejectAsyncResults(@NotNull ExceptionHandler exceptionHandler) {
        if (!this.messageCallbackMap.isEmpty()) {
            for (AsyncPromise promise : this.messageCallbackMap.values()) {
                try {
                    promise.setError("rejected");
                }
                catch (Throwable e) {
                    exceptionHandler.exceptionCaught(e);
                }
            }
        }
    }
}

