/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc.socket;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BinaryRequestHandler;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.jsonRpc.JsonRpcServerKt;
import org.jetbrains.io.jsonRpc.socket.SocketClient;

public class RpcBinaryRequestHandler
extends BinaryRequestHandler
implements ExceptionHandler,
ClientListener {
    private static final Logger LOG = Logger.getInstance(RpcBinaryRequestHandler.class);
    private static final UUID ID = UUID.fromString("69957EEB-AFB8-4036-A9A8-00D2D022F9BD");
    private final AtomicNotNullLazyValue<ClientManager> clientManager = new AtomicNotNullLazyValue<ClientManager>(){

        @NotNull
        protected ClientManager compute() {
            ClientManager result2 = new ClientManager(RpcBinaryRequestHandler.this, RpcBinaryRequestHandler.this, null);
            Disposable serverDisposable = BuiltInServerManager.getInstance().getServerDisposable();
            assert (serverDisposable != null);
            Disposer.register((Disposable)serverDisposable, (Disposable)result2);
            RpcBinaryRequestHandler.this.rpcServer = new JsonRpcServer(result2);
            JsonRpcServerKt.registerFromEp(RpcBinaryRequestHandler.this.rpcServer);
            return result2;
        }
    };
    private JsonRpcServer rpcServer;

    public static JsonRpcServer getRpcServerInstance() {
        return ((RpcBinaryRequestHandler)BinaryRequestHandler.EP_NAME.findExtension(RpcBinaryRequestHandler.class)).getServer();
    }

    @NotNull
    private JsonRpcServer getServer() {
        this.clientManager.getValue();
        return this.rpcServer;
    }

    @NotNull
    public UUID getId() {
        return ID;
    }

    @NotNull
    public ChannelHandler getInboundHandler(@NotNull ChannelHandlerContext context) {
        SocketClient client = new SocketClient(context.channel());
        context.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client);
        ((ClientManager)this.clientManager.getValue()).addClient(client);
        this.connected(client, null);
        return new MyDecoder(client);
    }

    @Override
    public void exceptionCaught(@NotNull Throwable e) {
        LOG.error(e);
    }

    @Override
    public void connected(@NotNull Client client, @Nullable Map<String, List<String>> parameters) {
    }

    @Override
    public void disconnected(@NotNull Client client) {
    }

    private class MyDecoder
    extends MessageDecoder {
        private State state = State.LENGTH;
        private final SocketClient client;

        MyDecoder(SocketClient client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) {
            block9: while (true) {
                switch (this.state) {
                    case LENGTH: {
                        ByteBuf buffer = this.getBufferIfSufficient(input, 4, context);
                        if (buffer == null) {
                            return;
                        }
                        this.state = State.CONTENT;
                        this.contentLength = buffer.readInt();
                    }
                    case CONTENT: {
                        CharSequence content = this.readChars(input);
                        if (content == null) {
                            return;
                        }
                        try {
                            RpcBinaryRequestHandler.this.rpcServer.messageReceived(this.client, content);
                            continue block9;
                        }
                        catch (Throwable e) {
                            ((ClientManager)RpcBinaryRequestHandler.this.clientManager.getValue()).getExceptionHandler().exceptionCaught(e);
                            continue block9;
                        }
                        finally {
                            this.contentLength = 0;
                            this.state = State.LENGTH;
                            continue block9;
                        }
                    }
                }
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext context) {
            Client client = (Client)((Object)context.channel().attr(ClientManagerKt.getCLIENT()).get());
            if (client != null) {
                ((ClientManager)RpcBinaryRequestHandler.this.clientManager.getValue()).disconnectClient(context.channel(), client, false);
            }
        }
    }

    private static enum State {
        LENGTH,
        CONTENT;

    }
}

