/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import java.nio.channels.ClosedChannelException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.jsonRpc.Client;

class WebSocketClient
extends Client {
    private final WebSocketServerHandshaker handshaker;

    WebSocketClient(@NotNull Channel channel, @NotNull WebSocketServerHandshaker handshaker) {
        super(channel);
        this.handshaker = handshaker;
    }

    @Override
    @NotNull
    public ChannelFuture send(@NotNull ByteBuf message) {
        if (this.channel.isOpen()) {
            return this.channel.writeAndFlush((Object)new TextWebSocketFrame(message));
        }
        return this.channel.newFailedFuture((Throwable)new ClosedChannelException());
    }

    @Override
    public void sendHeartbeat() {
        this.channel.writeAndFlush((Object)new PingWebSocketFrame());
    }

    public void disconnect(@NotNull CloseWebSocketFrame frame) {
        this.handshaker.close(this.channel, frame);
    }
}

