/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jsonProtocol;

import com.google.gson.stream.JsonToken;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.TDoubleArrayList;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TLongArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.MapFactory;
import org.jetbrains.jsonProtocol.ObjectFactory;
import org.jetbrains.jsonProtocol.StringIntPair;

public final class JsonReaders {
    public static final ObjectFactory<String> STRING_OBJECT_FACTORY = new ObjectFactory<String>(){

        @Override
        public String read(JsonReaderEx reader) {
            return reader.nextString();
        }
    };

    private JsonReaders() {
    }

    public static <T> ObjectFactory<Map<String, T>> mapFactory(@NotNull ObjectFactory<? extends T> valueFactory) {
        return new MapFactory<T>(valueFactory);
    }

    private static void checkIsNull(JsonReaderEx reader, String fieldName) {
        if (reader.peek() == JsonToken.NULL) {
            throw new RuntimeException("Field is not nullable" + (fieldName == null ? "" : ": " + fieldName));
        }
    }

    public static String readRawString(JsonReaderEx reader) {
        return reader.nextString(true);
    }

    public static Object readRawStringOrMap(JsonReaderEx reader) {
        if (reader.peek() == JsonToken.BEGIN_OBJECT) {
            return JsonReaders.readMap(reader, null);
        }
        return reader.nextString(true);
    }

    public static String convertRawEnumName(@NotNull String enumValue) {
        int n = enumValue.length();
        StringBuilder builder2 = new StringBuilder(n + 4);
        boolean prevIsLowerCase = false;
        for (int i = 0; i < n; ++i) {
            char c = enumValue.charAt(i);
            if (c == '-' || c == ' ') {
                builder2.append('_');
                continue;
            }
            if (Character.isUpperCase(c)) {
                if (prevIsLowerCase || i != 0 && i + 1 < n && Character.isLowerCase(enumValue.charAt(i + 1))) {
                    builder2.append('_');
                }
                builder2.append(c);
                prevIsLowerCase = false;
                continue;
            }
            builder2.append(Character.toUpperCase(c));
            prevIsLowerCase = true;
        }
        return builder2.toString();
    }

    public static <T extends Enum<T>> T readEnum(@NotNull JsonReaderEx reader, @NotNull Class<T> enumClass) {
        if (reader.peek() == JsonToken.NULL) {
            reader.skipValue();
            return null;
        }
        try {
            return Enum.valueOf(enumClass, JsonReaders.convertRawEnumName(reader.nextString()));
        }
        catch (IllegalArgumentException ignored) {
            return Enum.valueOf(enumClass, "NO_ENUM_CONST");
        }
    }

    public static <T> List<T> readObjectArray(@NotNull JsonReaderEx reader, @NotNull ObjectFactory<? extends T> factory) {
        if (reader.peek() == JsonToken.NULL) {
            reader.skipValue();
            return null;
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return Collections.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>();
        do {
            result2.add(factory.read(reader));
        } while (reader.hasNext());
        reader.endArray();
        return result2;
    }

    public static <T> Map<String, T> readMap(@NotNull JsonReaderEx reader, @Nullable ObjectFactory<? extends T> factory) {
        if (reader.peek() == JsonToken.NULL) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        if (!reader.hasNext()) {
            reader.endObject();
            return Collections.emptyMap();
        }
        THashMap map2 = new THashMap();
        while (reader.hasNext()) {
            if (factory == null) {
                map2.put(reader.nextName(), JsonReaders.read(reader));
                continue;
            }
            map2.put(reader.nextName(), factory.read(reader));
        }
        reader.endObject();
        return map2;
    }

    public static Object read(JsonReaderEx reader) {
        switch (reader.peek()) {
            case BEGIN_ARRAY: {
                return JsonReaders.nextList(reader);
            }
            case BEGIN_OBJECT: {
                reader.beginObject();
                return JsonReaders.nextObject(reader);
            }
            case STRING: {
                return reader.nextString();
            }
            case NUMBER: {
                return reader.nextDouble();
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case NULL: {
                reader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public static Map<String, Object> nextObject(JsonReaderEx reader) {
        THashMap map2 = new THashMap();
        while (reader.hasNext()) {
            map2.put(reader.nextName(), JsonReaders.read(reader));
        }
        reader.endObject();
        return map2;
    }

    public static <T> List<T> nextList(JsonReaderEx reader) {
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return Collections.emptyList();
        }
        ArrayList<Object> list2 = new ArrayList<Object>();
        do {
            list2.add(JsonReaders.read(reader));
        } while (reader.hasNext());
        reader.endArray();
        return list2;
    }

    public static List<String> readRawStringArray(JsonReaderEx reader) {
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return Collections.emptyList();
        }
        ArrayList<String> list2 = new ArrayList<String>();
        do {
            list2.add(reader.nextString(true));
        } while (reader.hasNext());
        reader.endArray();
        return list2;
    }

    public static long[] readLongArray(JsonReaderEx reader) {
        JsonReaders.checkIsNull(reader, null);
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return ArrayUtilRt.EMPTY_LONG_ARRAY;
        }
        TLongArrayList result2 = new TLongArrayList();
        do {
            result2.add(reader.nextLong());
        } while (reader.hasNext());
        reader.endArray();
        return result2.toNativeArray();
    }

    public static double[] readDoubleArray(JsonReaderEx reader) {
        JsonReaders.checkIsNull(reader, null);
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return new double[]{0.0};
        }
        TDoubleArrayList result2 = new TDoubleArrayList();
        do {
            result2.add(reader.nextDouble());
        } while (reader.hasNext());
        reader.endArray();
        return result2.toNativeArray();
    }

    public static int[] readIntArray(JsonReaderEx reader) {
        JsonReaders.checkIsNull(reader, null);
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        TIntArrayList result2 = new TIntArrayList();
        do {
            result2.add(reader.nextInt());
        } while (reader.hasNext());
        reader.endArray();
        return result2.toNativeArray();
    }

    public static List<StringIntPair> readIntStringPairs(JsonReaderEx reader) {
        JsonReaders.checkIsNull(reader, null);
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return Collections.emptyList();
        }
        ArrayList<StringIntPair> result2 = new ArrayList<StringIntPair>();
        do {
            reader.beginArray();
            result2.add(new StringIntPair(reader.nextInt(), reader.nextString()));
            reader.endArray();
        } while (reader.hasNext());
        reader.endArray();
        return result2;
    }

    public static boolean findBooleanField(String name, JsonReaderEx reader) {
        reader.beginObject();
        while (reader.hasNext()) {
            if (reader.nextName().equals(name)) {
                return reader.nextBoolean();
            }
            reader.skipValue();
        }
        return false;
    }
}

