/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.java.InjectionCache;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.ContextComputationProcessor;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcatenationInjector
implements ConcatenationAwareInjector {
    private final Configuration myConfiguration;
    private final Project myProject;
    private final TemporaryPlacesRegistry myTemporaryPlacesRegistry;
    private final LanguageInjectionSupport mySupport;

    public ConcatenationInjector(Configuration configuration, Project project, TemporaryPlacesRegistry temporaryPlacesRegistry) {
        this.myConfiguration = configuration;
        this.myProject = project;
        this.myTemporaryPlacesRegistry = temporaryPlacesRegistry;
        this.mySupport = InjectorUtils.findNotNullInjectionSupport("java");
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, PsiElement ... operands) {
        if (operands.length == 0) {
            return;
        }
        boolean hasLiteral = false;
        InjectedLanguage tempInjectedLanguage = null;
        PsiFile containingFile = null;
        for (PsiElement operand : operands) {
            if (!PsiUtilEx.isStringOrCharacterLiteral(operand)) continue;
            hasLiteral = true;
            if (containingFile == null) {
                containingFile = operands[0].getContainingFile();
            }
            if ((tempInjectedLanguage = this.myTemporaryPlacesRegistry.getLanguageFor((PsiLanguageInjectionHost)operand, containingFile)) != null) break;
        }
        if (!hasLiteral) {
            return;
        }
        this.processOperandsInjection(registrar, containingFile, tempInjectedLanguage, operands);
    }

    private void processOperandsInjection(final @NotNull MultiHostRegistrar registrar, final @NotNull PsiFile containingFile, final @Nullable InjectedLanguage tempInjectedLanguage, @NotNull PsiElement[] operands) {
        final Language tempLanguage = tempInjectedLanguage == null ? null : tempInjectedLanguage.getLanguage();
        LanguageInjectionSupport injectionSupport = tempLanguage == null ? this.mySupport : TemporaryPlacesRegistry.getInstance(this.myProject).getLanguageInjectionSupport();
        InjectionProcessor injectionProcessor = new InjectionProcessor(this.myConfiguration, injectionSupport, operands){

            @Override
            protected Pair<PsiLanguageInjectionHost, Language> processInjection(Language language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, boolean settingsAvailable, boolean unparsable) {
                InjectorUtils.registerInjection(language, list, containingFile, registrar);
                InjectorUtils.registerSupport(this.getLanguageInjectionSupport(), settingsAvailable, (PsiElement)list.get(0).getFirst(), language);
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)list.get(0).getFirst();
                if (tempLanguage != null) {
                    InjectorUtils.putInjectedFileUserData((PsiElement)host, language, LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, tempInjectedLanguage);
                }
                InjectorUtils.putInjectedFileUserData((PsiElement)host, language, InjectedLanguageUtil.FRANKENSTEIN_INJECTION, unparsable ? Boolean.TRUE : null);
                return Pair.create((Object)host, (Object)language);
            }

            @Override
            protected boolean areThereInjectionsWithName(String methodName, boolean annoOnly) {
                if (methodName == null) {
                    return false;
                }
                if (ConcatenationInjector.this.getAnnotatedElementsValue().contains(methodName)) {
                    return true;
                }
                return !annoOnly && ConcatenationInjector.this.getXmlAnnotatedElementsValue().contains(methodName);
            }
        };
        if (tempLanguage != null) {
            BaseInjection baseInjection = new BaseInjection("java");
            baseInjection.setInjectedLanguageId(tempInjectedLanguage.getID());
            List<Pair<PsiLanguageInjectionHost, Language>> list = injectionProcessor.processInjectionWithContext(baseInjection, false);
            for (Pair<PsiLanguageInjectionHost, Language> pair : list) {
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)pair.getFirst();
                Language language = (Language)pair.getSecond();
                InjectorUtils.putInjectedFileUserData((PsiElement)host, language, LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, tempInjectedLanguage);
            }
        } else {
            injectionProcessor.processInjections();
        }
    }

    private static boolean checkUnparsableReference(PsiExpression refExpression) {
        PsiElement parent = refExpression.getParent();
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            IElementType operation = assignmentExpression.getOperationTokenType();
            if (assignmentExpression.getLExpression() == refExpression && JavaTokenType.PLUSEQ.equals(operation)) {
                return true;
            }
        } else if (parent instanceof PsiPolyadicExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression) {
            return true;
        }
        return false;
    }

    private Collection<String> getAnnotatedElementsValue() {
        return InjectionCache.getInstance(this.myProject).getAnnoIndex();
    }

    private Collection<String> getXmlAnnotatedElementsValue() {
        return InjectionCache.getInstance(this.myProject).getXmlIndex();
    }

    public static class InjectionProcessor {
        private final Configuration myConfiguration;
        private final LanguageInjectionSupport mySupport;
        private final PsiElement[] myOperands;
        private boolean myShouldStop;
        private boolean myUnparsable;

        InjectionProcessor(Configuration configuration, LanguageInjectionSupport support, PsiElement ... operands) {
            this.myConfiguration = configuration;
            this.mySupport = support;
            this.myOperands = operands;
        }

        public void processInjections() {
            PsiElement firstOperand = this.myOperands[0];
            PsiElement topBlock = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)firstOperand, null);
            LocalSearchScope searchScope = new LocalSearchScope(new PsiElement[]{topBlock instanceof PsiCodeBlock ? topBlock : firstOperand.getContainingFile()}, "", true);
            ArrayList<PsiElement> places = new ArrayList<PsiElement>(5);
            places.add(firstOperand);
            THashSet visitedVars = new THashSet();
            class MyAnnoVisitor
            implements AnnotationUtilEx.AnnotatedElementVisitor {
                final /* synthetic */ Set val$visitedVars;
                final /* synthetic */ LocalSearchScope val$searchScope;
                final /* synthetic */ List val$places;

                MyAnnoVisitor() {
                    this.val$visitedVars = set;
                    this.val$searchScope = localSearchScope;
                    this.val$places = list;
                }

                @Override
                public boolean visitMethodParameter(PsiExpression expression, PsiCall psiCallExpression) {
                    PsiMethod method;
                    String methodName;
                    PsiExpressionList list = psiCallExpression.getArgumentList();
                    assert (list != null);
                    int index = ArrayUtil.indexOf((Object[])list.getExpressions(), (Object)expression);
                    if (psiCallExpression instanceof PsiMethodCallExpression) {
                        String referenceName = ((PsiMethodCallExpression)psiCallExpression).getMethodExpression().getReferenceName();
                        if ("super".equals(referenceName) || "this".equals(referenceName)) {
                            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiCallExpression, PsiClass.class, (boolean)true);
                            PsiClass psiTargetClass = "super".equals(referenceName) ? (psiClass == null ? null : psiClass.getSuperClass()) : psiClass;
                            methodName = psiTargetClass == null ? null : psiTargetClass.getName();
                        } else {
                            methodName = referenceName;
                        }
                    } else {
                        PsiJavaCodeReferenceElement classRef;
                        methodName = psiCallExpression instanceof PsiNewExpression ? ((classRef = ((PsiNewExpression)psiCallExpression).getClassOrAnonymousClassReference()) == null ? null : classRef.getReferenceName()) : (psiCallExpression instanceof PsiEnumConstant ? ((method = psiCallExpression.resolveMethod()) != null ? method.getName() : null) : null);
                    }
                    if (methodName != null && index >= 0 && InjectionProcessor.this.areThereInjectionsWithName(methodName, false) && (method = psiCallExpression.resolveMethod()) != null) {
                        PsiParameter[] parameters = method.getParameterList().getParameters();
                        if (index < parameters.length) {
                            InjectionProcessor.this.process((PsiModifierListOwner)parameters[index], method, index);
                        } else if (method.isVarArgs()) {
                            InjectionProcessor.this.process((PsiModifierListOwner)parameters[parameters.length - 1], method, parameters.length - 1);
                        }
                    }
                    return false;
                }

                @Override
                public boolean visitMethodReturnStatement(PsiElement source, PsiMethod method) {
                    if (InjectionProcessor.this.areThereInjectionsWithName(method.getName(), false)) {
                        InjectionProcessor.this.process((PsiModifierListOwner)method, method, -1);
                    }
                    return false;
                }

                private void visitVariableUsages(PsiVariable variable) {
                    if (variable == null) {
                        return;
                    }
                    if (InjectionProcessor.this.myConfiguration.getAdvancedConfiguration().getDfaOption() != Configuration.DfaOption.OFF && this.val$visitedVars.add(variable)) {
                        ReferencesSearch.search((PsiElement)variable, (SearchScope)this.val$searchScope).forEach(psiReference -> {
                            PsiElement element = psiReference.getElement();
                            if (element instanceof PsiExpression) {
                                PsiExpression refExpression = (PsiExpression)element;
                                this.val$places.add(refExpression);
                                if (!InjectionProcessor.this.myUnparsable) {
                                    InjectionProcessor.this.myUnparsable = ConcatenationInjector.checkUnparsableReference(refExpression);
                                }
                            }
                            return true;
                        });
                    }
                }

                @Override
                public boolean visitVariable(PsiVariable variable) {
                    PsiVariable anchor;
                    this.visitVariableUsages(variable);
                    Object object = !(variable.getFirstChild() instanceof PsiComment) ? variable : (anchor = variable.getModifierList() != null ? variable.getModifierList() : variable.getTypeElement());
                    if (anchor != null && !this.processCommentInjection((PsiElement)anchor)) {
                        InjectionProcessor.this.myShouldStop = true;
                    } else {
                        InjectionProcessor.this.process((PsiModifierListOwner)variable, null, -1);
                    }
                    return false;
                }

                @Override
                public boolean visitAnnotationParameter(PsiNameValuePair nameValuePair, PsiAnnotation psiAnnotation) {
                    String methodName;
                    String paramName = nameValuePair.getName();
                    String string = methodName = paramName != null ? paramName : "value";
                    if (InjectionProcessor.this.areThereInjectionsWithName(methodName, false)) {
                        PsiElement element;
                        PsiReference reference = nameValuePair.getReference();
                        PsiElement psiElement = element = reference == null ? null : reference.resolve();
                        if (element instanceof PsiMethod) {
                            InjectionProcessor.this.process((PsiModifierListOwner)((PsiMethod)element), (PsiMethod)element, -1);
                        }
                    }
                    return false;
                }

                @Override
                public boolean visitReference(PsiReferenceExpression expression) {
                    if (InjectionProcessor.this.myConfiguration.getAdvancedConfiguration().getDfaOption() == Configuration.DfaOption.OFF) {
                        return true;
                    }
                    PsiElement e = expression.resolve();
                    if (e instanceof PsiVariable) {
                        if (e instanceof PsiParameter) {
                            PsiParameterList parameterList;
                            PsiParameter p = (PsiParameter)e;
                            PsiElement declarationScope = p.getDeclarationScope();
                            PsiMethod method = declarationScope instanceof PsiMethod ? (PsiMethod)declarationScope : null;
                            PsiParameterList psiParameterList = parameterList = method == null ? null : method.getParameterList();
                            if (parameterList != null && parameterList == e.getParent() && InjectionProcessor.this.areThereInjectionsWithName(method.getName(), false)) {
                                int parameterIndex = parameterList.getParameterIndex((PsiParameter)e);
                                InjectionProcessor.this.process((PsiModifierListOwner)e, method, parameterIndex);
                            }
                        }
                        this.visitVariable((PsiVariable)e);
                    }
                    return !InjectionProcessor.this.myShouldStop;
                }

                private boolean processCommentInjection(@NotNull PsiElement anchor) {
                    Ref causeRef = Ref.create();
                    BaseInjection injection = InjectionProcessor.this.mySupport.findCommentInjection(anchor, (Ref<PsiElement>)causeRef);
                    if (injection != null) {
                        PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)anchor, PsiVariable.class);
                        this.visitVariableUsages(variable);
                        return InjectionProcessor.this.processCommentInjectionInner((PsiElement)causeRef.get(), injection);
                    }
                    return true;
                }
            }
            MyAnnoVisitor visitor = new MyAnnoVisitor();
            if (!visitor.processCommentInjection(firstOperand)) {
                return;
            }
            while (!places.isEmpty() && !this.myShouldStop) {
                PsiElement curPlace = (PsiElement)places.remove(0);
                AnnotationUtilEx.visitAnnotatedElements(curPlace, visitor);
            }
        }

        protected boolean processCommentInjectionInner(PsiElement comment, BaseInjection injection) {
            this.processInjectionWithContext(injection, false);
            return false;
        }

        private void process(PsiModifierListOwner owner, PsiMethod method, int paramIndex) {
            if (!this.processAnnotationInjections(owner)) {
                this.myShouldStop = true;
            }
            for (BaseInjection injection : this.myConfiguration.getInjections("java")) {
                if (!injection.acceptsPsiElement((PsiElement)owner) || this.processXmlInjections(injection, owner, method, paramIndex)) continue;
                this.myShouldStop = true;
                break;
            }
        }

        private boolean processAnnotationInjections(PsiModifierListOwner annoElement) {
            PsiElement scope;
            if (annoElement instanceof PsiParameter && (scope = ((PsiParameter)annoElement).getDeclarationScope()) instanceof PsiMethod && !this.areThereInjectionsWithName(((PsiNamedElement)scope).getName(), true)) {
                return true;
            }
            PsiAnnotation[] annotations = AnnotationUtilEx.getAnnotationFrom(annoElement, this.myConfiguration.getAdvancedConfiguration().getLanguageAnnotationPair(), true);
            if (annotations.length > 0) {
                return this.processAnnotationInjectionInner(annoElement, annotations);
            }
            return true;
        }

        protected boolean processAnnotationInjectionInner(PsiModifierListOwner owner, PsiAnnotation[] annotations) {
            String id = AnnotationUtilEx.calcAnnotationValue(annotations, "value");
            String prefix = AnnotationUtilEx.calcAnnotationValue(annotations, "prefix");
            String suffix = AnnotationUtilEx.calcAnnotationValue(annotations, "suffix");
            BaseInjection injection = new BaseInjection("java");
            if (prefix != null) {
                injection.setPrefix(prefix);
            }
            if (suffix != null) {
                injection.setSuffix(suffix);
            }
            if (id != null) {
                injection.setInjectedLanguageId(id);
            }
            this.processInjectionWithContext(injection, false);
            return false;
        }

        protected boolean processXmlInjections(BaseInjection injection, PsiModifierListOwner owner, PsiMethod method, int paramIndex) {
            this.processInjectionWithContext(injection, true);
            return !injection.isTerminal();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        List<Pair<PsiLanguageInjectionHost, Language>> processInjectionWithContext(BaseInjection injection, boolean settingsAvailable) {
            Language language = InjectorUtils.getLanguage(injection);
            if (language == null) {
                return Collections.emptyList();
            }
            boolean separateFiles = !injection.isSingleFile() && StringUtil.isNotEmpty((String)injection.getValuePattern());
            Ref unparsableRef = Ref.create((Object)this.myUnparsable);
            List<Object> objects = ContextComputationProcessor.collectOperands(injection.getPrefix(), injection.getSuffix(), (Ref<Boolean>)unparsableRef, this.myOperands);
            if (objects.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> result = new ArrayList<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>();
            int len = objects.size();
            for (int i = 0; i < len; ++i) {
                void var11_12;
                String curPrefix = null;
                Object object = objects.get(i);
                if (object instanceof String) {
                    curPrefix = (String)object;
                    if (i == len - 1) {
                        return Collections.emptyList();
                    }
                    Object object2 = objects.get(++i);
                }
                String curSuffix = null;
                PsiLanguageInjectionHost curHost = null;
                if (var11_12 instanceof PsiLanguageInjectionHost) {
                    Object next;
                    curHost = (PsiLanguageInjectionHost)var11_12;
                    if (i == len - 2 && (next = objects.get(i + 1)) instanceof String) {
                        ++i;
                        curSuffix = (String)next;
                    }
                }
                if (curHost == null) {
                    unparsableRef.set((Object)Boolean.TRUE);
                    continue;
                }
                if (curHost instanceof PsiLiteralExpression) {
                    List<TextRange> injectedArea = injection.getInjectedArea((PsiElement)curHost);
                    int injectedAreaSize = injectedArea.size();
                    for (int j = 0; j < injectedAreaSize; ++j) {
                        TextRange textRange = injectedArea.get(j);
                        TextRange.assertProperRange((Segment)textRange, (Object)injection);
                        result.add((Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>)Trinity.create((Object)curHost, (Object)InjectedLanguage.create(injection.getInjectedLanguageId(), separateFiles || j == 0 ? curPrefix : "", separateFiles || j == injectedAreaSize - 1 ? curSuffix : "", true), (Object)textRange));
                    }
                    continue;
                }
                TextRange textRange = ElementManipulators.getManipulator((PsiElement)curHost).getRangeInElement((PsiElement)curHost);
                TextRange.assertProperRange((Segment)textRange, (Object)injection);
                result.add((Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>)Trinity.create((Object)curHost, (Object)InjectedLanguage.create(injection.getInjectedLanguageId(), curPrefix, curSuffix, true), (Object)textRange));
            }
            if (result.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Pair<PsiLanguageInjectionHost, Language>> res = new ArrayList<Pair<PsiLanguageInjectionHost, Language>>();
            if (separateFiles) {
                for (Trinity trinity : result) {
                    ContainerUtil.addIfNotNull(res, this.processInjection(language, Collections.singletonList(trinity), settingsAvailable, false));
                }
            } else if (InjectionProcessor.isReferenceInject(language)) {
                for (Trinity trinity : result) {
                    ContainerUtil.addIfNotNull(res, this.processInjection(language, Collections.singletonList(trinity), settingsAvailable, (Boolean)unparsableRef.get()));
                }
            } else {
                ContainerUtil.addIfNotNull(res, this.processInjection(language, result, settingsAvailable, (Boolean)unparsableRef.get()));
            }
            return res;
        }

        private static boolean isReferenceInject(Language language) {
            return LanguageParserDefinitions.INSTANCE.forLanguage(language) == null && ReferenceInjector.findById((String)language.getID()) != null;
        }

        protected Pair<PsiLanguageInjectionHost, Language> processInjection(Language language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, boolean xmlInjection, boolean unparsable) {
            return null;
        }

        protected boolean areThereInjectionsWithName(String methodName, boolean annoOnly) {
            return true;
        }

        public LanguageInjectionSupport getLanguageInjectionSupport() {
            return this.mySupport;
        }
    }
}

