/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.rfb.protocol.MessageQueue;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.transport.Transport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;

public class SenderTask
implements Runnable {
    private final MessageQueue queue;
    private final Transport transport;
    private final Protocol protocol;
    private volatile boolean isRunning = false;

    public SenderTask(MessageQueue messageQueue, Transport transport, Protocol protocol) {
        this.queue = messageQueue;
        this.transport = transport;
        this.protocol = protocol;
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                ClientToServerMessage message = this.queue.get();
                if (message == null) continue;
                message.send(this.transport);
            }
            catch (InterruptedException e) {
            }
            catch (TransportException e) {
                String string = String.valueOf(e.getMessage());
                Logger.getLogger(this.getClass().getName()).severe(string.length() != 0 ? "Close session: ".concat(string) : new String("Close session: "));
                if (this.isRunning) {
                    this.protocol.cleanUpSession("Connection closed");
                }
                this.stopTask();
            }
            catch (Throwable te) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                te.printStackTrace(pw);
                if (this.isRunning) {
                    String string = String.valueOf(te.getMessage());
                    String string2 = String.valueOf(sw.toString());
                    this.protocol.cleanUpSession(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("\n").append(string2).toString());
                }
                this.stopTask();
            }
        }
    }

    public void stopTask() {
        this.isRunning = false;
    }
}

