/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.mac;

import com.glavsoft.utils.LazyLoaded;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;

public class MacUtils {
    private static LazyLoaded<Boolean> isMac = new LazyLoaded<Boolean>(new LazyLoaded.Loader<Boolean>(){

        @Override
        public Boolean load() {
            try {
                Class.forName("com.apple.eawt.Application");
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    });

    public static boolean isMac() {
        return isMac.get();
    }

    public static Image getIconImage() {
        URL resource = MacUtils.class.getResource("/com/glavsoft/viewer/images/tightvnc-logo-128x128.png");
        return resource != null ? Toolkit.getDefaultToolkit().createImage(resource) : null;
    }

    public static void setName(String name) {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", name);
    }
}

