/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript;

import com.intellij.configurationScript.LightweightComposer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"IDE_FILE", "", "IDE_FILE_VARIANT_2", "doRead", "Lorg/yaml/snakeyaml/nodes/MappingNode;", "reader", "Ljava/io/Reader;", "findConfigurationFile", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "isConfigurationFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.configurationScript"})
public final class ConfigurationFileManagerKt {
    @NotNull
    public static final String IDE_FILE = "intellij.yaml";
    @NotNull
    public static final String IDE_FILE_VARIANT_2 = "intellij.yml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final MappingNode doRead(@NotNull Reader reader) {
        Closeable closeable = reader;
        Throwable throwable = null;
        try {
            Reader it = (Reader)closeable;
            boolean bl = false;
            Node node = new LightweightComposer((Parser)new ParserImpl(new StreamReader(it))).getSingleNode();
            if (!(node instanceof MappingNode)) {
                node = null;
            }
            MappingNode mappingNode = (MappingNode)node;
            return mappingNode;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final boolean isConfigurationFile(@NotNull VirtualFile file) {
        CharSequence nameSequence = file.getNameSequence();
        return StringUtil.equals((CharSequence)nameSequence, (CharSequence)IDE_FILE) || StringUtil.equals((CharSequence)nameSequence, (CharSequence)IDE_FILE_VARIANT_2);
    }

    private static final Path findConfigurationFile(Project project) {
        String string = project.getBasePath();
        if (string == null) {
            return null;
        }
        Path projectIdeaDir = Paths.get(string, new String[0]);
        Path file = projectIdeaDir.resolve(IDE_FILE);
        if (!file.toFile().exists()) {
            file = projectIdeaDir.resolve(IDE_FILE_VARIANT_2);
        }
        return file;
    }

    public static final /* synthetic */ Path access$findConfigurationFile(Project project) {
        return ConfigurationFileManagerKt.findConfigurationFile(project);
    }
}

