/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript;

import com.intellij.configurationScript.MyComposerException;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.parser.Parser;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\u0016\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u0017\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u0018\u001a\u0004\u0018\u00010\bJ\b\u0010\u0019\u001a\u00020\bH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/configurationScript/LightweightComposer;", "", "parser", "Lorg/yaml/snakeyaml/parser/Parser;", "(Lorg/yaml/snakeyaml/parser/Parser;)V", "anchors", "Lgnu/trove/THashMap;", "", "Lorg/yaml/snakeyaml/nodes/Node;", "recursiveNodes", "Lgnu/trove/THashSet;", "composeMappingChildren", "", "children", "", "Lorg/yaml/snakeyaml/nodes/NodeTuple;", "node", "Lorg/yaml/snakeyaml/nodes/MappingNode;", "composeMappingNode", "anchor", "composeNode", "parent", "composeScalarNode", "composeSequenceNode", "getSingleNode", "readNode", "intellij.configurationScript"})
public final class LightweightComposer {
    private final THashMap<String, Node> anchors;
    private final THashSet<Node> recursiveNodes;
    private final Parser parser;

    private final Node readNode() {
        this.parser.getEvent();
        Node node = this.composeNode(null);
        this.parser.getEvent();
        this.anchors.clear();
        this.recursiveNodes.clear();
        return node;
    }

    @Nullable
    public final Node getSingleNode() {
        this.parser.getEvent();
        Node document = null;
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            document = this.readNode();
        }
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            Event event = this.parser.getEvent();
            Node node = document;
            if (node == null) {
                Intrinsics.throwNpe();
            }
            throw (Throwable)((Object)new MyComposerException("expected a single document in the stream", node.getStartMark(), "but found another document", event.getStartMark()));
        }
        this.parser.getEvent();
        return document;
    }

    private final Node composeNode(Node parent) {
        if (parent != null) {
            this.recursiveNodes.add((Object)parent);
        }
        Event event = this.parser.peekEvent();
        Node node = null;
        if (event instanceof AliasEvent) {
            String anchor = ((AliasEvent)event).getAnchor();
            Node node2 = (Node)this.anchors.get((Object)anchor);
            if (node2 == null) {
                throw (Throwable)((Object)new MyComposerException(null, null, "found undefined alias " + anchor, ((AliasEvent)event).getStartMark()));
            }
            node = node2;
            if (this.recursiveNodes.remove((Object)node)) {
                node.setTwoStepsConstruction(true);
            }
        } else {
            Event event2 = event;
            if (event2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.yaml.snakeyaml.events.NodeEvent");
            }
            String anchor = ((NodeEvent)event2).getAnchor();
            node = event.is(Event.ID.Scalar) ? this.composeScalarNode(anchor) : (event.is(Event.ID.SequenceStart) ? this.composeSequenceNode(anchor) : this.composeMappingNode(anchor));
        }
        this.recursiveNodes.remove((Object)parent);
        return node;
    }

    private final Node composeScalarNode(String anchor) {
        Event event = this.parser.getEvent();
        if (event == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.yaml.snakeyaml.events.ScalarEvent");
        }
        ScalarEvent event2 = (ScalarEvent)event;
        ScalarNode node = new ScalarNode(Tag.STR, false, event2.getValue(), null, null, event2.getStyle());
        if (anchor != null) {
            Map map2 = (Map)this.anchors;
            map2.put(anchor, node);
        }
        return (Node)node;
    }

    private final Node composeSequenceNode(String anchor) {
        Event event = this.parser.getEvent();
        if (event == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.yaml.snakeyaml.events.SequenceStartEvent");
        }
        SequenceStartEvent startEvent = (SequenceStartEvent)event;
        ArrayList<Node> children = new ArrayList<Node>();
        SequenceNode node = new SequenceNode(Tag.SEQ, false, (List)children, null, null, startEvent.getFlowStyle());
        if (anchor != null) {
            this.anchors.put((Object)anchor, (Object)node);
        }
        while (!this.parser.checkEvent(Event.ID.SequenceEnd)) {
            children.add(this.composeNode((Node)node));
        }
        this.parser.getEvent();
        return (Node)node;
    }

    private final Node composeMappingNode(String anchor) {
        Event event = this.parser.getEvent();
        if (event == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.yaml.snakeyaml.events.MappingStartEvent");
        }
        MappingStartEvent startEvent = (MappingStartEvent)event;
        ArrayList children = new ArrayList();
        MappingNode node = new MappingNode(Tag.MAP, false, (List)children, null, null, startEvent.getFlowStyle());
        if (anchor != null) {
            this.anchors.put((Object)anchor, (Object)node);
        }
        while (!this.parser.checkEvent(Event.ID.MappingEnd)) {
            this.composeMappingChildren(children, node);
        }
        this.parser.getEvent();
        return (Node)node;
    }

    private final void composeMappingChildren(List<NodeTuple> children, MappingNode node) {
        Node itemKey = this.composeNode((Node)node);
        if (Intrinsics.areEqual((Object)itemKey.getTag(), (Object)Tag.MERGE)) {
            node.setMerged(true);
        }
        Node itemValue = this.composeNode((Node)node);
        children.add(new NodeTuple(itemKey, itemValue));
    }

    public LightweightComposer(@NotNull Parser parser) {
        this.parser = parser;
        this.anchors = new THashMap();
        this.recursiveNodes = new THashSet();
    }
}

