/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript;

import com.intellij.configurationScript.IntellijConfigurationJsonSchemaProviderFactoryKt;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\u001a&\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\\\u0010\b\u001a\u00020\t2Q\u0010\n\u001aM\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\t0\u000bH\u0080\b\u001aq\u0010\u0011\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0012\u001a\u00020\u00012K\u0010\n\u001aG\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\t0\u000bH\u0082\b\u00a2\u0006\u0002\u0010\u0015\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0018"}, d2={"idToPropertyName", "", "string", "", "configurationType", "Lcom/intellij/execution/configurations/ConfigurationType;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "processConfigurationTypes", "", "processor", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "propertyName", "", "factories", "processFactories", "typeDefinitionId", "factoryPropertyName", "factoryDefinitionId", "([Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/CharSequence;Lkotlin/jvm/functions/Function3;)V", "rcFactoryIdToPropertyName", "rcTypeIdToPropertyName", "intellij.configurationScript"})
public final class RunConfigurationJsonSchemaGeneratorKt {
    public static final void processConfigurationTypes(@NotNull Function3<? super ConfigurationType, ? super CharSequence, ? super ConfigurationFactory[], Unit> processor) {
        int $i$f$processConfigurationTypes = 0;
        List configurationTypes = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
        for (ConfigurationType type : configurationTypes) {
            CharSequence propertyName;
            ConfigurationFactory[] factories;
            if (RunConfigurationJsonSchemaGeneratorKt.rcTypeIdToPropertyName(type) == null) {
                continue;
            }
            ConfigurationFactory[] configurationFactoryArray = factories = type.getConfigurationFactories();
            if (configurationFactoryArray.length == 0) {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration type \"" + type.getDisplayName() + "\" is not valid: factory list is empty");
                continue;
            }
            processor.invoke((Object)type, (Object)propertyName, (Object)factories);
        }
    }

    private static final void processFactories(ConfigurationFactory[] factories, CharSequence typeDefinitionId, Function3<? super CharSequence, ? super CharSequence, ? super ConfigurationFactory, Unit> processor) {
        int $i$f$processFactories = 0;
        for (ConfigurationFactory factory : factories) {
            CharSequence factoryPropertyName;
            if (RunConfigurationJsonSchemaGeneratorKt.rcFactoryIdToPropertyName(factory) == null) {
                continue;
            }
            String factoryDefinitionId = "" + typeDefinitionId + '-' + factoryPropertyName;
            processor.invoke((Object)factoryPropertyName, (Object)factoryDefinitionId, (Object)factory);
        }
    }

    @Nullable
    public static final CharSequence rcTypeIdToPropertyName(@NotNull ConfigurationType configurationType) {
        CharSequence charSequence = RunConfigurationJsonSchemaGeneratorKt.idToPropertyName(configurationType.getTag(), configurationType, null);
        if (charSequence == null) {
            return null;
        }
        CharSequence result = charSequence;
        if (StringUtil.equals((CharSequence)result, (CharSequence)"templates")) {
            IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration type \"" + configurationType.getDisplayName() + "\" has forbidden id");
        }
        return result;
    }

    @Nullable
    public static final CharSequence rcFactoryIdToPropertyName(@NotNull ConfigurationFactory factory) {
        return RunConfigurationJsonSchemaGeneratorKt.idToPropertyName(factory.getId(), null, factory);
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence idToPropertyName(String string, ConfigurationType configurationType, ConfigurationFactory factory) {
        char c;
        StringBuilder stringBuilder;
        char ch22;
        if (Intrinsics.areEqual((Object)string, (Object)"JetRunConfigurationType")) {
            return "kotlin";
        }
        String result = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string, (CharSequence)"Type"), (CharSequence)"RunConfiguration"), (CharSequence)"Configuration");
        CharSequence charSequence = result;
        if (charSequence.length() == 0) {
            if (factory == null) {
                Logger logger = IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG();
                StringBuilder stringBuilder2 = new StringBuilder().append("Configuration type \"");
                ConfigurationType configurationType2 = configurationType;
                if (configurationType2 == null) {
                    Intrinsics.throwNpe();
                }
                logger.error(stringBuilder2.append(configurationType2.getDisplayName()).append("\" is not valid: id is empty").toString());
            } else {
                IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration factory \"" + factory.getName() + "\" is not valid: id is empty");
            }
            return null;
        }
        StringBuilder builder = null;
        int i = 0;
        boolean isAllUpperCased = true;
        while (i < result.length()) {
            char c2;
            ch22 = result.charAt(i);
            if (ch22 == '.' || ch22 == ' ' || ch22 == '-' || ch22 == '_') {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(result, 0, i);
                }
                if (++i == result.length()) break;
                c2 = result.charAt(i);
                stringBuilder = builder;
                c = Character.toUpperCase(c2);
                stringBuilder.append(c);
                ++i;
                continue;
            }
            if (ch22 == '#') {
                ++i;
                continue;
            }
            if (ch22 == '\"' || ch22 == '\'' || ch22 == '\n' || ch22 == '\r' || ch22 == '\t' || ch22 == '\b' || ch22 == '/' || ch22 == '\\') {
                if (factory == null) {
                    Logger logger = IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG();
                    StringBuilder stringBuilder3 = new StringBuilder().append("Configuration type \"");
                    ConfigurationType configurationType3 = configurationType;
                    if (configurationType3 == null) {
                        Intrinsics.throwNpe();
                    }
                    logger.error(stringBuilder3.append(configurationType3.getId()).append("\" is not valid: contains invalid symbol \"").append(ch22).append('\"').toString());
                } else {
                    IntellijConfigurationJsonSchemaProviderFactoryKt.getLOG().error("Configuration factory \"" + factory.getName() + "\" is not valid: contains invalid symbol \"" + ch22 + '\"');
                }
                return null;
            }
            if (i == 0) {
                c2 = ch22;
                if (Character.isUpperCase(c2)) {
                    if (builder == null) {
                        builder = new StringBuilder();
                        builder.append(result, 0, i);
                    }
                    c2 = ch22;
                    stringBuilder = builder;
                    c = Character.toLowerCase(c2);
                    stringBuilder.append(c);
                } else {
                    isAllUpperCased = false;
                }
            } else if (builder != null) {
                builder.append(ch22);
            }
            c2 = ch22;
            if (!Character.isUpperCase(c2)) {
                isAllUpperCased = false;
            }
            ++i;
        }
        if (isAllUpperCased) {
            if (builder == null) {
                String ch22;
                String string2 = ch22 = result;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                return string3;
            }
            ch22 = '\u0000';
            int n = builder.length();
            while (ch22 < n) {
                void i2;
                char c2 = builder.charAt((int)i2);
                c = i2++;
                stringBuilder = builder;
                char c3 = Character.toLowerCase(c2);
                stringBuilder.setCharAt(c, c3);
            }
            return builder;
        }
        StringBuilder stringBuilder4 = builder;
        return stringBuilder4 != null ? (CharSequence)stringBuilder4 : (CharSequence)result;
    }

    public static final /* synthetic */ void access$processFactories(ConfigurationFactory[] factories, CharSequence typeDefinitionId, Function3 processor) {
        RunConfigurationJsonSchemaGeneratorKt.processFactories(factories, typeDefinitionId, (Function3<? super CharSequence, ? super CharSequence, ? super ConfigurationFactory, Unit>)processor);
    }
}

