/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.value.DexBackedEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;

public abstract class EncodedArrayItemIterator {
    public static final EncodedArrayItemIterator EMPTY = new EncodedArrayItemIterator(){

        @Override
        @Nullable
        public EncodedValue getNextOrNull() {
            return null;
        }

        @Override
        public void skipNext() {
        }

        @Override
        public int getReaderOffset() {
            return 0;
        }

        @Override
        public int getItemCount() {
            return 0;
        }
    };

    @Nullable
    public abstract EncodedValue getNextOrNull();

    public abstract void skipNext();

    public abstract int getReaderOffset();

    public abstract int getItemCount();

    @Nonnull
    public static EncodedArrayItemIterator newOrEmpty(@Nonnull DexBackedDexFile dexFile, int offset) {
        if (offset == 0) {
            return EMPTY;
        }
        return new EncodedArrayItemIteratorImpl(dexFile, offset);
    }

    private static class EncodedArrayItemIteratorImpl
    extends EncodedArrayItemIterator {
        @Nonnull
        private final DexReader reader;
        private final int size;
        private int index = 0;

        public EncodedArrayItemIteratorImpl(@Nonnull DexBackedDexFile dexFile, int offset) {
            this.reader = dexFile.readerAt(offset);
            this.size = this.reader.readSmallUleb128();
        }

        @Override
        @Nullable
        public EncodedValue getNextOrNull() {
            if (this.index < this.size) {
                ++this.index;
                return DexBackedEncodedValue.readFrom(this.reader);
            }
            return null;
        }

        @Override
        public void skipNext() {
            if (this.index < this.size) {
                ++this.index;
                DexBackedEncodedValue.skipFrom(this.reader);
            }
        }

        @Override
        public int getReaderOffset() {
            return this.reader.getOffset();
        }

        @Override
        public int getItemCount() {
            return this.size;
        }
    }
}

