/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodHandleReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.writer.MethodHandleSection;
import org.jf.dexlib2.writer.builder.BaseBuilderPool;
import org.jf.dexlib2.writer.builder.BuilderFieldReference;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderMethodHandleReference;
import org.jf.dexlib2.writer.builder.BuilderMethodReference;
import org.jf.dexlib2.writer.builder.BuilderReference;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.util.ExceptionWithContext;

public class BuilderMethodHandlePool
extends BaseBuilderPool
implements MethodHandleSection<BuilderMethodHandleReference, BuilderFieldReference, BuilderMethodReference> {
    @Nonnull
    private final ConcurrentMap<MethodHandleReference, BuilderMethodHandleReference> internedItems = Maps.newConcurrentMap();

    public BuilderMethodHandlePool(@Nonnull DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    public BuilderMethodHandleReference internMethodHandle(MethodHandleReference methodHandleReference) {
        BuilderReference memberReference;
        BuilderMethodHandleReference internedMethodHandle = (BuilderMethodHandleReference)this.internedItems.get(methodHandleReference);
        if (internedMethodHandle != null) {
            return internedMethodHandle;
        }
        switch (methodHandleReference.getMethodHandleType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                memberReference = this.dexBuilder.internFieldReference((FieldReference)methodHandleReference.getMemberReference());
                break;
            }
            case 4: 
            case 5: {
                memberReference = this.dexBuilder.internMethodReference((MethodReference)methodHandleReference.getMemberReference());
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid method handle type: %d", new Object[]{methodHandleReference.getMethodHandleType()});
            }
        }
        internedMethodHandle = new BuilderMethodHandleReference(methodHandleReference.getMethodHandleType(), memberReference);
        BuilderMethodHandleReference prev = this.internedItems.putIfAbsent(internedMethodHandle, internedMethodHandle);
        return prev == null ? internedMethodHandle : prev;
    }

    @Override
    public BuilderFieldReference getFieldReference(BuilderMethodHandleReference methodHandleReference) {
        return (BuilderFieldReference)methodHandleReference.getMemberReference();
    }

    @Override
    public BuilderMethodReference getMethodReference(BuilderMethodHandleReference methodHandleReference) {
        return (BuilderMethodReference)methodHandleReference.getMemberReference();
    }

    @Override
    public int getItemIndex(@Nonnull BuilderMethodHandleReference builderMethodHandleReference) {
        return builderMethodHandleReference.index;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderMethodHandleReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderMethodHandleReference>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderMethodHandleReference builderMethodHandleReference) {
                return builderMethodHandleReference.index;
            }

            @Override
            protected int setValue(@Nonnull BuilderMethodHandleReference builderMethodHandleReference, int value) {
                int prev = builderMethodHandleReference.index;
                builderMethodHandleReference.index = value;
                return prev;
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }
}

