/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public abstract class AbstractExtensionPointBean
implements PluginAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.extensions.AbstractExtensionPointBean");
    protected PluginDescriptor myPluginDescriptor;

    @Transient
    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @Override
    public final void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.myPluginDescriptor = pluginDescriptor;
    }

    @Nullable
    public PluginId getPluginId() {
        return this.myPluginDescriptor == null ? null : this.myPluginDescriptor.getPluginId();
    }

    @NotNull
    public final <T> Class<T> findClass(@NotNull String className) throws ClassNotFoundException {
        return AbstractExtensionPointBean.findClass(className, this.myPluginDescriptor);
    }

    @NotNull
    public static <T> Class<T> findClass(@NotNull String className, @Nullable PluginDescriptor pluginDescriptor) throws ClassNotFoundException {
        ClassLoader classLoader = pluginDescriptor == null ? AbstractExtensionPointBean.class.getClassLoader() : pluginDescriptor.getPluginClassLoader();
        return Class.forName(className, true, classLoader);
    }

    @Nullable
    public final <T> Class<T> findClassNoExceptions(String className) {
        try {
            return this.findClass(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Problem loading class " + className + " from plugin " + this.myPluginDescriptor.getPluginId().getIdString(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public ClassLoader getLoaderForClass() {
        return this.myPluginDescriptor == null ? this.getClass().getClassLoader() : this.myPluginDescriptor.getPluginClassLoader();
    }

    @NotNull
    public final <T> T instantiate(@NotNull String className, @NotNull PicoContainer container) throws ClassNotFoundException {
        return AbstractExtensionPointBean.instantiate(this.findClass(className), container);
    }

    @NotNull
    public static <T> T instantiate(@NotNull Class<T> aClass, @NotNull PicoContainer container) {
        return AbstractExtensionPointBean.instantiate(aClass, container, true);
    }

    @NotNull
    public static <T> T instantiate(@NotNull Class<T> aClass, @NotNull PicoContainer container, boolean allowNonPublicClasses) {
        CachingConstructorInjectionComponentAdapter adapter = new CachingConstructorInjectionComponentAdapter(aClass.getName(), aClass, null, allowNonPublicClasses);
        Object t = adapter.getComponentInstance(container);
        return (T)t;
    }
}

