/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseExtensionPointName {
    private final String myName;

    public BaseExtensionPointName(@NotNull String name) {
        this.myName = name;
    }

    @NotNull
    public final String getName() {
        return this.myName;
    }

    public final String toString() {
        return this.myName;
    }

    @Nullable
    protected static <T> T findExtension(@NotNull BaseExtensionPointName pointName, @NotNull Class<T> instanceOf, @Nullable AreaInstance areaInstance, boolean isRequired) {
        ExtensionPoint point = Extensions.getArea(areaInstance).getExtensionPoint(pointName.getName());
        List list = point.getExtensionList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object object = list.get(i);
            if (!instanceOf.isInstance(object)) continue;
            return object;
        }
        if (isRequired) {
            String message = "could not find extension implementation " + instanceOf;
            if (((ExtensionPointImpl)point).isInReadOnlyMode()) {
                message = message + " (point in read-only mode)";
            }
            throw new IllegalArgumentException(message);
        }
        return null;
    }
}

