/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionPointName<T>
extends BaseExtensionPointName {
    public ExtensionPointName(@NotNull String name) {
        super(name);
    }

    @NotNull
    public static <T> ExtensionPointName<T> create(@NotNull @NonNls String name) {
        return new ExtensionPointName<T>(name);
    }

    @NotNull
    public T[] getExtensions() {
        return this.getPoint(null).getExtensions();
    }

    @NotNull
    public List<T> getExtensionList() {
        return this.getPoint(null).getExtensionList();
    }

    @NotNull
    public Stream<T> extensions() {
        return this.getPoint(null).extensions();
    }

    public boolean hasAnyExtensions() {
        return this.getPoint(null).hasAnyExtensions();
    }

    @NotNull
    public List<T> getExtensionList(@Nullable AreaInstance areaInstance) {
        return this.getPoint(areaInstance).getExtensionList();
    }

    @NotNull
    public T[] getExtensions(@Nullable AreaInstance areaInstance) {
        return this.getPoint(areaInstance).getExtensions();
    }

    @NotNull
    public Stream<T> extensions(@Nullable AreaInstance areaInstance) {
        return this.getPoint(areaInstance).extensions();
    }

    @NotNull
    public ExtensionPoint<T> getPoint(@Nullable AreaInstance areaInstance) {
        return Extensions.getArea(areaInstance).getExtensionPoint(this.getName());
    }

    @Nullable
    public <V extends T> V findExtension(@NotNull Class<V> instanceOf) {
        return ExtensionPointName.findExtension(this, instanceOf, null, false);
    }

    @NotNull
    public <V extends T> V findExtensionOrFail(@NotNull Class<V> instanceOf) {
        return ExtensionPointName.findExtension(this, instanceOf, null, true);
    }
}

