/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class Extensions {
    public static final ExtensionPointName<AreaListener> AREA_LISTENER_EXTENSION_POINT = new ExtensionPointName("com.intellij.arealistener");
    private static final Map<AreaInstance, ExtensionsAreaImpl> ourAreaInstance2area = ContainerUtil.newConcurrentMap();
    private static final Map<String, AreaClassConfiguration> ourAreaClass2Configuration = ContainerUtil.newConcurrentMap();
    @NotNull
    private static ExtensionsAreaImpl ourRootArea = Extensions.createRootArea();

    private Extensions() {
    }

    @NotNull
    private static ExtensionsAreaImpl createRootArea() {
        ExtensionsAreaImpl rootArea = new ExtensionsAreaImpl(null, null, null);
        rootArea.registerExtensionPoint(new InterfaceExtensionPoint<AreaListener>(AREA_LISTENER_EXTENSION_POINT.getName(), AreaListener.class, rootArea));
        return rootArea;
    }

    @NotNull
    public static ExtensionsArea getRootArea() {
        return ourRootArea;
    }

    @NotNull
    public static ExtensionsArea getArea(@Nullable(value="null means root") AreaInstance areaInstance) {
        if (areaInstance == null) {
            return ourRootArea;
        }
        ExtensionsAreaImpl area = ourAreaInstance2area.get(areaInstance);
        if (area == null) {
            throw new IllegalArgumentException("No area instantiated for: " + areaInstance);
        }
        return area;
    }

    public static void cleanRootArea(@NotNull Disposable parentDisposable) {
        ExtensionsAreaImpl newArea;
        ExtensionsAreaImpl oldRootArea = (ExtensionsAreaImpl)Extensions.getRootArea();
        ourRootArea = newArea = Extensions.createRootArea();
        oldRootArea.notifyAreaReplaced(newArea);
        Disposer.register((Disposable)parentDisposable, () -> {
            ourRootArea = oldRootArea;
            newArea.notifyAreaReplaced(oldRootArea);
        });
    }

    @NotNull
    public static Object[] getExtensions(@NonNls @NotNull String extensionPointName) {
        return Extensions.getExtensions(extensionPointName, null);
    }

    @Deprecated
    @NotNull
    public static <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        return extensionPointName.getExtensions();
    }

    @Deprecated
    @NotNull
    public static <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName, @Nullable AreaInstance areaInstance) {
        return extensionPointName.getExtensions(areaInstance);
    }

    @NotNull
    public static <T> T[] getExtensions(@NotNull String extensionPointName, @Nullable(value="null means root") AreaInstance areaInstance) {
        ExtensionsArea area = Extensions.getArea(areaInstance);
        ExtensionPoint extensionPoint = area.getExtensionPoint(extensionPointName);
        return extensionPoint.getExtensions();
    }

    @Deprecated
    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<U> extClass) {
        return extensionPointName.findExtensionOrFail(extClass);
    }

    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, AreaInstance areaInstance, @NotNull Class<U> extClass) {
        for (T t : extensionPointName.getExtensions(areaInstance)) {
            if (!extClass.isInstance(t)) continue;
            return (U)t;
        }
        throw new IllegalArgumentException("could not find extension implementation " + extClass);
    }

    public static void instantiateArea(@NonNls @NotNull String areaClass, @NotNull AreaInstance areaInstance, @Nullable(value="null means root") AreaInstance parentAreaInstance) {
        AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
        if (configuration == null) {
            throw new IllegalArgumentException("Area class is not registered: " + areaClass);
        }
        ExtensionsArea parentArea = Extensions.getArea(parentAreaInstance);
        if (!Objects.equals(parentArea.getAreaClass(), configuration.getParentClassName())) {
            throw new IllegalArgumentException("Wrong parent area. Expected class: " + configuration.getParentClassName() + " actual class: " + parentArea.getAreaClass());
        }
        ExtensionsAreaImpl area = new ExtensionsAreaImpl(areaClass, areaInstance, (PicoContainer)parentArea.getPicoContainer());
        if (ourAreaInstance2area.put(areaInstance, area) != null) {
            throw new IllegalArgumentException("Area already instantiated for: " + areaInstance);
        }
        for (AreaListener listener : Extensions.getAreaListeners()) {
            listener.areaCreated(areaClass, areaInstance);
        }
    }

    @NotNull
    private static List<AreaListener> getAreaListeners() {
        return Extensions.getRootArea().getExtensionPoint(AREA_LISTENER_EXTENSION_POINT).getExtensionList();
    }

    public static void registerAreaClass(@NonNls @NotNull String areaClass, @Nullable @NonNls String parentAreaClass) {
        if (ourAreaClass2Configuration.containsKey(areaClass)) {
            AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
            if (!Objects.equals(configuration.getParentClassName(), parentAreaClass)) {
                throw new RuntimeException("Area class already registered: " + areaClass + ", " + configuration);
            }
            return;
        }
        AreaClassConfiguration configuration = new AreaClassConfiguration(areaClass, parentAreaClass);
        ourAreaClass2Configuration.put(areaClass, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeArea(@NotNull AreaInstance areaInstance) {
        assert (ourAreaInstance2area.containsKey(areaInstance));
        String areaClass = ourAreaInstance2area.get(areaInstance).getAreaClass();
        if (areaClass == null) {
            throw new IllegalArgumentException("Area class is null (area never instantiated?). Instance: " + areaInstance);
        }
        try {
            for (AreaListener listener : Extensions.getAreaListeners()) {
                listener.areaDisposing(areaClass, areaInstance);
            }
        }
        finally {
            ourAreaInstance2area.remove(areaInstance);
        }
    }

    public static boolean isComponentSuitableForOs(@Nullable String os) {
        if (StringUtil.isEmpty((String)os)) {
            return true;
        }
        if (os.equals("mac")) {
            return SystemInfoRt.isMac;
        }
        if (os.equals("linux")) {
            return SystemInfoRt.isLinux;
        }
        if (os.equals("windows")) {
            return SystemInfoRt.isWindows;
        }
        if (os.equals("unix")) {
            return SystemInfoRt.isUnix;
        }
        if (os.equals("freebsd")) {
            return SystemInfoRt.isFreeBSD;
        }
        throw new IllegalArgumentException("Unknown OS " + os);
    }

    private static class AreaClassConfiguration {
        private final String myClassName;
        private final String myParentClassName;

        private AreaClassConfiguration(@NotNull String className, String parentClassName) {
            this.myClassName = className;
            this.myParentClassName = parentClassName;
        }

        @NotNull
        public String getClassName() {
            return this.myClassName;
        }

        public String getParentClassName() {
            return this.myParentClassName;
        }

        public String toString() {
            return "AreaClassConfiguration{myClassName='" + this.myClassName + '\'' + ", myParentClassName='" + this.myParentClassName + "'}";
        }
    }
}

