/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.SortingException;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingOrder {
    @NonNls
    public static final String FIRST_STR = "first";
    @NonNls
    public static final String LAST_STR = "last";
    @NonNls
    public static final String BEFORE_STR = "before ";
    @NonNls
    public static final String BEFORE_STR_OLD = "before:";
    @NonNls
    public static final String AFTER_STR = "after ";
    @NonNls
    public static final String AFTER_STR_OLD = "after:";
    @NonNls
    public static final String ORDER_RULE_SEPARATOR = ",";
    public static final LoadingOrder ANY = new LoadingOrder();
    public static final LoadingOrder FIRST = new LoadingOrder("first");
    public static final LoadingOrder LAST = new LoadingOrder("last");
    @NonNls
    private final String myName;
    private final boolean myFirst;
    private final boolean myLast;
    private final Set<String> myBefore = new LinkedHashSet<String>(2);
    private final Set<String> myAfter = new LinkedHashSet<String>(2);

    private LoadingOrder() {
        this.myName = "ANY";
        this.myFirst = false;
        this.myLast = false;
    }

    private LoadingOrder(@NonNls @NotNull String text) {
        this.myName = text;
        boolean last = false;
        boolean first = false;
        for (String string : StringUtil.split((String)text, (String)ORDER_RULE_SEPARATOR)) {
            String trimmed = string.trim();
            if (trimmed.equalsIgnoreCase(FIRST_STR)) {
                first = true;
                continue;
            }
            if (trimmed.equalsIgnoreCase(LAST_STR)) {
                last = true;
                continue;
            }
            if (StringUtil.startsWithIgnoreCase((String)trimmed, (String)BEFORE_STR)) {
                this.myBefore.add(trimmed.substring(BEFORE_STR.length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase((String)trimmed, (String)BEFORE_STR_OLD)) {
                this.myBefore.add(trimmed.substring(BEFORE_STR_OLD.length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase((String)trimmed, (String)AFTER_STR)) {
                this.myAfter.add(trimmed.substring(AFTER_STR.length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase((String)trimmed, (String)AFTER_STR_OLD)) {
                this.myAfter.add(trimmed.substring(AFTER_STR_OLD.length()).trim());
                continue;
            }
            throw new AssertionError((Object)("Invalid specification: " + trimmed + "; should be one of FIRST, LAST, BEFORE <id> or AFTER <id>"));
        }
        this.myFirst = first;
        this.myLast = last;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadingOrder)) {
            return false;
        }
        LoadingOrder that = (LoadingOrder)o;
        if (this.myFirst != that.myFirst) {
            return false;
        }
        if (this.myLast != that.myLast) {
            return false;
        }
        if (!this.myAfter.equals(that.myAfter)) {
            return false;
        }
        return this.myBefore.equals(that.myBefore);
    }

    public int hashCode() {
        int result = this.myFirst ? 1 : 0;
        result = 31 * result + (this.myLast ? 1 : 0);
        result = 31 * result + this.myBefore.hashCode();
        result = 31 * result + this.myAfter.hashCode();
        return result;
    }

    public static LoadingOrder before(@NonNls String id) {
        return new LoadingOrder(BEFORE_STR + id);
    }

    public static LoadingOrder after(@NonNls String id) {
        return new LoadingOrder(AFTER_STR + id);
    }

    public static void sort(@NotNull Orderable[] orderable) {
        if (orderable.length > 1) {
            LoadingOrder.sort(Arrays.asList(orderable));
        }
    }

    public static void sort(final @NotNull List<? extends Orderable> orderable) {
        if (orderable.size() < 2) {
            return;
        }
        final LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        final LinkedHashMap cachedMap = ContainerUtil.newLinkedHashMap();
        final LinkedHashSet<Orderable> first = new LinkedHashSet<Orderable>(1);
        final LinkedHashSet<Orderable> hasBefore = new LinkedHashSet<Orderable>(orderable.size());
        for (Orderable orderable2 : orderable) {
            LoadingOrder order;
            String id = orderable2.getOrderId();
            if (StringUtil.isNotEmpty((String)id)) {
                map.put(id, orderable2);
            }
            if ((order = orderable2.getOrder()) == ANY) continue;
            cachedMap.put(orderable2, order);
            if (order.myFirst) {
                first.add(orderable2);
            }
            if (order.myBefore.isEmpty()) continue;
            hasBefore.add(orderable2);
        }
        if (cachedMap.isEmpty()) {
            return;
        }
        InboundSemiGraph<Orderable> graph = new InboundSemiGraph<Orderable>(){

            @NotNull
            public Collection<Orderable> getNodes() {
                ArrayList list = ContainerUtil.newArrayList((Iterable)orderable);
                Collections.reverse(list);
                return list;
            }

            @NotNull
            public Iterator<Orderable> getIn(Orderable n) {
                LoadingOrder hisOrder;
                LoadingOrder order = cachedMap.getOrDefault(n, ANY);
                LinkedHashSet<Orderable> predecessors = new LinkedHashSet<Orderable>();
                for (String id : order.myAfter) {
                    Orderable o = (Orderable)map.get(id);
                    if (o == null) continue;
                    predecessors.add(o);
                }
                String id = n.getOrderId();
                if (StringUtil.isNotEmpty((String)id)) {
                    for (Orderable o : hasBefore) {
                        hisOrder = cachedMap.getOrDefault(o, ANY);
                        if (!hisOrder.myBefore.contains(id)) continue;
                        predecessors.add(o);
                    }
                }
                if (order.myLast) {
                    for (Orderable o : orderable) {
                        hisOrder = cachedMap.getOrDefault(o, ANY);
                        if (hisOrder.myLast) continue;
                        predecessors.add(o);
                    }
                }
                if (!order.myFirst) {
                    predecessors.addAll(first);
                }
                return predecessors.iterator();
            }
        };
        DFSTBuilder dFSTBuilder = new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)graph)));
        if (!dFSTBuilder.isAcyclic()) {
            Couple p = dFSTBuilder.getCircularDependency();
            throw new SortingException("Could not satisfy sorting requirements", (Orderable)p.first, (Orderable)p.second);
        }
        orderable.sort(dFSTBuilder.comparator());
    }

    @NotNull
    public static LoadingOrder readOrder(@Nullable String orderAttr) {
        if (orderAttr == null) {
            return ANY;
        }
        if (orderAttr.equals(FIRST_STR)) {
            return FIRST;
        }
        if (orderAttr.equals(LAST_STR)) {
            return LAST;
        }
        return new LoadingOrder(orderAttr);
    }

    public static interface Orderable {
        @Nullable
        public String getOrderId();

        public LoadingOrder getOrder();
    }
}

