/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginId
implements Comparable<PluginId> {
    public static final PluginId[] EMPTY_ARRAY = new PluginId[0];
    private static final Map<String, PluginId> ourRegisteredIds = new THashMap();
    private final String myIdString;

    private PluginId(@NotNull String idString) {
        this.myIdString = idString;
    }

    @Override
    public int compareTo(@NotNull PluginId o) {
        return this.myIdString.compareTo(o.myIdString);
    }

    @NotNull
    public static synchronized PluginId getId(@NotNull String idString) {
        return ourRegisteredIds.computeIfAbsent(idString, PluginId::new);
    }

    @Nullable
    public static synchronized PluginId findId(String ... idStrings) {
        for (String idString : idStrings) {
            PluginId pluginId = ourRegisteredIds.get(idString);
            if (pluginId == null) continue;
            return pluginId;
        }
        return null;
    }

    @NonNls
    @NotNull
    public String getIdString() {
        return this.myIdString;
    }

    public String toString() {
        return this.getIdString();
    }

    @NotNull
    public static synchronized Map<String, PluginId> getRegisteredIds() {
        return new THashMap(ourRegisteredIds);
    }
}

