/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class ExtensionComponentAdapter
implements LoadingOrder.Orderable {
    public static final ExtensionComponentAdapter[] EMPTY_ARRAY = new ExtensionComponentAdapter[0];
    private final PluginDescriptor myPluginDescriptor;
    @NotNull
    private Object myImplementationClassOrName;
    private boolean myNotificationSent;
    private final String myOrderId;
    private final LoadingOrder myOrder;

    public ExtensionComponentAdapter(@NotNull String implementationClassName, @Nullable PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order) {
        this.myImplementationClassOrName = implementationClassName;
        this.myPluginDescriptor = pluginDescriptor;
        this.myOrderId = orderId;
        this.myOrder = order;
    }

    @NotNull
    public Object createInstance(@Nullable PicoContainer container) {
        Object instance;
        try {
            Class<?> impl = this.getImplementationClass();
            ExtensionPointImpl.CHECK_CANCELED.run();
            instance = this.instantiateClass(impl, container);
            this.initInstance(instance);
        }
        catch (ExtensionNotApplicableException | ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            PluginId pluginId = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginId() : null;
            throw new PicoPluginExtensionInitializationException(t.getMessage(), t, pluginId);
        }
        if (instance instanceof PluginAware) {
            ((PluginAware)instance).setPluginDescriptor(this.myPluginDescriptor);
        }
        return instance;
    }

    @NotNull
    protected Object instantiateClass(@NotNull Class<?> clazz, @Nullable PicoContainer container) {
        return ReflectionUtil.newInstance(clazz);
    }

    protected void initInstance(@NotNull Object instance) {
    }

    @Override
    public final LoadingOrder getOrder() {
        return this.myOrder;
    }

    @Override
    public final String getOrderId() {
        return this.myOrderId;
    }

    @Nullable
    public final PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @NotNull
    public final Class<?> getImplementationClass() {
        Class<?> implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            try {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = this.myPluginDescriptor == null ? this.getClass().getClassLoader() : this.myPluginDescriptor.getPluginClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                this.myImplementationClassOrName = implementationClassOrName = Class.forName((String)((Object)implementationClassOrName), false, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return implementationClassOrName;
    }

    @NotNull
    public final String getAssignableToClassName() {
        Object implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            return (String)implementationClassOrName;
        }
        return ((Class)implementationClassOrName).getName();
    }

    final boolean isNotificationSent() {
        return this.myNotificationSent;
    }

    final void setNotificationSent() {
        this.myNotificationSent = true;
    }

    public String toString() {
        return "ExtensionComponentAdapter[" + this.getAssignableToClassName() + "]: plugin=" + this.myPluginDescriptor;
    }
}

