/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.EPAvailabilityListenerExtension;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public final class ExtensionsAreaImpl
implements ExtensionsArea {
    private static final Logger LOG = Logger.getInstance(ExtensionsAreaImpl.class);
    public static final String ATTRIBUTE_AREA = "area";
    private static final boolean DEBUG_REGISTRATION = Boolean.FALSE;
    private final AreaPicoContainer myPicoContainer;
    private final Map<String, ExtensionPointImpl> myExtensionPoints = ContainerUtil.newConcurrentMap();
    private final Map<String, Throwable> myEPTraces = DEBUG_REGISTRATION ? new THashMap() : null;
    private final MultiMap<String, ExtensionPointAvailabilityListener> myAvailabilityListeners = MultiMap.createSmart();
    private final AreaInstance myAreaInstance;
    private final String myAreaClass;

    public ExtensionsAreaImpl(@Nullable String areaClass, @Nullable AreaInstance areaInstance, PicoContainer parentPicoContainer) {
        this.myAreaClass = areaClass;
        this.myAreaInstance = areaInstance;
        this.myPicoContainer = new DefaultPicoContainer(parentPicoContainer);
        this.initialize();
    }

    @Nullable
    AreaInstance getAreaInstance() {
        return this.myAreaInstance;
    }

    public final void notifyAreaReplaced(@NotNull ExtensionsAreaImpl newArea) {
        THashSet processedEPs = ContainerUtil.newTroveSet();
        for (ExtensionPointImpl extensionPointImpl : this.myExtensionPoints.values()) {
            extensionPointImpl.notifyAreaReplaced(this);
            processedEPs.add(extensionPointImpl.getName());
        }
        if (!this.myAvailabilityListeners.isEmpty()) {
            for (Map.Entry entry : this.myAvailabilityListeners.entrySet()) {
                String key = (String)entry.getKey();
                if (processedEPs.contains(key)) continue;
                boolean wasAdded = false;
                for (ExtensionPointAvailabilityListener listener : (Collection)entry.getValue()) {
                    if (newArea.hasAvailabilityListener(key, listener)) continue;
                    newArea.addAvailabilityListener(key, listener, null);
                    wasAdded = true;
                }
                if (!wasAdded) continue;
                processedEPs.add(key);
            }
        }
        for (ExtensionPointImpl<Object> extensionPointImpl : newArea.myExtensionPoints.values()) {
            if (processedEPs.contains(extensionPointImpl.getName())) continue;
            extensionPointImpl.notifyAreaReplaced(this);
        }
    }

    @Override
    @NotNull
    public AreaPicoContainer getPicoContainer() {
        return this.myPicoContainer;
    }

    @Override
    public String getAreaClass() {
        return this.myAreaClass;
    }

    @Override
    public void registerExtensionPoint(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionPointElement) {
        assert (pluginDescriptor.getPluginId() != null);
        String pluginId = pluginDescriptor.getPluginId().getIdString();
        String pointName = extensionPointElement.getAttributeValue("qualifiedName");
        if (pointName == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw new RuntimeException("'name' attribute not specified for extension point in '" + pluginId + "' plugin");
            }
            pointName = pluginId + '.' + name;
        }
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw new RuntimeException("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginId + "' plugin");
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw new RuntimeException("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginId + "' plugin");
        }
        ExtensionPointImpl point = interfaceClassName == null ? new BeanExtensionPoint(pointName, beanClassName, this, pluginDescriptor) : new InterfaceExtensionPoint(pointName, interfaceClassName, this, pluginDescriptor);
        this.registerExtensionPoint(point);
    }

    @Override
    public void registerExtension(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement, String extensionNs) {
        String epName = ExtensionsAreaImpl.extractPointName(extensionElement, extensionNs);
        this.registerExtension(this.getExtensionPoint(epName), pluginDescriptor, extensionElement);
    }

    @Override
    public void registerExtension(@NotNull ExtensionPoint extensionPoint, @NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement) {
        ((ExtensionPointImpl)extensionPoint).createAndRegisterAdapter(extensionElement, pluginDescriptor);
    }

    @NotNull
    public static String extractPointName(@NotNull Element extensionElement, @Nullable String ns) {
        String epName = extensionElement.getAttributeValue("point");
        if (epName == null) {
            if (ns == null) {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            } else {
                epName = ns + '.' + extensionElement.getName();
            }
        }
        return epName;
    }

    private void initialize() {
        InterfaceExtensionPoint<EPAvailabilityListenerExtension> point = new InterfaceExtensionPoint<EPAvailabilityListenerExtension>("com.intellij.openapi.extensions.epAvailabilityListener", EPAvailabilityListenerExtension.class, this);
        this.registerExtensionPoint(point);
        point.addExtensionPointListener(new ExtensionPointListener<EPAvailabilityListenerExtension>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void extensionRemoved(@NotNull EPAvailabilityListenerExtension extension, @Nullable PluginDescriptor pluginDescriptor) {
                MultiMap multiMap = ExtensionsAreaImpl.this.myAvailabilityListeners;
                synchronized (multiMap) {
                    Collection listeners = ExtensionsAreaImpl.this.myAvailabilityListeners.get((Object)extension.getExtensionPointName());
                    Iterator iterator = listeners.iterator();
                    while (iterator.hasNext()) {
                        ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)iterator.next();
                        if (!listener.getClass().getName().equals(extension.getListenerClass())) continue;
                        iterator.remove();
                        return;
                    }
                }
                LOG.warn("Failed to find EP availability listener: " + extension.getListenerClass());
            }

            @Override
            public void extensionAdded(@NotNull EPAvailabilityListenerExtension extension, @Nullable PluginDescriptor pluginDescriptor) {
                ExtensionPointAvailabilityListener listener;
                String epName = extension.getExtensionPointName();
                try {
                    listener = (ExtensionPointAvailabilityListener)ExtensionsAreaImpl.this.instantiate(extension.loadListenerClass());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                ExtensionsAreaImpl.this.addAvailabilityListener(epName, listener, null);
            }
        }, false, null);
    }

    @NotNull
    private Object instantiate(@NotNull Class clazz) {
        CachingConstructorInjectionComponentAdapter adapter = new CachingConstructorInjectionComponentAdapter(Integer.toString(System.identityHashCode(new Object())), clazz);
        return adapter.getComponentInstance((PicoContainer)this.getPicoContainer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAvailabilityListener(final @NotNull String extensionPointName, final @NotNull ExtensionPointAvailabilityListener listener, @Nullable Disposable parentDisposable) {
        MultiMap<String, ExtensionPointAvailabilityListener> multiMap = this.myAvailabilityListeners;
        synchronized (multiMap) {
            this.myAvailabilityListeners.putValue((Object)extensionPointName, (Object)listener);
        }
        ExtensionPointImpl ep = this.myExtensionPoints.get(extensionPointName);
        if (ep != null) {
            listener.extensionPointRegistered(ep);
        }
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    ExtensionsAreaImpl.this.removeAvailabilityListener(extensionPointName, listener);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAvailabilityListener(@NotNull String extensionPointName, @NotNull ExtensionPointAvailabilityListener listener) {
        MultiMap<String, ExtensionPointAvailabilityListener> multiMap = this.myAvailabilityListeners;
        synchronized (multiMap) {
            this.myAvailabilityListeners.remove((Object)extensionPointName, (Object)listener);
        }
    }

    private boolean hasAvailabilityListener(@NotNull String extensionPointName, @NotNull ExtensionPointAvailabilityListener listener) {
        Collection listeners = this.myAvailabilityListeners.get((Object)extensionPointName);
        return ContainerUtil.containsIdentity((Iterable)listeners, (Object)listener);
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
    }

    @Override
    public void registerExtensionPoint(@NotNull BaseExtensionPointName extensionPoint, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, @NotNull Disposable parentDisposable) {
        final String extensionPointName = extensionPoint.getName();
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ExtensionsAreaImpl.this.unregisterExtensionPoint(extensionPointName);
            }
        });
    }

    void doRegisterExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        UndefinedPluginDescriptor pluginDescriptor = new UndefinedPluginDescriptor();
        ExtensionPointImpl point = kind == ExtensionPoint.Kind.INTERFACE ? new InterfaceExtensionPoint(extensionPointName, extensionPointBeanClass, this, pluginDescriptor) : new BeanExtensionPoint(extensionPointName, extensionPointBeanClass, this, pluginDescriptor);
        this.registerExtensionPoint(point);
    }

    @Nullable
    private static PluginId extractPluginId(@NotNull PluginDescriptor descriptor) {
        return descriptor instanceof UndefinedPluginDescriptor ? null : descriptor.getPluginId();
    }

    private void checkThatPointNotDuplicated(@NotNull String pointName, @NotNull PluginDescriptor pluginDescriptor) {
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        String message = "Duplicate registration for EP: " + pointName + ": original plugin " + ExtensionsAreaImpl.extractPluginId(((ExtensionPointImpl)this.getExtensionPoint(pointName)).getDescriptor()) + ", new plugin " + ExtensionsAreaImpl.extractPluginId(pluginDescriptor);
        if (DEBUG_REGISTRATION) {
            LOG.error(message, this.myEPTraces.get(pointName));
        }
        throw new PicoPluginExtensionInitializationException(message, null, ExtensionsAreaImpl.extractPluginId(pluginDescriptor));
    }

    public void registerExtensionPoint(@NotNull ExtensionPointImpl<?> point) {
        String name = point.getName();
        this.checkThatPointNotDuplicated(name, point.getDescriptor());
        this.myExtensionPoints.put(name, point);
        this.notifyPointRegistered(point);
        if (DEBUG_REGISTRATION) {
            this.myEPTraces.put(name, new Throwable("Original registration for " + name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPointRegistered(@NotNull ExtensionPoint extensionPoint) {
        Collection listeners;
        MultiMap<String, ExtensionPointAvailabilityListener> multiMap = this.myAvailabilityListeners;
        synchronized (multiMap) {
            listeners = this.myAvailabilityListeners.get((Object)extensionPoint.getName());
        }
        for (ExtensionPointAvailabilityListener listener : listeners) {
            listener.extensionPointRegistered(extensionPoint);
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in area " + this.myAreaInstance);
        }
        return extensionPoint;
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        return this.getExtensionPoint(extensionPointName.getName());
    }

    @Override
    @NotNull
    public ExtensionPoint[] getExtensionPoints() {
        return this.myExtensionPoints.values().toArray(new ExtensionPoint[0]);
    }

    @Override
    public void unregisterExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPoint extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint != null) {
            extensionPoint.reset();
            this.myExtensionPoints.remove(extensionPointName);
            this.notifyEPRemoved(extensionPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEPRemoved(@NotNull ExtensionPoint extensionPoint) {
        Collection listeners;
        MultiMap<String, ExtensionPointAvailabilityListener> multiMap = this.myAvailabilityListeners;
        synchronized (multiMap) {
            listeners = this.myAvailabilityListeners.get((Object)extensionPoint.getName());
        }
        for (ExtensionPointAvailabilityListener listener : listeners) {
            listener.extensionPointRemoved(extensionPoint);
        }
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    public String toString() {
        return (this.myAreaClass == null ? "Root" : this.myAreaClass) + " Area";
    }
}

