/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;

public final class InterfaceExtensionPoint<T>
extends ExtensionPointImpl<T> {
    public InterfaceExtensionPoint(@NotNull String name, @NotNull Class<T> clazz, @NotNull ExtensionsAreaImpl owner) {
        super(name, clazz.getName(), owner, new UndefinedPluginDescriptor());
        this.myExtensionClass = clazz;
    }

    InterfaceExtensionPoint(@NotNull String name, @NotNull String className, @NotNull ExtensionsAreaImpl owner, @NotNull PluginDescriptor pluginDescriptor) {
        super(name, className, owner, pluginDescriptor);
    }

    @Override
    @NotNull
    ExtensionComponentAdapter createAndRegisterAdapter(@NotNull Element extensionElement, @NotNull PluginDescriptor pluginDescriptor) {
        ExtensionComponentAdapter adapter = super.createAndRegisterAdapter(extensionElement, pluginDescriptor);
        this.myOwner.getPicoContainer().registerComponent((ComponentAdapter)adapter);
        return adapter;
    }

    @Override
    public synchronized void reset() {
        for (ExtensionComponentAdapter adapter : this.myAdapters) {
            if (!(adapter instanceof ComponentAdapter)) continue;
            this.myOwner.getPicoContainer().unregisterComponent(((ComponentAdapter)adapter).getComponentKey());
        }
        super.reset();
    }

    @Override
    @NotNull
    protected ExtensionComponentAdapter createAdapter(@NotNull Element extensionElement, @NotNull PluginDescriptor pluginDescriptor) {
        String implementationClassName = extensionElement.getAttributeValue("implementation");
        if (implementationClassName == null) {
            throw new RuntimeException("'implementation' attribute not specified for '" + this.getName() + "' extension in '" + pluginDescriptor.getPluginId() + "' plugin");
        }
        return InterfaceExtensionPoint.doCreateAdapter(implementationClassName, extensionElement, InterfaceExtensionPoint.shouldDeserializeInstance(extensionElement), pluginDescriptor, true);
    }

    private static boolean shouldDeserializeInstance(@NotNull Element extensionElement) {
        if (!extensionElement.getContent().isEmpty()) {
            return true;
        }
        for (Attribute attribute : extensionElement.getAttributes()) {
            String name = attribute.getName();
            if ("implementation".equals(name) || "id".equals(name) || "order".equals(name) || "os".equals(name)) continue;
            return true;
        }
        return false;
    }
}

