/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

class XmlExtensionAdapter
extends ExtensionComponentAdapter {
    @Nullable
    private final Element myExtensionElement;
    protected Object myComponentInstance;

    XmlExtensionAdapter(@NotNull String implementationClassName, @Nullable PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable Element extensionElement) {
        super(implementationClassName, pluginDescriptor, orderId, order);
        this.myExtensionElement = extensionElement;
    }

    @Override
    @NotNull
    public Object createInstance(@Nullable PicoContainer container) {
        Object instance = this.myComponentInstance;
        if (instance != null) {
            return instance;
        }
        this.myComponentInstance = instance = super.createInstance(container);
        return instance;
    }

    @Override
    protected void initInstance(@NotNull Object instance) {
        if (this.myExtensionElement != null) {
            try {
                XmlSerializer.deserializeInto((Object)instance, (Element)this.myExtensionElement);
            }
            catch (Exception e) {
                throw new PicoInitializationException((Throwable)e);
            }
        }
    }

    static final class ConstructorInjectionAdapter
    extends PicoComponentAdapter {
        ConstructorInjectionAdapter(@NotNull String implementationClassName, @Nullable PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable Element extensionElement) {
            super(implementationClassName, pluginDescriptor, orderId, order, extensionElement);
        }

        @Override
        @NotNull
        protected Object instantiateClass(@NotNull Class<?> clazz, @Nullable PicoContainer container) {
            return new CachingConstructorInjectionComponentAdapter(this.getComponentKey(), clazz, null, true).getComponentInstance(Objects.requireNonNull(container));
        }
    }

    static class PicoComponentAdapter
    extends XmlExtensionAdapter
    implements AssignableToComponentAdapter {
        PicoComponentAdapter(@NotNull String implementationClassName, @Nullable PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable Element extensionElement) {
            super(implementationClassName, pluginDescriptor, orderId, order, extensionElement);
        }

        @NotNull
        public final Object getComponentInstance(@Nullable PicoContainer container) {
            Object instance = this.myComponentInstance;
            return instance == null ? this.createInstance(container) : instance;
        }

        public final Class getComponentImplementation() {
            return this.getImplementationClass();
        }

        public final Object getComponentKey() {
            return this;
        }

        public final void verify(PicoContainer container) throws PicoIntrospectionException {
            throw new UnsupportedOperationException("Method verify is not supported in " + this.getClass());
        }

        public final void accept(PicoVisitor visitor) {
            throw new UnsupportedOperationException("Method accept is not supported in " + this.getClass());
        }
    }
}

