/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ExceptionUtil;
import gnu.trove.THashSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

public abstract class KeyedExtensionFactory<T, KeyT> {
    private final Class<T> myInterfaceClass;
    private final ExtensionPointName<KeyedFactoryEPBean> myEpName;
    private final PicoContainer myPicoContainer;

    public KeyedExtensionFactory(@NotNull Class<T> interfaceClass, @NonNls @NotNull ExtensionPointName<KeyedFactoryEPBean> epName, @NotNull PicoContainer picoContainer) {
        this.myInterfaceClass = interfaceClass;
        this.myEpName = epName;
        this.myPicoContainer = picoContainer;
    }

    @NotNull
    public T get() {
        final List<KeyedFactoryEPBean> epBeans = this.myEpName.getExtensionList();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object keyArg = args[0];
                String key = KeyedExtensionFactory.this.getKey(keyArg);
                Object result = KeyedExtensionFactory.this.getByKey(epBeans, key, method, args);
                if (result == null) {
                    result = KeyedExtensionFactory.this.getByKey(epBeans, null, method, args);
                }
                return result;
            }
        };
        return (T)Proxy.newProxyInstance(this.myInterfaceClass.getClassLoader(), new Class[]{this.myInterfaceClass}, handler);
    }

    public T getByKey(@NotNull KeyT key) {
        List<KeyedFactoryEPBean> epBeans = this.myEpName.getExtensionList();
        for (KeyedFactoryEPBean epBean : epBeans) {
            if (!Comparing.strEqual((String)this.getKey(key), (String)epBean.key)) continue;
            try {
                if (epBean.implementationClass == null) continue;
                return epBean.instantiate(epBean.implementationClass, this.myPicoContainer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @NotNull
    public Set<String> getAllKeys() {
        List<KeyedFactoryEPBean> list = this.myEpName.getExtensionList();
        THashSet set = new THashSet();
        for (KeyedFactoryEPBean epBean : list) {
            set.add(epBean.key);
        }
        return set;
    }

    private T getByKey(List<KeyedFactoryEPBean> epBeans, String key, Method method, Object[] args) {
        Object result = null;
        for (KeyedFactoryEPBean epBean : epBeans) {
            if (!Comparing.strEqual((String)epBean.key, (String)key, (boolean)true)) continue;
            try {
                if (epBean.implementationClass != null) {
                    result = epBean.instantiate(epBean.implementationClass, this.myPicoContainer);
                } else {
                    Object factory = epBean.instantiate(epBean.factoryClass, this.myPicoContainer);
                    result = method.invoke(factory, args);
                }
                if (result == null) continue;
                break;
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (T)result;
    }

    @NotNull
    public abstract String getKey(@NotNull KeyT var1);
}

