/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.pico.DefaultPicoContainer;
import gnu.trove.THashSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.CyclicDependencyException;
import org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class CachingConstructorInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private static final ThreadLocal<Set<CachingConstructorInjectionComponentAdapter>> ourGuard = new ThreadLocal();
    private Object myInstance;

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, allowNonPublicClasses, (ComponentMonitor)DefaultPicoContainer.DEFAULT_DELEGATING_COMPONENT_MONITOR, (LifecycleStrategy)DefaultPicoContainer.DEFAULT_LIFECYCLE_STRATEGY);
    }

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters) {
        this(componentKey, componentImplementation, parameters, false);
    }

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentImplementation, null);
    }

    public Object getComponentInstance(@NotNull PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object instance = this.myInstance;
        if (instance == null) {
            this.myInstance = instance = this.instantiateGuarded(container, this.getComponentImplementation());
        }
        return instance;
    }

    @NotNull
    private Object instantiateGuarded(@NotNull PicoContainer container, @NotNull Class<?> stackFrame) {
        THashSet currentStack = ourGuard.get();
        if (currentStack == null) {
            currentStack = ContainerUtil.newIdentityTroveSet();
            ourGuard.set((Set<CachingConstructorInjectionComponentAdapter>)currentStack);
        }
        if (currentStack.contains((Object)this)) {
            throw new CyclicDependencyException(stackFrame);
        }
        try {
            currentStack.add(this);
            Object object = this.doGetComponentInstance(container);
            return object;
        }
        catch (CyclicDependencyException e) {
            e.push(stackFrame);
            throw e;
        }
        finally {
            currentStack.remove((Object)this);
        }
    }

    @NotNull
    private Object doGetComponentInstance(@NotNull PicoContainer guardedContainer) {
        Constructor constructor;
        try {
            constructor = this.getGreediestSatisfiableConstructor(guardedContainer);
        }
        catch (AmbiguousComponentResolutionException e) {
            e.setComponent(this.getComponentImplementation());
            throw e;
        }
        ComponentMonitor componentMonitor = this.currentMonitor();
        try {
            Object[] parameters = this.getConstructorArguments(guardedContainer, constructor);
            componentMonitor.instantiating(constructor);
            long startTime = System.currentTimeMillis();
            Object inst = this.newInstance(constructor, parameters);
            componentMonitor.instantiated(constructor, System.currentTimeMillis() - startTime);
            return inst;
        }
        catch (InvocationTargetException e) {
            componentMonitor.instantiationFailed(constructor, (Exception)e);
            ExceptionUtil.rethrowUnchecked((Throwable)e.getTargetException());
            throw new PicoInvocationTargetInitializationException(e.getTargetException());
        }
        catch (InstantiationException e) {
            componentMonitor.instantiationFailed(constructor, (Exception)e);
            throw new PicoInitializationException("Should never get here");
        }
        catch (IllegalAccessException e) {
            componentMonitor.instantiationFailed(constructor, (Exception)e);
            throw new PicoInitializationException((Throwable)e);
        }
    }

    @NotNull
    private Object[] getConstructorArguments(PicoContainer container, @NotNull Constructor ctor) {
        Class[] parameterTypes = ctor.getParameterTypes();
        Object[] result = new Object[parameterTypes.length];
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
        for (int i = 0; i < currentParameters.length; ++i) {
            result[i] = currentParameters[i].resolveInstance(container, (ComponentAdapter)this, parameterTypes[i]);
        }
        return result;
    }

    @NotNull
    protected Constructor getGreediestSatisfiableConstructor(@NotNull PicoContainer container) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        HashSet<List<Class>> unsatisfiableDependencyTypes = new HashSet<List<Class>>();
        List<Constructor> sortedMatchingConstructors = this.getSortedMatchingConstructors();
        Constructor greediestConstructor = null;
        int lastSatisfiableConstructorSize = -1;
        Class unsatisfiedDependencyType = null;
        for (Constructor constructor : sortedMatchingConstructors) {
            boolean failedDependency = false;
            Class[] parameterTypes = constructor.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            for (int j = 0; j < currentParameters.length; ++j) {
                if (currentParameters[j].isResolvable(container, (ComponentAdapter)this, parameterTypes[j])) continue;
                unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                unsatisfiedDependencyType = parameterTypes[j];
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    return greediestConstructor;
                }
                conflicts.add(constructor);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(constructor);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = constructor;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new UnsatisfiableDependenciesException((ComponentAdapter)this, unsatisfiedDependencyType, unsatisfiableDependencyTypes, container);
        }
        if (greediestConstructor == null) {
            HashSet nonMatching = ContainerUtil.newHashSet((Object[])this.getConstructors());
            throw new PicoInitializationException("Either do the specified parameters not match any of the following constructors: " + nonMatching + " or the constructors were not accessible for '" + this.getComponentImplementation() + "'");
        }
        return greediestConstructor;
    }

    private List<Constructor> getSortedMatchingConstructors() {
        ArrayList<Constructor> matchingConstructors = new ArrayList<Constructor>();
        for (Constructor<?> constructor : this.getConstructors()) {
            if (this.parameters != null && constructor.getParameterTypes().length != this.parameters.length || !this.allowNonPublicClasses && (constructor.getModifiers() & 1) == 0) continue;
            matchingConstructors.add(constructor);
        }
        if (this.parameters == null) {
            matchingConstructors.sort((arg0, arg1) -> arg1.getParameterTypes().length - arg0.getParameterTypes().length);
        }
        return matchingConstructors;
    }

    @NotNull
    private Constructor<?>[] getConstructors() {
        return AccessController.doPrivileged(() -> this.getComponentImplementation().getDeclaredConstructors());
    }
}

