/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.jmeter.util.JMeterUtils;

public class OnErrorPanel
extends JPanel {
    private static final long serialVersionUID = 240L;
    private JRadioButton continueBox;
    private JRadioButton breakLoopBox;
    private JRadioButton startNextThreadLoopBox;
    private JRadioButton startNextIterationOfCurrentLoopBox;
    private JRadioButton stopThrdBox;
    private JRadioButton stopTestBox;
    private JRadioButton stopTestNowBox;

    private JPanel createOnErrorPanel() {
        JPanel panel = new JPanel(new GridLayout(4, 2));
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("sampler_on_error_action")));
        ButtonGroup group = new ButtonGroup();
        this.continueBox = this.addRadioButton("sampler_on_error_continue", group, panel);
        this.breakLoopBox = this.addRadioButton("sampler_on_error_break_loop", group, panel);
        this.startNextThreadLoopBox = this.addRadioButton("sampler_on_error_start_next_loop", group, panel);
        this.startNextIterationOfCurrentLoopBox = this.addRadioButton("sampler_on_error_start_next_iteration_current_loop", group, panel);
        this.stopTestBox = this.addRadioButton("sampler_on_error_stop_test", group, panel);
        this.stopTestNowBox = this.addRadioButton("sampler_on_error_stop_test_now", group, panel);
        this.stopThrdBox = this.addRadioButton("sampler_on_error_stop_thread", group, panel);
        this.continueBox.setSelected(true);
        return panel;
    }

    private JRadioButton addRadioButton(String labelKey, ButtonGroup group, JPanel panel) {
        JRadioButton radioButton = new JRadioButton(JMeterUtils.getResString(labelKey));
        group.add(radioButton);
        panel.add(radioButton);
        return radioButton;
    }

    public OnErrorPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 0));
        this.add(this.createOnErrorPanel());
    }

    public void configure(int errorAction) {
        this.stopTestNowBox.setSelected(errorAction == 3);
        this.startNextThreadLoopBox.setSelected(errorAction == 4);
        this.startNextIterationOfCurrentLoopBox.setSelected(errorAction == 5);
        this.stopTestBox.setSelected(errorAction == 2);
        this.stopThrdBox.setSelected(errorAction == 1);
        this.continueBox.setSelected(errorAction == 0);
        this.breakLoopBox.setSelected(errorAction == 6);
    }

    public int getOnErrorSetting() {
        if (this.stopTestNowBox.isSelected()) {
            return 3;
        }
        if (this.stopTestBox.isSelected()) {
            return 2;
        }
        if (this.stopThrdBox.isSelected()) {
            return 1;
        }
        if (this.startNextThreadLoopBox.isSelected()) {
            return 4;
        }
        if (this.startNextIterationOfCurrentLoopBox.isSelected()) {
            return 5;
        }
        if (this.breakLoopBox.isSelected()) {
            return 6;
        }
        return 0;
    }
}

