/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.sampler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jmeter.protocol.tcp.sampler.BinaryTCPClientImpl;
import org.apache.jmeter.protocol.tcp.sampler.ReadException;
import org.apache.jmeter.protocol.tcp.sampler.TCPClientDecorator;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LengthPrefixedBinaryTCPClientImpl
extends TCPClientDecorator {
    private static final Logger log = LoggerFactory.getLogger(LengthPrefixedBinaryTCPClientImpl.class);
    private final int lengthPrefixLen = JMeterUtils.getPropDefault((String)"tcp.binarylength.prefix.length", (int)2);

    public LengthPrefixedBinaryTCPClientImpl() {
        super(new BinaryTCPClientImpl());
        this.tcpClient.setEolByte(128);
    }

    @Override
    public void write(OutputStream os, String s) throws IOException {
        os.write(LengthPrefixedBinaryTCPClientImpl.intToByteArray(s.length() / 2, this.lengthPrefixLen));
        if (log.isDebugEnabled()) {
            log.debug("Wrote: " + s.length() / 2 + " bytes");
        }
        this.tcpClient.write(os, s);
    }

    @Override
    public void write(OutputStream os, InputStream is) throws IOException {
        this.tcpClient.write(os, is);
    }

    @Override
    @Deprecated
    public String read(InputStream is) throws ReadException {
        log.warn("Deprecated method, use read(is, sampleResult) instead");
        return this.read(is, new SampleResult());
    }

    @Override
    public String read(InputStream is, SampleResult sampleResult) throws ReadException {
        byte[] msg = new byte[]{};
        int msgLen = 0;
        byte[] lengthBuffer = new byte[this.lengthPrefixLen];
        try {
            if (is.read(lengthBuffer, 0, this.lengthPrefixLen) == this.lengthPrefixLen) {
                sampleResult.latencyEnd();
                msgLen = LengthPrefixedBinaryTCPClientImpl.byteArrayToInt(lengthBuffer);
                msg = new byte[msgLen];
                int bytes = JOrphanUtils.read((InputStream)is, (byte[])msg, (int)0, (int)msgLen);
                if (bytes < msgLen) {
                    log.warn("Incomplete message read, expected: {} got: {}", (Object)msgLen, (Object)bytes);
                }
            }
            String buffer = JOrphanUtils.baToHexString((byte[])msg);
            if (log.isDebugEnabled()) {
                log.debug("Read: " + msgLen + "\n" + buffer);
            }
            return buffer;
        }
        catch (IOException e) {
            throw new ReadException("", e, JOrphanUtils.baToHexString((byte[])msg));
        }
    }

    @Override
    public byte getEolByte() {
        return this.tcpClient.getEolByte();
    }

    @Override
    public void setEolByte(int eolInt) {
        throw new UnsupportedOperationException("Cannot set eomByte for prefixed messages");
    }
}

