/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.JLabeledRadioI18N;
import org.apache.jmeter.protocol.jms.sampler.SubscriberSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledPasswordField;
import org.apache.jorphan.gui.JLabeledTextField;

@TestElementMetadata(labelResource="jms_subscriber_title")
public class JMSSubscriberGui
extends AbstractSamplerGui
implements ChangeListener {
    private static final long serialVersionUID = 240L;
    private final JCheckBox useProperties = new JCheckBox(JMeterUtils.getResString((String)"jms_use_properties_file"), false);
    private final JTextField jndiICF = new JTextField();
    private final JTextField urlField = new JTextField();
    private final JTextField jndiConnFac = new JTextField();
    private final JTextField jmsDestination = new JTextField();
    private final JTextField jmsDurableSubscriptionId = new JTextField();
    private final JTextField jmsClientId = new JTextField();
    private final JTextField jmsSelector = new JTextField();
    private final JCheckBox useAuth = new JCheckBox(JMeterUtils.getResString((String)"jms_use_auth"), false);
    private final JLabeledTextField jmsUser = new JLabeledTextField(JMeterUtils.getResString((String)"jms_user"));
    private final JLabeledTextField jmsPwd = new JLabeledPasswordField(JMeterUtils.getResString((String)"jms_pwd"));
    private final JTextField samplesToAggregate = new JTextField();
    private final JCheckBox storeResponse = new JCheckBox(JMeterUtils.getResString((String)"jms_store_response"), true);
    private final JTextField timeout = new JTextField();
    private final JTextField jmsErrorPauseBetween = new JTextField();
    private final JTextField jmsErrorReconnectOnCodes = new JTextField();
    private final JTextField separator = new JTextField();
    public static final String RECEIVE_RSC = "jms_subscriber_receive";
    public static final String ON_MESSAGE_RSC = "jms_subscriber_on_message";
    private static final String[] CLIENT_ITEMS = new String[]{"jms_subscriber_receive", "jms_subscriber_on_message"};
    private final JLabeledRadioI18N clientChoice = new JLabeledRadioI18N("jms_client_type", CLIENT_ITEMS, "jms_subscriber_receive");
    private final JCheckBox stopBetweenSamples = new JCheckBox(JMeterUtils.getResString((String)"jms_stop_between_samples"), true);
    private static final String DEST_SETUP_STATIC = "jms_dest_setup_static";
    private static final String DEST_SETUP_DYNAMIC = "jms_dest_setup_dynamic";
    private static final String[] DEST_SETUP_ITEMS = new String[]{"jms_dest_setup_static", "jms_dest_setup_dynamic"};
    private final JLabeledRadioI18N destSetup = new JLabeledRadioI18N("jms_dest_setup", DEST_SETUP_ITEMS, "jms_dest_setup_static");

    public JMSSubscriberGui() {
        this.init();
    }

    public String getLabelResource() {
        return "jms_subscriber_title";
    }

    public TestElement createTestElement() {
        SubscriberSampler sampler = new SubscriberSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement s) {
        SubscriberSampler sampler = (SubscriberSampler)s;
        super.configureTestElement((TestElement)sampler);
        sampler.setUseJNDIProperties(String.valueOf(this.useProperties.isSelected()));
        sampler.setJNDIIntialContextFactory(this.jndiICF.getText());
        sampler.setProviderUrl(this.urlField.getText());
        sampler.setConnectionFactory(this.jndiConnFac.getText());
        sampler.setDestination(this.jmsDestination.getText());
        sampler.setDurableSubscriptionId(this.jmsDurableSubscriptionId.getText());
        sampler.setClientID(this.jmsClientId.getText());
        sampler.setJmsSelector(this.jmsSelector.getText());
        sampler.setUsername(this.jmsUser.getText());
        sampler.setPassword(this.jmsPwd.getText());
        sampler.setUseAuth(this.useAuth.isSelected());
        sampler.setIterations(this.samplesToAggregate.getText());
        sampler.setReadResponse(String.valueOf(this.storeResponse.isSelected()));
        sampler.setClientChoice(this.clientChoice.getText());
        sampler.setStopBetweenSamples(this.stopBetweenSamples.isSelected());
        sampler.setTimeout(this.timeout.getText());
        sampler.setReconnectionErrorCodes(this.jmsErrorReconnectOnCodes.getText());
        sampler.setPauseBetweenErrors(this.jmsErrorPauseBetween.getText());
        sampler.setDestinationStatic(this.destSetup.getText().equals(DEST_SETUP_STATIC));
        sampler.setSeparator(this.separator.getText());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 3, insets 0", "[][fill,grow]"));
        this.add(mainPanel, "Center");
        this.jndiICF.setToolTipText("java.naming.factory.initial");
        this.urlField.setToolTipText("java.naming.provider.url");
        this.jmsUser.setToolTipText("java.naming.security.principal");
        this.jmsPwd.setToolTipText("java.naming.security.credentials");
        mainPanel.add((Component)this.useProperties, "span");
        mainPanel.add(JMeterUtils.labelFor((Component)this.jndiICF, (String)"jms_initial_context_factory"));
        mainPanel.add((Component)this.jndiICF, "span, growx");
        mainPanel.add(JMeterUtils.labelFor((Component)this.urlField, (String)"jms_provider_url"));
        mainPanel.add((Component)this.urlField, "span, growx");
        mainPanel.add(this.useAuth);
        mainPanel.add((Component)this.jmsUser);
        mainPanel.add((Component)this.jmsPwd);
        mainPanel.add(JMeterUtils.labelFor((Component)this.jndiConnFac, (String)"jms_connection_factory"));
        mainPanel.add((Component)this.jndiConnFac, "span, growx");
        mainPanel.add(JMeterUtils.labelFor((Component)this.jmsDestination, (String)"jms_topic"));
        mainPanel.add(this.jmsDestination);
        mainPanel.add((Component)this.destSetup);
        mainPanel.add(JMeterUtils.labelFor((Component)this.jmsDurableSubscriptionId, (String)"jms_durable_subscription_id"));
        mainPanel.add((Component)this.jmsDurableSubscriptionId, "span, growx");
        mainPanel.add(JMeterUtils.labelFor((Component)this.jmsClientId, (String)"jms_client_id"));
        mainPanel.add((Component)this.jmsClientId, "span, growx");
        mainPanel.add(JMeterUtils.labelFor((Component)this.jmsSelector, (String)"jms_selector"));
        mainPanel.add(this.jmsSelector);
        mainPanel.add((Component)this.storeResponse, "span");
        mainPanel.add(JMeterUtils.labelFor((Component)this.timeout, (String)"jms_timeout"));
        mainPanel.add((Component)this.timeout, "span");
        mainPanel.add((Component)this.clientChoice, "span 2");
        mainPanel.add(this.stopBetweenSamples);
        mainPanel.add(JMeterUtils.labelFor((Component)this.jmsErrorReconnectOnCodes, (String)"jms_error_reconnect_on_codes"));
        mainPanel.add((Component)this.jmsErrorReconnectOnCodes, "span, growx");
        mainPanel.add(JMeterUtils.labelFor((Component)this.jmsErrorPauseBetween, (String)"jms_error_pause_between"));
        mainPanel.add((Component)this.jmsErrorPauseBetween, "span, growx");
        mainPanel.add(JMeterUtils.labelFor((Component)this.samplesToAggregate, (String)"jms_itertions"));
        mainPanel.add((Component)this.samplesToAggregate, "span, growx");
        mainPanel.add(JMeterUtils.labelFor((Component)this.separator, (String)"jms_separator"));
        mainPanel.add((Component)this.separator, "span, growx");
        this.useProperties.addChangeListener(this);
        this.useAuth.addChangeListener(this);
    }

    public void configure(TestElement el) {
        super.configure(el);
        SubscriberSampler sampler = (SubscriberSampler)el;
        this.useProperties.setSelected(sampler.getUseJNDIPropertiesAsBoolean());
        this.jndiICF.setText(sampler.getJNDIInitialContextFactory());
        this.urlField.setText(sampler.getProviderUrl());
        this.jndiConnFac.setText(sampler.getConnectionFactory());
        this.jmsDestination.setText(sampler.getDestination());
        this.jmsDurableSubscriptionId.setText(sampler.getDurableSubscriptionId());
        this.jmsClientId.setText(sampler.getClientId());
        this.jmsSelector.setText(sampler.getJmsSelector());
        this.jmsUser.setText(sampler.getUsername());
        this.jmsPwd.setText(sampler.getPassword());
        this.samplesToAggregate.setText(sampler.getIterations());
        this.useAuth.setSelected(sampler.isUseAuth());
        this.jmsUser.setEnabled(this.useAuth.isSelected());
        this.jmsPwd.setEnabled(this.useAuth.isSelected());
        this.storeResponse.setSelected(sampler.getReadResponseAsBoolean());
        this.clientChoice.setText(sampler.getClientChoice());
        this.stopBetweenSamples.setSelected(sampler.isStopBetweenSamples());
        this.timeout.setText(sampler.getTimeout());
        this.separator.setText(sampler.getSeparator());
        this.destSetup.setText(sampler.isDestinationStatic() ? DEST_SETUP_STATIC : DEST_SETUP_DYNAMIC);
        this.jmsErrorReconnectOnCodes.setText(sampler.getReconnectionErrorCodes());
        this.jmsErrorPauseBetween.setText(sampler.getPauseBetweenErrors());
    }

    public void clearGui() {
        super.clearGui();
        this.useProperties.setSelected(false);
        this.jndiICF.setText("");
        this.urlField.setText("");
        this.jndiConnFac.setText("");
        this.jmsDestination.setText("");
        this.jmsDurableSubscriptionId.setText("");
        this.jmsClientId.setText("");
        this.jmsSelector.setText("");
        this.jmsUser.setText("");
        this.jmsPwd.setText("");
        this.samplesToAggregate.setText("1");
        this.timeout.setText("");
        this.separator.setText("");
        this.useAuth.setSelected(false);
        this.jmsUser.setEnabled(false);
        this.jmsPwd.setEnabled(false);
        this.storeResponse.setSelected(true);
        this.clientChoice.setText(RECEIVE_RSC);
        this.stopBetweenSamples.setSelected(false);
        this.destSetup.setText(DEST_SETUP_STATIC);
        this.jmsErrorReconnectOnCodes.setText("");
        this.jmsErrorPauseBetween.setText("");
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.useProperties) {
            boolean isUseProperties = this.useProperties.isSelected();
            this.jndiICF.setEnabled(!isUseProperties);
            this.urlField.setEnabled(!isUseProperties);
            this.useAuth.setEnabled(!isUseProperties);
        } else if (event.getSource() == this.useAuth) {
            this.jmsUser.setEnabled(this.useAuth.isSelected() && this.useAuth.isEnabled());
            this.jmsPwd.setEnabled(this.useAuth.isSelected() && this.useAuth.isEnabled());
        }
    }
}

