/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.mail.sampler.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.mail.sampler.MailReaderSampler;
import org.apache.jmeter.protocol.smtp.sampler.gui.SecuritySettingsPanel;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="mail_reader_title")
public class MailReaderSamplerGui
extends AbstractSamplerGui
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 240L;
    private JTextField serverTypeBox;
    private JTextField serverBox;
    private JTextField portBox;
    private JTextField usernameBox;
    private JTextField passwordBox;
    private JTextField folderBox;
    private JLabel folderLabel;
    private JRadioButton allMessagesButton;
    private JRadioButton someMessagesButton;
    private JTextField someMessagesField;
    private JCheckBox deleteBox;
    private JCheckBox storeMimeMessageBox;
    private JCheckBox headerOnlyBox;
    private final String serverTypeLabel = JMeterUtils.getResString((String)"mail_reader_server_type");
    private final String serverLabel = JMeterUtils.getResString((String)"mail_reader_server");
    private final String portLabel = JMeterUtils.getResString((String)"mail_reader_port");
    private final String accountLabel = JMeterUtils.getResString((String)"mail_reader_account");
    private final String passwordLabel = JMeterUtils.getResString((String)"mail_reader_password");
    private final String numMessagesLabel = JMeterUtils.getResString((String)"mail_reader_num_messages");
    private final String allMessagesLabel = JMeterUtils.getResString((String)"mail_reader_all_messages");
    private final String deleteLabel = JMeterUtils.getResString((String)"mail_reader_delete");
    private final String folderLabelStr = JMeterUtils.getResString((String)"mail_reader_folder");
    private final String storeMime = JMeterUtils.getResString((String)"mail_reader_storemime");
    private final String headerOnlyLabel = JMeterUtils.getResString((String)"mail_reader_header_only");
    private static final String INBOX = "INBOX";
    private SecuritySettingsPanel securitySettingsPanel;

    public MailReaderSamplerGui() {
        this.init();
        this.initGui();
    }

    public String getLabelResource() {
        return "mail_reader_title";
    }

    public void configure(TestElement element) {
        MailReaderSampler mrs = (MailReaderSampler)element;
        this.serverTypeBox.setText(mrs.getServerType());
        this.folderBox.setText(mrs.getFolder());
        this.serverBox.setText(mrs.getServer());
        this.portBox.setText(mrs.getPort());
        this.usernameBox.setText(mrs.getUserName());
        this.passwordBox.setText(mrs.getPassword());
        if (mrs.getNumMessages() == -1) {
            this.allMessagesButton.setSelected(true);
            this.someMessagesField.setText("0");
        } else {
            this.someMessagesButton.setSelected(true);
            this.someMessagesField.setText(mrs.getNumMessagesString());
        }
        this.headerOnlyBox.setSelected(mrs.getHeaderOnly());
        this.deleteBox.setSelected(mrs.getDeleteMessages());
        this.storeMimeMessageBox.setSelected(mrs.isStoreMimeMessage());
        this.securitySettingsPanel.configure(element);
        super.configure(element);
    }

    public TestElement createTestElement() {
        MailReaderSampler sampler = new MailReaderSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement te) {
        te.clear();
        this.configureTestElement(te);
        MailReaderSampler mrs = (MailReaderSampler)te;
        mrs.setServerType(this.serverTypeBox.getText());
        mrs.setFolder(this.folderBox.getText());
        mrs.setServer(this.serverBox.getText());
        mrs.setPort(this.portBox.getText());
        mrs.setUserName(this.usernameBox.getText());
        mrs.setPassword(this.passwordBox.getText());
        if (this.allMessagesButton.isSelected()) {
            mrs.setNumMessages(-1);
        } else {
            mrs.setNumMessages(this.someMessagesField.getText());
        }
        mrs.setHeaderOnly(this.headerOnlyBox.isSelected());
        mrs.setDeleteMessages(this.deleteBox.isSelected());
        mrs.setStoreMimeMessage(this.storeMimeMessageBox.isSelected());
        this.securitySettingsPanel.modifyTestElement(te);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = this.getConstraints();
        this.serverTypeBox = new JTextField(20);
        this.serverTypeBox.addActionListener(this);
        this.serverTypeBox.addFocusListener(this);
        this.addField(settingsPanel, this.serverTypeLabel, (JComponent)this.serverTypeBox, gbc);
        this.serverBox = new JTextField(20);
        this.addField(settingsPanel, this.serverLabel, (JComponent)this.serverBox, gbc);
        this.portBox = new JTextField(20);
        this.addField(settingsPanel, this.portLabel, (JComponent)this.portBox, gbc);
        this.usernameBox = new JTextField(20);
        this.addField(settingsPanel, this.accountLabel, (JComponent)this.usernameBox, gbc);
        this.passwordBox = new JPasswordField(20);
        this.addField(settingsPanel, this.passwordLabel, (JComponent)this.passwordBox, gbc);
        this.folderLabel = new JLabel(this.folderLabelStr);
        this.folderBox = new JTextField(INBOX, 20);
        this.addField(settingsPanel, this.folderLabel, (JComponent)this.folderBox, gbc);
        HorizontalPanel numMessagesPanel = new HorizontalPanel();
        numMessagesPanel.add((Component)new JLabel(this.numMessagesLabel));
        ButtonGroup nmbg = new ButtonGroup();
        this.allMessagesButton = new JRadioButton(this.allMessagesLabel);
        this.allMessagesButton.addChangeListener(e -> {
            if (this.allMessagesButton.isSelected()) {
                this.someMessagesField.setEnabled(false);
            }
        });
        this.someMessagesButton = new JRadioButton();
        this.someMessagesButton.addChangeListener(e -> {
            if (this.someMessagesButton.isSelected()) {
                this.someMessagesField.setEnabled(true);
            }
        });
        nmbg.add(this.allMessagesButton);
        nmbg.add(this.someMessagesButton);
        this.someMessagesField = new JTextField(5);
        this.allMessagesButton.setSelected(true);
        numMessagesPanel.add((Component)this.allMessagesButton);
        numMessagesPanel.add((Component)this.someMessagesButton);
        numMessagesPanel.add((Component)this.someMessagesField);
        this.headerOnlyBox = new JCheckBox(this.headerOnlyLabel);
        this.deleteBox = new JCheckBox(this.deleteLabel);
        this.storeMimeMessageBox = new JCheckBox(this.storeMime);
        this.securitySettingsPanel = new SecuritySettingsPanel();
        VerticalPanel settings = new VerticalPanel();
        settings.add(Box.createVerticalStrut(5));
        settings.add(settingsPanel);
        settings.add((Component)numMessagesPanel);
        settings.add(this.headerOnlyBox);
        settings.add(this.deleteBox);
        settings.add(this.storeMimeMessageBox);
        settings.add(this.securitySettingsPanel);
        this.add(this.makeTitlePanel(), "North");
        this.add((Component)settings, "Center");
    }

    private void addField(JPanel panel, JLabel label, JComponent field, GridBagConstraints gbc) {
        gbc.fill = 0;
        gbc.anchor = 22;
        panel.add((Component)label, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 21;
        panel.add((Component)field, gbc);
        this.nextLine(gbc);
    }

    private void addField(JPanel panel, String text, JComponent field, GridBagConstraints gbc) {
        this.addField(panel, new JLabel(text), field, gbc);
    }

    private void nextLine(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
    }

    private GridBagConstraints getConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        return gbc;
    }

    public void clearGui() {
        super.clearGui();
        this.initGui();
    }

    private void initGui() {
        this.allMessagesButton.setSelected(true);
        this.headerOnlyBox.setSelected(false);
        this.deleteBox.setSelected(false);
        this.storeMimeMessageBox.setSelected(false);
        this.folderBox.setText(INBOX);
        this.serverTypeBox.setText("pop3");
        this.passwordBox.setText("");
        this.serverBox.setText("");
        this.portBox.setText("");
        this.usernameBox.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String item = this.serverTypeBox.getText();
        if (item.equals("pop3") || item.equals("pop3s")) {
            this.folderLabel.setEnabled(false);
            this.folderBox.setText(INBOX);
            this.folderBox.setEnabled(false);
        } else {
            this.folderLabel.setEnabled(true);
            this.folderBox.setEnabled(true);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.actionPerformed(null);
    }
}

