/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.TimeZone;

public class FTPFile
implements Serializable {
    private static final long serialVersionUID = 9010790363003271996L;
    public static final int FILE_TYPE = 0;
    public static final int DIRECTORY_TYPE = 1;
    public static final int SYMBOLIC_LINK_TYPE = 2;
    public static final int UNKNOWN_TYPE = 3;
    public static final int USER_ACCESS = 0;
    public static final int GROUP_ACCESS = 1;
    public static final int WORLD_ACCESS = 2;
    public static final int READ_PERMISSION = 0;
    public static final int WRITE_PERMISSION = 1;
    public static final int EXECUTE_PERMISSION = 2;
    private int type;
    private int hardLinkCount;
    private long size;
    private String rawListing;
    private String user;
    private String group;
    private String name;
    private String link;
    private Calendar date;
    private final boolean[][] permissions;

    public FTPFile() {
        this.permissions = new boolean[3][3];
        this.type = 3;
        this.hardLinkCount = 0;
        this.size = -1L;
        this.user = "";
        this.group = "";
        this.date = null;
        this.name = null;
    }

    FTPFile(String rawListing) {
        this.permissions = null;
        this.rawListing = rawListing;
        this.type = 3;
        this.hardLinkCount = 0;
        this.size = -1L;
        this.user = "";
        this.group = "";
        this.date = null;
        this.name = null;
    }

    public void setRawListing(String rawListing) {
        this.rawListing = rawListing;
    }

    public String getRawListing() {
        return this.rawListing;
    }

    public boolean isDirectory() {
        return this.type == 1;
    }

    public boolean isFile() {
        return this.type == 0;
    }

    public boolean isSymbolicLink() {
        return this.type == 2;
    }

    public boolean isUnknown() {
        return this.type == 3;
    }

    public boolean isValid() {
        return this.permissions != null;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public void setHardLinkCount(int links) {
        this.hardLinkCount = links;
    }

    public int getHardLinkCount() {
        return this.hardLinkCount;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getLink() {
        return this.link;
    }

    public void setTimestamp(Calendar date) {
        this.date = date;
    }

    public Calendar getTimestamp() {
        return this.date;
    }

    public void setPermission(int access, int permission, boolean value) {
        this.permissions[access][permission] = value;
    }

    public boolean hasPermission(int access, int permission) {
        if (this.permissions == null) {
            return false;
        }
        return this.permissions[access][permission];
    }

    public String toString() {
        return this.getRawListing();
    }

    public String toFormattedString() {
        return this.toFormattedString(null);
    }

    public String toFormattedString(String timezone) {
        if (!this.isValid()) {
            return "[Invalid: could not parse file entry]";
        }
        StringBuilder sb = new StringBuilder();
        try (Formatter fmt = new Formatter(sb);){
            sb.append(this.formatType());
            sb.append(this.permissionToString(0));
            sb.append(this.permissionToString(1));
            sb.append(this.permissionToString(2));
            fmt.format(" %4d", this.getHardLinkCount());
            fmt.format(" %-8s %-8s", this.getUser(), this.getGroup());
            fmt.format(" %8d", this.getSize());
            Calendar timestamp = this.getTimestamp();
            if (timestamp != null) {
                TimeZone newZone;
                if (timezone != null && !(newZone = TimeZone.getTimeZone(timezone)).equals(timestamp.getTimeZone())) {
                    Date original = timestamp.getTime();
                    Calendar newStamp = Calendar.getInstance(newZone);
                    newStamp.setTime(original);
                    timestamp = newStamp;
                }
                fmt.format(" %1$tY-%1$tm-%1$td", timestamp);
                if (timestamp.isSet(11)) {
                    fmt.format(" %1$tH", timestamp);
                    if (timestamp.isSet(12)) {
                        fmt.format(":%1$tM", timestamp);
                        if (timestamp.isSet(13)) {
                            fmt.format(":%1$tS", timestamp);
                            if (timestamp.isSet(14)) {
                                fmt.format(".%1$tL", timestamp);
                            }
                        }
                    }
                    fmt.format(" %1$tZ", timestamp);
                }
            }
            sb.append(' ');
            sb.append(this.getName());
        }
        return sb.toString();
    }

    private char formatType() {
        switch (this.type) {
            case 0: {
                return '-';
            }
            case 1: {
                return 'd';
            }
            case 2: {
                return 'l';
            }
        }
        return '?';
    }

    private String permissionToString(int access) {
        StringBuilder sb = new StringBuilder();
        if (this.hasPermission(access, 0)) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if (this.hasPermission(access, 1)) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if (this.hasPermission(access, 2)) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }
}

