/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.filetree;

import com.github.weisj.darklaf.components.filetree.FileTreeModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class FileNode
implements Comparable<FileNode> {
    private static final AtomicBoolean LOCKED = new AtomicBoolean(false);
    private final Object lock = new Object();
    private volatile File file;
    private final Path path;
    private final String pathName;
    private boolean empty;
    private boolean valid;
    private Icon icon;

    public FileNode(File file, Path path) {
        this.file = file;
        this.path = path;
        String string = this.pathName = this.file != null ? this.file.getAbsolutePath() : null;
        if (this.file == null) {
            this.file = this.getFile();
        }
    }

    public void invalidate() {
        this.valid = false;
        this.icon = null;
    }

    protected boolean validateEmptyFlag(boolean showHiddenFiles) {
        if (!this.valid && this.path != null) {
            try (Stream<Path> s = Files.list(this.path);){
                this.empty = s.filter(Files::isReadable).noneMatch(p -> showHiddenFiles || !FileNode.isHidden(p));
                this.valid = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.valid;
    }

    public static FileNode fromPath(Path path) {
        return new FileNode(null, path);
    }

    public static FileNode fromFile(File file) {
        return new FileNode(file, FileNode.toPath(file));
    }

    private static Path toPath(File file) {
        try {
            return file.toPath();
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    public boolean isDirectory() {
        if (this.path != null) {
            return Files.isDirectory(this.path, new LinkOption[0]);
        }
        return this.file != null && this.file.isDirectory();
    }

    public boolean exists() {
        if (this.path != null) {
            return Files.exists(this.path, new LinkOption[0]);
        }
        return this.file != null && this.file.exists();
    }

    public boolean notExists() {
        if (this.path != null) {
            return Files.notExists(this.path, new LinkOption[0]);
        }
        return this.file == null || !this.file.exists();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileNode on = (FileNode)o;
        if (this.path != null && on.path != null) {
            return this.path.equals(on.path);
        }
        return Objects.equals(this.pathName, ((FileNode)o).pathName);
    }

    public int hashCode() {
        if (this.path != null) {
            return this.path.hashCode();
        }
        return Objects.hashCode(this.pathName);
    }

    public String toString() {
        return this.path != null ? this.path.toString() : (this.file != null ? this.pathName : "null node");
    }

    @Override
    public int compareTo(FileNode o) {
        if (o == null) {
            return -1;
        }
        if (this.path != null && o.path != null) {
            return this.path.compareTo(o.path);
        }
        return this.pathName.compareTo(o.pathName);
    }

    public boolean isHidden() {
        boolean hidden = FileNode.isHidden(this.path);
        if (this.file != null) {
            hidden = hidden || this.file.isHidden();
        }
        return hidden;
    }

    private static boolean isHidden(Path path) {
        if (path != null) {
            try {
                return Files.isHidden(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isEmpty(boolean showHiddenFiles) {
        if (this.path != null && this.validateEmptyFlag(showHiddenFiles)) {
            return this.empty;
        }
        return this.file == null || !this.file.isDirectory();
    }

    public boolean isReadable() {
        if (this.path != null) {
            return Files.isReadable(this.path);
        }
        return this.file != null && this.file.canRead();
    }

    public Stream<FileNode> list(FileTreeModel model) throws IOException {
        Stream<FileNode> stream;
        if (this.path != null) {
            stream = Files.list(this.path).map(FileNode::fromPath);
        } else if (this.file != null) {
            LOCKED.set(true);
            File[] files = model.fsv.getFiles(this.file, !model.showHiddenFiles);
            stream = (Stream)Arrays.stream(files).map(FileNode::fromFile).onClose(() -> LOCKED.set(false));
        } else {
            stream = Stream.empty();
        }
        return stream;
    }

    public Icon getSystemIcon(FileSystemView fsv) {
        if (this.icon == null) {
            this.icon = fsv.getSystemIcon(this.getFile());
        }
        return this.icon;
    }

    public String getSystemDisplayName(FileSystemView fsv) {
        File f = this.getFile();
        if (f == null) {
            return this.path != null ? String.valueOf(this.path.getFileName()) : "";
        }
        return fsv.getSystemDisplayName(f);
    }

    public Path getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile() {
        Object object = this.lock;
        synchronized (object) {
            if (this.file == null && this.path != null && !LOCKED.get()) {
                this.file = this.path.toFile();
            }
            return this.file;
        }
    }
}

