/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.graphics;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public final class GraphicsUtil {
    public static final String DESKTOP_HINTS_KEY = "awt.font.desktophints";
    public static final String KEY_OPAQUE_BUFFERED = "JComponent.opaqueBuffered";

    private GraphicsUtil() {
    }

    public static void setOpaqueBuffered(JComponent c, boolean opaqueBuffered) {
        if (c != null) {
            c.putClientProperty(KEY_OPAQUE_BUFFERED, opaqueBuffered);
        }
    }

    public static boolean isOpaqueBuffered(JComponent c) {
        if (!SystemInfo.isWindows) {
            return false;
        }
        return PropertyUtil.getBooleanProperty((JComponent)c, (String)KEY_OPAQUE_BUFFERED);
    }

    public static GraphicsContext setupAntialiasing(Graphics g2) {
        return GraphicsUtil.setupAntialiasing(g2, true, false);
    }

    public static GraphicsContext setupAntialiasing(Graphics g2, boolean enableAA, boolean ignoreSystemSettings) {
        GraphicsContext config = new GraphicsContext(g2);
        if (ignoreSystemSettings && g2 instanceof Graphics2D) {
            Graphics2D g = (Graphics2D)g2;
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, enableAA ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        return config;
    }

    public static GraphicsContext setupAAPainting(Graphics g) {
        GraphicsContext config = new GraphicsContext(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        return config;
    }

    public static GraphicsContext paintWithAlpha(Graphics g, float alpha) {
        assert (0.0f <= alpha && alpha <= 1.0f) : "alpha should be in range 0.0f .. 1.0f";
        GraphicsContext config = new GraphicsContext(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(AlphaComposite.getInstance(3, alpha));
        return config;
    }

    public static GraphicsContext setupStrokePainting(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        GraphicsContext context = new GraphicsContext(g2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, GraphicsUtil.useQuartz() ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        return context;
    }

    public static boolean isHighDpiEnabled() {
        return "true".equalsIgnoreCase(System.getProperty("hidpi"));
    }

    public static boolean useQuartz() {
        return SystemInfo.isMac && "true".equals(System.getProperty("apple.awt.graphics.UseQuartz"));
    }
}

