/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.togglebutton;

import com.github.weisj.darklaf.ui.togglebutton.ButtonGroupInfo;
import com.github.weisj.darklaf.ui.togglebutton.DarkToggleButtonKeyHandler;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.KeyStroke;

public class ToggleButtonFocusNavigationActions {
    private final KeyListener keyListener;
    private final AbstractButton button;
    private boolean traversalKeysEnabled;

    public ToggleButtonFocusNavigationActions(AbstractButton button) {
        this.button = button;
        this.keyListener = new DarkToggleButtonKeyHandler();
    }

    public void installActions() {
        if (this.button == null) {
            return;
        }
        this.traversalKeysEnabled = this.button.getFocusTraversalKeysEnabled();
        this.button.setFocusTraversalKeysEnabled(false);
        this.button.addKeyListener(this.keyListener);
        this.button.getActionMap().put("Previous", new SelectPreviousBtn());
        this.button.getActionMap().put("Next", new SelectNextBtn());
        this.button.getInputMap(1).put(KeyStroke.getKeyStroke("UP"), "Previous");
        this.button.getInputMap(1).put(KeyStroke.getKeyStroke("DOWN"), "Next");
        this.button.getInputMap(1).put(KeyStroke.getKeyStroke("LEFT"), "Previous");
        this.button.getInputMap(1).put(KeyStroke.getKeyStroke("RIGHT"), "Next");
    }

    public void uninstallActions() {
        if (this.button == null) {
            return;
        }
        if (!this.button.getFocusTraversalKeysEnabled()) {
            this.button.setFocusTraversalKeysEnabled(this.traversalKeysEnabled);
        }
        this.button.removeKeyListener(this.keyListener);
        this.button.getActionMap().remove("Previous");
        this.button.getActionMap().remove("Next");
        this.button.getInputMap(1).remove(KeyStroke.getKeyStroke("UP"));
        this.button.getInputMap(1).remove(KeyStroke.getKeyStroke("DOWN"));
        this.button.getInputMap(1).remove(KeyStroke.getKeyStroke("LEFT"));
        this.button.getInputMap(1).remove(KeyStroke.getKeyStroke("RIGHT"));
    }

    protected static void selectToggleButton(ActionEvent event, boolean next) {
        Object eventSrc = event.getSource();
        if (!ButtonGroupInfo.isValidButton(eventSrc)) {
            return;
        }
        ButtonGroupInfo btnGroupInfo = new ButtonGroupInfo((AbstractButton)eventSrc);
        btnGroupInfo.selectNewButton(next);
    }

    public static class SelectNextBtn
    extends AbstractAction {
        public SelectNextBtn() {
            super("Next");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToggleButtonFocusNavigationActions.selectToggleButton(e, true);
        }
    }

    public static class SelectPreviousBtn
    extends AbstractAction {
        public SelectPreviousBtn() {
            super("Previous");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToggleButtonFocusNavigationActions.selectToggleButton(e, false);
        }
    }
}

