
ifeq ($(CONFIG_STATIC),y)
CONFIG_PLUGIN=n
CFLAGS+=-DSTATIC=1
LDFLAGS := $(LDFLAGS) -static
endif

ifeq ($(CONFIG_THREADS),y)
CFLAGS := $(CFLAGS) -DUSETHREADS=1  -D_REENTRANT=1 -DLONGTHREADS
LIBS :=  $(THREADSLIB) $(LIBS)
endif

ifeq ($(CONFIG_PLUGIN),n)
CFLAGS := $(CFLAGS) -DNODL=1
else
LDFLAGS := $(LDFLAGS)  -rdynamic
LIBS := $(LIBS) $(DL_LIBRARY)
endif


OPTIM=-O3
ifeq ($(CONFIG_DEBUG),y)
OPTS:=-g $(OPTS)
CFLAGS :=  $(CFLAGS) -DTRACEON  -DDEBUGON -DDEBUGFLAG
OBJ :=  $(OBJ) debug.o myalloc.o 
else
	ifeq ($(CONFIG_DEBUG),n)
	OPTS := $(OPTIM) $(OPTS)
	CFLAGS+=-DNDEBUG=1
	#OPTS := $(OPTS)
	else
		ifeq ($(CONFIG_DEBUG),t)
			OPTS:=$(OPTIM) $(OPTS)
			CFLAGS :=  $(CFLAGS) -DTRACEON  -DDEBUGON -DDEBUGFLAG
			OBJ :=  $(OBJ) debug.o myalloc.o
		else	
			ifeq ($(CONFIG_DEBUG),o)
				OPTS:=-g -O2 $(OPTS)
				CFLAGS :=  $(CFLAGS) -DDEBUGFLAG
			else
				ifeq ($(CONFIG_DEBUG),k)
					OPTS:=-g -O       $(OPTS)
					CFLAGS :=  $(CFLAGS) -DDEBUGFLAG
				else
					OPTS:=-g $(OPTS)
					CFLAGS :=  $(CFLAGS) -DDEBUGFLAG
				endif
			endif
		endif
	endif
endif

ifeq ($(CONFIG_MMAP),y)
CFLAGS := $(CFLAGS) -DUSE_MMAP=1
endif
ifeq ($(CONFIG_LARGEFILES),y)
CFLAGS := $(CFLAGS) -DLARGEFILES=8
endif

ifneq ($(LINKIN) $(LINKINDYN),)
ifneq ($(CYGWIN),yes)
ifneq ($(filter switchsize.plug putselect.plug, $(LINKIN) $(LINKINDYN)),)
#LIBS+=$(X_PRE_LIBS) -lX11 $(X_EXTRA_LIBS)
LIBS+= -lX11 $(X_EXTRA_LIBS)
CFLAGS+=$(X_FLAGS)
LDFLAGS+=$(X_LIBS)
endif
endif
INLINK= $(INLINKLIB)
INLINK_H= inlink.h
ifneq ($(LINKINDYN),)
CFLAGS+=-DFAKE_DYNAMIC=1
endif
else
INLINK=
INLINK_H=
endif

ifeq ($(CONFIG_WRITEBETWEENPARTS),y)
CFLAGS+= -DNOBACKGROUND  -DSPACEBETWEEN 
else
	ifeq ($(CONFIG_WRITEBETWEENPARTS),b)
	CFLAGS+= -DNOBACKGROUND  -DSPACEBETWEEN -DLINESBETWEEN
	else
		ifeq ($(CONFIG_WRITEBETWEENPARTS),c)
			CFLAGS+= -DNOBACKGROUND  -DSPACEBETWEEN -DLINESBETWEEN -DLINEAFTER
		else
			ifeq ($(CONFIG_WRITEBETWEENPARTS),i)
			CFLAGS+= -DNOBACKGROUND  -DSPACEBETWEEN -DLINESBETWEEN -DLINESBETWEENITEMS
			endif
		endif
	endif
endif
ifeq ($(CONFIG_MENULINES),y)
CFLAGS+= -DLINEMENUS
endif

ifneq ($(CONFIG_COLOR),n)
CFLAGS+=-DCOMPILECOLORS=1
	ifeq ($(CONFIG_COLOR),o)
	CFLAGS+=-DSTARTBLACKWHITE=1
	else
	CFLAGS+=-DSTARTBLACKWHITE=0
	endif
endif

#ifneq ($(CYGWIN),yes)
#OBJECTS+=win32.o
#endif
ifeq ($(CONFIG_XBED),y)
	CFLAGS+=-DUSE_WITH_XBED=1
endif

