/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import com.google.classpath.ClassPathFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.swing.text.BadLocationException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.Util;
import processing.data.IntList;
import processing.data.StringList;
import processing.mode.java.JavaEditor;
import processing.mode.java.JavaMode;
import processing.mode.java.pdex.ImportStatement;
import processing.mode.java.pdex.PreprocessedSketch;
import processing.mode.java.pdex.SourceUtils;
import processing.mode.java.pdex.TextTransform;
import processing.mode.java.preproc.PdePreprocessor;

public class PreprocessingService {
    protected final JavaEditor editor;
    protected final ASTParser parser = ASTParser.newParser((int)8);
    private final ClassPathFactory classPathFactory = new ClassPathFactory();
    private final Thread preprocessingThread;
    private final BlockingQueue<Boolean> requestQueue = new ArrayBlockingQueue<Boolean>(1);
    private final Object requestLock = new Object();
    private final AtomicBoolean codeFolderChanged = new AtomicBoolean(true);
    private final AtomicBoolean librariesChanged = new AtomicBoolean(true);
    private volatile boolean running;
    private CompletableFuture<PreprocessedSketch> preprocessingTask = new CompletableFuture();
    private CompletableFuture<?> lastCallback = new CompletableFuture<Object>(){
        {
            this.complete(null);
        }
    };
    private volatile boolean isEnabled = true;
    private Set<Consumer<PreprocessedSketch>> listeners = new CopyOnWriteArraySet<Consumer<PreprocessedSketch>>();
    private List<ImportStatement> coreAndDefaultImports;
    private List<String> javaRuntimeClassPath;
    private List<String> sketchModeClassPath;
    private List<String> searchModeClassPath;
    private List<String> coreLibraryClassPath;
    private List<String> codeFolderClassPath;
    private List<String> sketchLibraryClassPath;
    private List<String> searchLibraryClassPath;
    private static final Map<String, String> COMPILER_OPTIONS;

    static {
        String s;
        HashMap<String, String> compilerOptions = new HashMap<String, String>();
        JavaCore.setComplianceOptions((String)"1.7", compilerOptions);
        String[] generate = new String[]{"org.eclipse.jdt.core.compiler.debug.lineNumber", "org.eclipse.jdt.core.compiler.debug.sourceFile"};
        String[] ignore = new String[]{"org.eclipse.jdt.core.compiler.problem.unusedImport", "org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "org.eclipse.jdt.core.compiler.problem.rawTypeReference", "org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"};
        String[] warn = new String[]{"org.eclipse.jdt.core.compiler.problem.noEffectAssignment", "org.eclipse.jdt.core.compiler.problem.nullReference", "org.eclipse.jdt.core.compiler.problem.potentialNullReference", "org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", "org.eclipse.jdt.core.compiler.problem.unusedLabel", "org.eclipse.jdt.core.compiler.problem.unusedLocal", "org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "org.eclipse.jdt.core.compiler.problem.unusedParameter", "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember"};
        String[] stringArray = generate;
        int n = generate.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            compilerOptions.put(s, "generate");
            ++n2;
        }
        stringArray = ignore;
        n = ignore.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            compilerOptions.put(s, "ignore");
            ++n2;
        }
        stringArray = warn;
        n = warn.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            compilerOptions.put(s, "warning");
            ++n2;
        }
        COMPILER_OPTIONS = Collections.unmodifiableMap(compilerOptions);
    }

    public PreprocessingService(JavaEditor editor) {
        this.editor = editor;
        this.isEnabled = !editor.hasJavaTabs();
        this.whenDone(this::fireListeners);
        this.preprocessingThread = new Thread(this::mainLoop, "ECS");
        this.preprocessingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        this.running = true;
        PreprocessedSketch prevResult = null;
        CompletableFuture<?> runningCallbacks = null;
        Messages.log((String)"PPS: Hi!");
        while (this.running) {
            try {
                try {
                    this.requestQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    this.running = false;
                    break;
                }
                Messages.log((String)"PPS: Starting");
                prevResult = this.preprocessSketch(prevResult);
                while (this.requestQueue.isEmpty() && runningCallbacks != null) {
                    try {
                        runningCallbacks.get(10L, TimeUnit.MILLISECONDS);
                        runningCallbacks = null;
                    }
                    catch (TimeoutException timeoutException) {}
                }
                Object object = this.requestLock;
                synchronized (object) {
                    if (this.requestQueue.isEmpty()) {
                        runningCallbacks = this.lastCallback;
                        Messages.log((String)"PPS: Done");
                        this.preprocessingTask.complete(prevResult);
                    }
                }
            }
            catch (Exception e) {
                Messages.loge((String)"problem in preprocessor service loop", (Throwable)e);
            }
        }
        Messages.log((String)"PPS: Bye!");
    }

    public void dispose() {
        this.cancel();
        this.running = false;
        this.preprocessingThread.interrupt();
    }

    public void cancel() {
        this.requestQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySketchChanged() {
        if (!this.isEnabled) {
            return;
        }
        Object object = this.requestLock;
        synchronized (object) {
            if (this.preprocessingTask.isDone()) {
                this.preprocessingTask = new CompletableFuture();
                this.whenDone(this::fireListeners);
            }
            this.requestQueue.offer(Boolean.TRUE);
        }
    }

    public void notifyLibrariesChanged() {
        Messages.log((String)"PPS: notified libraries changed");
        this.librariesChanged.set(true);
        this.notifySketchChanged();
    }

    public void notifyCodeFolderChanged() {
        Messages.log((String)"PPS: snotified code folder changed");
        this.codeFolderChanged.set(true);
        this.notifySketchChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<?> registerCallback(Consumer<PreprocessedSketch> callback) {
        Object object = this.requestLock;
        synchronized (object) {
            this.lastCallback = ((CompletableFuture)this.preprocessingTask.thenAcceptBothAsync(this.lastCallback, (ps, a) -> callback.accept((PreprocessedSketch)ps))).handleAsync((res, e) -> {
                if (e != null) {
                    Messages.loge((String)"PPS: exception in callback", (Throwable)e);
                }
                return res;
            });
            return this.lastCallback;
        }
    }

    public void whenDone(Consumer<PreprocessedSketch> callback) {
        if (!this.isEnabled) {
            return;
        }
        this.registerCallback(callback);
    }

    public void whenDoneBlocking(Consumer<PreprocessedSketch> callback) {
        if (!this.isEnabled) {
            return;
        }
        try {
            this.registerCallback(callback).get(3000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {}
    }

    public void registerListener(Consumer<PreprocessedSketch> listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void unregisterListener(Consumer<PreprocessedSketch> listener) {
        this.listeners.remove(listener);
    }

    private void fireListeners(PreprocessedSketch ps) {
        for (Consumer<PreprocessedSketch> listener : this.listeners) {
            try {
                listener.accept(ps);
            }
            catch (Exception e) {
                Messages.loge((String)"error when firing preprocessing listener", (Throwable)e);
            }
        }
    }

    private PreprocessedSketch preprocessSketch(PreprocessedSketch prevResult) {
        boolean rebuildClassPath;
        boolean rebuildLibraryClassPath;
        boolean reloadLibraries;
        boolean firstCheck = prevResult == null;
        PreprocessedSketch.Builder result = new PreprocessedSketch.Builder();
        List<ImportStatement> codeFolderImports = result.codeFolderImports;
        List<ImportStatement> programImports = result.programImports;
        JavaMode javaMode = (JavaMode)this.editor.getMode();
        Sketch sketch = result.sketch = this.editor.getSketch();
        String className = sketch.getName();
        StringBuilder workBuffer = new StringBuilder();
        IntList tabStartsList = new IntList();
        SketchCode[] sketchCodeArray = sketch.getCode();
        int n = sketchCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SketchCode sc = sketchCodeArray[n2];
            if (sc.isExtension("pde")) {
                tabStartsList.append(workBuffer.length());
                if (sc.getDocument() != null) {
                    try {
                        workBuffer.append(sc.getDocumentText());
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                } else {
                    workBuffer.append(sc.getProgram());
                }
                workBuffer.append('\n');
            }
            ++n2;
        }
        result.tabStartOffsets = tabStartsList.array();
        String pdeStage = result.pdeCode = workBuffer.toString();
        boolean reloadCodeFolder = firstCheck || this.codeFolderChanged.getAndSet(false);
        boolean bl = reloadLibraries = firstCheck || this.librariesChanged.getAndSet(false);
        if (this.coreAndDefaultImports == null) {
            PdePreprocessor p = this.editor.createPreprocessor(null);
            this.coreAndDefaultImports = PreprocessingService.buildCoreAndDefaultImports(p);
        }
        result.coreAndDefaultImports.addAll(this.coreAndDefaultImports);
        if (reloadCodeFolder) {
            codeFolderImports.addAll(PreprocessingService.buildCodeFolderImports(sketch));
        } else {
            codeFolderImports.addAll(prevResult.codeFolderImports);
        }
        SourceUtils.scrubCommentsAndStrings(workBuffer);
        result.scrubbedPdeCode = workBuffer.toString();
        PdePreprocessor.Mode sketchMode = PdePreprocessor.parseMode(workBuffer);
        TextTransform toParsable = new TextTransform(pdeStage);
        toParsable.addAll(SourceUtils.insertImports(this.coreAndDefaultImports));
        toParsable.addAll(SourceUtils.insertImports(codeFolderImports));
        toParsable.addAll(SourceUtils.parseProgramImports(workBuffer, programImports));
        toParsable.addAll(SourceUtils.replaceTypeConstructors(workBuffer));
        toParsable.addAll(SourceUtils.replaceHexLiterals(workBuffer));
        toParsable.addAll(SourceUtils.wrapSketch(sketchMode, className, workBuffer.length()));
        if (this.javaRuntimeClassPath == null) {
            this.javaRuntimeClassPath = PreprocessingService.buildJavaRuntimeClassPath();
            this.sketchModeClassPath = PreprocessingService.buildModeClassPath(javaMode, false);
            this.searchModeClassPath = PreprocessingService.buildModeClassPath(javaMode, true);
        }
        if (reloadLibraries) {
            this.coreLibraryClassPath = PreprocessingService.buildCoreLibraryClassPath(javaMode);
        }
        boolean bl2 = rebuildLibraryClassPath = reloadLibraries || PreprocessingService.checkIfImportsChanged(programImports, prevResult.programImports);
        if (rebuildLibraryClassPath) {
            this.sketchLibraryClassPath = PreprocessingService.buildSketchLibraryClassPath(javaMode, programImports);
            this.searchLibraryClassPath = PreprocessingService.buildSearchLibraryClassPath(javaMode);
        }
        boolean bl3 = rebuildClassPath = reloadCodeFolder || rebuildLibraryClassPath || prevResult.classLoader == null || prevResult.classPath == null || prevResult.classPathArray == null || prevResult.searchClassPathArray == null;
        if (reloadCodeFolder) {
            this.codeFolderClassPath = PreprocessingService.buildCodeFolderClassPath(sketch);
        }
        if (rebuildClassPath) {
            ArrayList<String> sketchClassPath = new ArrayList<String>();
            sketchClassPath.addAll(this.javaRuntimeClassPath);
            sketchClassPath.addAll(this.sketchModeClassPath);
            sketchClassPath.addAll(this.sketchLibraryClassPath);
            sketchClassPath.addAll(this.coreLibraryClassPath);
            sketchClassPath.addAll(this.codeFolderClassPath);
            String[] classPathArray = (String[])sketchClassPath.stream().toArray(String[]::new);
            URL[] urlArray = (URL[])Arrays.stream(classPathArray).map(path -> {
                try {
                    return Paths.get(path, new String[0]).toUri().toURL();
                }
                catch (MalformedURLException e) {
                    Messages.loge((String)"malformed URL when preparing sketch classloader", (Throwable)e);
                    return null;
                }
            }).filter(url -> url != null).toArray(URL[]::new);
            result.classLoader = new URLClassLoader(urlArray, null);
            result.classPath = this.classPathFactory.createFromPaths(classPathArray);
            result.classPathArray = classPathArray;
            ArrayList<String> searchClassPath = new ArrayList<String>();
            searchClassPath.addAll(this.javaRuntimeClassPath);
            searchClassPath.addAll(this.searchModeClassPath);
            searchClassPath.addAll(this.searchLibraryClassPath);
            searchClassPath.addAll(this.coreLibraryClassPath);
            searchClassPath.addAll(this.codeFolderClassPath);
            result.searchClassPathArray = (String[])searchClassPath.stream().toArray(String[]::new);
        } else {
            result.classLoader = prevResult.classLoader;
            result.classPath = prevResult.classPath;
            result.searchClassPathArray = prevResult.searchClassPathArray;
            result.classPathArray = prevResult.classPathArray;
        }
        String parsableStage = toParsable.apply();
        TextTransform.OffsetMapper parsableMapper = toParsable.getMapper();
        CompilationUnit parsableCU = PreprocessingService.makeAST(this.parser, parsableStage.toCharArray(), COMPILER_OPTIONS);
        TextTransform toCompilable = new TextTransform(parsableStage);
        toCompilable.addAll(SourceUtils.preprocessAST(parsableCU));
        String compilableStage = toCompilable.apply();
        TextTransform.OffsetMapper compilableMapper = toCompilable.getMapper();
        char[] compilableStageChars = compilableStage.toCharArray();
        CompilationUnit compilableCU = PreprocessingService.makeAST(this.parser, compilableStageChars, COMPILER_OPTIONS);
        result.hasSyntaxErrors |= Arrays.stream(compilableCU.getProblems()).anyMatch(IProblem::isError);
        CompilationUnit bindingsCU = PreprocessingService.makeASTWithBindings(this.parser, compilableStageChars, COMPILER_OPTIONS, className, result.classPathArray);
        List<IProblem> bindingsProblems = Arrays.asList(bindingsCU.getProblems());
        result.hasCompilationErrors = bindingsProblems.stream().anyMatch(IProblem::isError);
        result.offsetMapper = parsableMapper.thenMapping(compilableMapper);
        result.javaCode = compilableStage;
        result.compilationUnit = bindingsCU;
        return result.build();
    }

    private static List<ImportStatement> buildCoreAndDefaultImports(PdePreprocessor p) {
        String imp;
        ArrayList<ImportStatement> result = new ArrayList<ImportStatement>();
        String[] stringArray = p.getCoreImports();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            imp = stringArray[n2];
            result.add(ImportStatement.parse(imp));
            ++n2;
        }
        stringArray = p.getDefaultImports();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            imp = stringArray[n2];
            result.add(ImportStatement.parse(imp));
            ++n2;
        }
        return result;
    }

    private static List<ImportStatement> buildCodeFolderImports(Sketch sketch) {
        if (sketch.hasCodeFolder()) {
            File codeFolder = sketch.getCodeFolder();
            String codeFolderClassPath = Util.contentsToClassPath((File)codeFolder);
            StringList codeFolderPackages = Util.packageListFromClassPath((String)codeFolderClassPath);
            return StreamSupport.stream(codeFolderPackages.spliterator(), false).map(ImportStatement::wholePackage).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean checkIfImportsChanged(List<ImportStatement> prevImports, List<ImportStatement> imports) {
        if (imports.size() != prevImports.size()) {
            return true;
        }
        int count = imports.size();
        int i = 0;
        while (i < count) {
            if (!imports.get(i).isSameAs(prevImports.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static List<String> buildCodeFolderClassPath(Sketch sketch) {
        StringBuilder classPath = new StringBuilder();
        if (sketch.hasCodeFolder()) {
            File codeFolder = sketch.getCodeFolder();
            String codeFolderClassPath = Util.contentsToClassPath((File)codeFolder);
            classPath.append(codeFolderClassPath);
        }
        return PreprocessingService.sanitizeClassPath(classPath.toString());
    }

    private static List<String> buildModeClassPath(JavaMode mode, boolean search) {
        StringBuilder classPath = new StringBuilder();
        if (search) {
            String searchClassPath = mode.getSearchPath();
            if (searchClassPath != null) {
                classPath.append(File.pathSeparator).append(searchClassPath);
            }
        } else {
            String coreClassPath;
            Library coreLibrary = mode.getCoreLibrary();
            String string = coreClassPath = coreLibrary != null ? coreLibrary.getClassPath() : mode.getSearchPath();
            if (coreClassPath != null) {
                classPath.append(File.pathSeparator).append(coreClassPath);
            }
        }
        return PreprocessingService.sanitizeClassPath(classPath.toString());
    }

    private static List<String> buildCoreLibraryClassPath(JavaMode mode) {
        StringBuilder classPath = new StringBuilder();
        for (Library lib : mode.coreLibraries) {
            classPath.append(File.pathSeparator).append(lib.getClassPath());
        }
        return PreprocessingService.sanitizeClassPath(classPath.toString());
    }

    private static List<String> buildSearchLibraryClassPath(JavaMode mode) {
        StringBuilder classPath = new StringBuilder();
        for (Library lib : mode.contribLibraries) {
            classPath.append(File.pathSeparator).append(lib.getClassPath());
        }
        return PreprocessingService.sanitizeClassPath(classPath.toString());
    }

    private static List<String> buildSketchLibraryClassPath(JavaMode mode, List<ImportStatement> programImports) {
        StringBuilder classPath = new StringBuilder();
        programImports.stream().map(ImportStatement::getPackageName).filter(pckg -> !PreprocessingService.ignorableImport(pckg)).map(pckg -> {
            try {
                return mode.getLibrary((String)pckg);
            }
            catch (SketchException sketchException) {
                return null;
            }
        }).filter(lib -> lib != null).map(Library::getClassPath).forEach(cp -> {
            StringBuilder stringBuilder2 = classPath.append(File.pathSeparator).append((String)cp);
        });
        return PreprocessingService.sanitizeClassPath(classPath.toString());
    }

    private static List<String> buildJavaRuntimeClassPath() {
        StringBuilder classPath = new StringBuilder();
        String rtPath = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "rt.jar";
        if (new File(rtPath).exists()) {
            classPath.append(File.pathSeparator).append(rtPath);
        } else {
            rtPath = String.valueOf(System.getProperty("java.home")) + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar";
            if (new File(rtPath).exists()) {
                classPath.append(File.pathSeparator).append(rtPath);
            }
        }
        String jfxrtPath = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "ext" + File.separator + "jfxrt.jar";
        if (new File(jfxrtPath).exists()) {
            classPath.append(File.pathSeparator).append(jfxrtPath);
        } else {
            jfxrtPath = String.valueOf(System.getProperty("java.home")) + File.separator + "jre" + File.separator + "lib" + File.separator + "ext" + File.separator + "jfxrt.jar";
            if (new File(jfxrtPath).exists()) {
                classPath.append(File.pathSeparator).append(jfxrtPath);
            }
        }
        return PreprocessingService.sanitizeClassPath(classPath.toString());
    }

    private static List<String> sanitizeClassPath(String classPathString) {
        return Arrays.stream(classPathString.split(File.pathSeparator)).filter(p -> p != null && !p.trim().isEmpty()).distinct().collect(Collectors.toList());
    }

    private static CompilationUnit makeAST(ASTParser parser, char[] source, Map<String, String> options) {
        parser.setSource(source);
        parser.setKind(8);
        parser.setCompilerOptions(options);
        parser.setStatementsRecovery(true);
        return (CompilationUnit)parser.createAST(null);
    }

    private static CompilationUnit makeASTWithBindings(ASTParser parser, char[] source, Map<String, String> options, String className, String[] classPath) {
        parser.setSource(source);
        parser.setKind(8);
        parser.setCompilerOptions(options);
        parser.setStatementsRecovery(true);
        parser.setUnitName(className);
        parser.setEnvironment(classPath, null, null, false);
        parser.setResolveBindings(true);
        return (CompilationUnit)parser.createAST(null);
    }

    private static boolean ignorableImport(String packageName) {
        return packageName.startsWith("java.") || packageName.startsWith("javax.");
    }

    public void handleHasJavaTabsChange(boolean hasJavaTabs) {
        boolean bl = this.isEnabled = !hasJavaTabs;
        if (this.isEnabled) {
            this.notifySketchChanged();
        } else {
            this.preprocessingTask.cancel(false);
        }
    }
}

