/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.tweak;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import processing.mode.java.tweak.ColorScheme;

public class HProgressBar {
    int x;
    int y;
    int size;
    int width;
    int pos;
    int lPolyX;
    int rPolyX;
    Polygon rightPoly;
    Polygon leftPoly;

    public HProgressBar(int size, int width) {
        this.size = size;
        this.width = width;
        this.x = 0;
        this.y = 0;
        this.setPos(0);
        int[] nArray = new int[3];
        nArray[2] = -((int)((double)size / 1.5));
        int[] xl = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -((int)((float)size / 3.0f));
        nArray2[1] = (int)((float)size / 3.0f);
        int[] yl = nArray2;
        this.leftPoly = new Polygon(xl, yl, 3);
        int[] nArray3 = new int[3];
        nArray3[1] = (int)((double)size / 1.5);
        int[] xr = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -((int)((float)size / 3.0f));
        nArray4[2] = (int)((float)size / 3.0f);
        int[] yr = nArray4;
        this.rightPoly = new Polygon(xr, yr, 3);
    }

    public void setPos(int pos) {
        this.pos = pos;
        this.lPolyX = 0;
        this.rPolyX = 0;
        if (pos > 0) {
            this.rPolyX = pos;
        } else if (pos < 0) {
            this.lPolyX = pos;
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void draw(Graphics2D g2d) {
        AffineTransform trans = g2d.getTransform();
        g2d.translate(this.x, this.y);
        g2d.setColor(ColorScheme.getInstance().whitePaneColor);
        g2d.fillRect(-200 + this.lPolyX, -this.size, 200 - this.lPolyX - this.width / 2, this.size + 1);
        g2d.fillRect(this.width / 2, -this.size, 200 + this.rPolyX, this.size + 1);
        g2d.setColor(ColorScheme.getInstance().progressFillColor);
        AffineTransform tmp = g2d.getTransform();
        g2d.translate(-this.width / 2 - 5 + this.lPolyX, -this.size / 2);
        g2d.fillRect(0, -1, -this.lPolyX, 2);
        g2d.fillPolygon(this.leftPoly);
        g2d.setTransform(tmp);
        g2d.translate(this.width / 2 + 5 + this.rPolyX, -this.size / 2);
        g2d.fillRect(-this.rPolyX, -1, this.rPolyX + 1, 2);
        g2d.fillPolygon(this.rightPoly);
        g2d.setTransform(tmp);
        g2d.setTransform(trans);
    }
}

