/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Sketch;
import processing.app.Util;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.data.StringDict;
import processing.data.StringList;

public class Library
extends LocalContribution {
    static final String[] platformNames = PConstants.platformNames;
    protected File libraryFolder;
    protected File examplesFolder;
    protected File referenceFile;
    protected String group;
    StringList packageList;
    HashMap<String, String[]> exportList;
    String[] appletExportList;
    String[] androidExportList;
    boolean[] multipleArch = new boolean[platformNames.length];
    String nativeLibraryPath;
    public static final String propertiesFileName = "library.properties";
    static FilenameFilter standardFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            if (name.charAt(0) == '.') {
                return false;
            }
            if (name.equals("CVS")) {
                return false;
            }
            if (name.equals("export.txt")) {
                return false;
            }
            File file = new File(dir, name);
            if (file.isDirectory()) {
                if (name.equals("macosx")) {
                    return false;
                }
                if (name.equals("macosx32")) {
                    return false;
                }
                if (name.equals("macosx64")) {
                    return false;
                }
                if (name.equals("windows")) {
                    return false;
                }
                if (name.equals("windows32")) {
                    return false;
                }
                if (name.equals("windows64")) {
                    return false;
                }
                if (name.equals("linux")) {
                    return false;
                }
                if (name.equals("linux32")) {
                    return false;
                }
                if (name.equals("linux64")) {
                    return false;
                }
                if (name.equals("linux-armv6hf")) {
                    return false;
                }
                if (name.equals("linux-arm64")) {
                    return false;
                }
                if (name.equals("android")) {
                    return false;
                }
            }
            return true;
        }
    };
    static FilenameFilter jarFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            if (name.charAt(0) == '.') {
                return false;
            }
            if (new File(dir, name).isDirectory()) {
                return false;
            }
            String lc = name.toLowerCase();
            return lc.endsWith(".jar") || lc.endsWith(".zip");
        }
    };
    protected static HashMap<String, Object> packageWarningMap = new HashMap();
    protected static FilenameFilter junkFolderFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            if (name.charAt(0) == '.') {
                return false;
            }
            if (name.equals("CVS")) {
                return false;
            }
            return new File(dir, name).isDirectory();
        }
    };

    public static Library load(File folder) {
        try {
            return new Library(folder);
        }
        catch (Error err) {
            err.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public Library(File folder) {
        this(folder, null);
    }

    private Library(File folder, String groupName) {
        super(folder);
        this.group = groupName;
        this.libraryFolder = new File(folder, "library");
        this.examplesFolder = new File(folder, "examples");
        this.referenceFile = new File(folder, "reference/index.html");
        this.handle();
    }

    protected void handle() {
        File exportSettings = new File(this.libraryFolder, "export.txt");
        StringDict exportTable = exportSettings.exists() ? Util.readSettings(exportSettings) : new StringDict();
        this.exportList = new HashMap();
        String[] baseList = this.libraryFolder.list(standardFilter);
        String appletExportStr = exportTable.get("applet");
        this.appletExportList = appletExportStr != null ? PApplet.splitTokens((String)appletExportStr, (String)", ") : baseList;
        String androidExportStr = exportTable.get("android");
        this.androidExportList = androidExportStr != null ? PApplet.splitTokens((String)androidExportStr, (String)", ") : baseList;
        File nativeLibraryFolder = this.libraryFolder;
        String hostPlatform = Platform.getName();
        File hostLibrary = new File(this.libraryFolder, hostPlatform);
        if (hostLibrary.exists()) {
            nativeLibraryFolder = hostLibrary;
        }
        if ((hostLibrary = new File(this.libraryFolder, String.valueOf(hostPlatform) + Platform.getNativeBits())).exists()) {
            nativeLibraryFolder = hostLibrary;
        }
        if (hostPlatform.equals("linux") && System.getProperty("os.arch").equals("arm") && (hostLibrary = new File(this.libraryFolder, "linux-armv6hf")).exists()) {
            nativeLibraryFolder = hostLibrary;
        }
        if (hostPlatform.equals("linux") && System.getProperty("os.arch").equals("aarch64") && (hostLibrary = new File(this.libraryFolder, "linux-arm64")).exists()) {
            nativeLibraryFolder = hostLibrary;
        }
        this.nativeLibraryPath = nativeLibraryFolder.getAbsolutePath();
        int i = 1;
        while (i < platformNames.length) {
            String[] platformListArm64;
            String platformName = platformNames[i];
            String platformName32 = String.valueOf(platformName) + "32";
            String platformName64 = String.valueOf(platformName) + "64";
            String platformNameArmv6hf = String.valueOf(platformName) + "-armv6hf";
            String platformNameArm64 = String.valueOf(platformName) + "-arm64";
            String platformAll = exportTable.get("application." + platformName);
            String[] platformList = platformAll == null ? null : PApplet.splitTokens((String)platformAll, (String)", ");
            String platform32 = exportTable.get("application." + platformName + "32");
            String[] platformList32 = platform32 == null ? null : PApplet.splitTokens((String)platform32, (String)", ");
            String platform64 = exportTable.get("application." + platformName + "64");
            String[] platformList64 = platform64 == null ? null : PApplet.splitTokens((String)platform64, (String)", ");
            String platformArmv6hf = exportTable.get("application." + platformName + "-armv6hf");
            String[] platformListArmv6hf = platformArmv6hf == null ? null : PApplet.splitTokens((String)platformArmv6hf, (String)", ");
            String platformArm64 = exportTable.get("application." + platformName + "-arm64");
            String[] stringArray = platformListArm64 = platformArm64 == null ? null : PApplet.splitTokens((String)platformArm64, (String)", ");
            if (platformAll == null) {
                platformList = Library.listPlatformEntries(this.libraryFolder, platformName, baseList);
            }
            if (platform32 == null) {
                platformList32 = Library.listPlatformEntries(this.libraryFolder, platformName32, baseList);
            }
            if (platform64 == null) {
                platformList64 = Library.listPlatformEntries(this.libraryFolder, platformName64, baseList);
            }
            if (platformListArmv6hf == null) {
                platformListArmv6hf = Library.listPlatformEntries(this.libraryFolder, platformNameArmv6hf, baseList);
            }
            if (platformListArm64 == null) {
                platformListArm64 = Library.listPlatformEntries(this.libraryFolder, platformNameArm64, baseList);
            }
            if (platformList32 != null || platformList64 != null || platformListArmv6hf != null || platformListArm64 != null) {
                this.multipleArch[i] = true;
            }
            if (platformList == null && platformList32 == null && platformList64 == null && platformListArmv6hf == null && platformListArm64 == null) {
                this.exportList.put(platformName, baseList);
            } else {
                if (platformList != null) {
                    this.exportList.put(platformName, platformList);
                }
                if (platformList32 != null) {
                    this.exportList.put(platformName32, platformList32);
                }
                if (platformList64 != null) {
                    this.exportList.put(platformName64, platformList64);
                }
                if (platformListArmv6hf != null) {
                    this.exportList.put(platformNameArmv6hf, platformListArmv6hf);
                }
                if (platformListArm64 != null) {
                    this.exportList.put(platformNameArm64, platformListArm64);
                }
            }
            ++i;
        }
        this.packageList = Util.packageListFromClassPath(this.getClassPath());
    }

    static String[] listPlatformEntries(File libraryFolder, String folderName, String[] baseList) {
        String[] entries;
        File folder = new File(libraryFolder, folderName);
        if (folder.exists() && (entries = folder.list(standardFilter)) != null) {
            String[] outgoing = new String[entries.length + baseList.length];
            int i = 0;
            while (i < entries.length) {
                outgoing[i] = String.valueOf(folderName) + "/" + entries[i];
                ++i;
            }
            System.arraycopy(baseList, 0, outgoing, entries.length, baseList.length);
            return outgoing;
        }
        return null;
    }

    public void addPackageList(Map<String, List<Library>> importToLibraryTable) {
        for (String pkg : this.packageList) {
            List<Library> libraries = importToLibraryTable.get(pkg);
            if (libraries == null) {
                libraries = new ArrayList<Library>();
                importToLibraryTable.put(pkg, libraries);
            } else if (Base.DEBUG) {
                System.err.println("The library found in");
                System.err.println(this.getPath());
                System.err.println("conflicts with");
                for (Library library : libraries) {
                    System.err.println(library.getPath());
                }
                System.err.println("which already define(s) the package " + pkg);
                System.err.println("If you have a line in your sketch that reads");
                System.err.println("import " + pkg + ".*;");
                System.err.println("Then you'll need to first remove one of those libraries.");
                System.err.println();
            }
            libraries.add(this);
        }
    }

    public boolean hasExamples() {
        return this.examplesFolder.exists();
    }

    public File getExamplesFolder() {
        return this.examplesFolder;
    }

    public String getGroup() {
        return this.group;
    }

    public String getPath() {
        return this.folder.getAbsolutePath();
    }

    public String getLibraryPath() {
        return this.libraryFolder.getAbsolutePath();
    }

    public String getJarPath() {
        return new File(this.libraryFolder, String.valueOf(this.folder.getName()) + ".jar").getAbsolutePath();
    }

    public String getClassPath() {
        String[] jarHeads;
        StringBuilder cp = new StringBuilder();
        String[] stringArray = jarHeads = this.libraryFolder.list(jarFilter);
        int n = jarHeads.length;
        int n2 = 0;
        while (n2 < n) {
            String jar = stringArray[n2];
            cp.append(File.pathSeparatorChar);
            cp.append(new File(this.libraryFolder, jar).getAbsolutePath());
            ++n2;
        }
        File nativeLibraryFolder = new File(this.nativeLibraryPath);
        if (!this.libraryFolder.equals(nativeLibraryFolder)) {
            String[] stringArray2 = jarHeads = new File(this.nativeLibraryPath).list(jarFilter);
            int n3 = jarHeads.length;
            n = 0;
            while (n < n3) {
                String jar = stringArray2[n];
                cp.append(File.pathSeparatorChar);
                cp.append(new File(this.nativeLibraryPath, jar).getAbsolutePath());
                ++n;
            }
        }
        return cp.toString();
    }

    public String getNativePath() {
        return this.nativeLibraryPath;
    }

    protected File[] wrapFiles(String[] list) {
        File[] outgoing = new File[list.length];
        int i = 0;
        while (i < list.length) {
            outgoing[i] = new File(this.libraryFolder, list[i]);
            ++i;
        }
        return outgoing;
    }

    public File[] getAppletExports() {
        return this.wrapFiles(this.appletExportList);
    }

    public File[] getApplicationExports(int platform, String variant) {
        String[] list = this.getApplicationExportList(platform, variant);
        return this.wrapFiles(list);
    }

    public String[] getApplicationExportList(int platform, String variant) {
        String[] pieces;
        String platformName = PConstants.platformNames[platform];
        if (variant.equals("32")) {
            String[] pieces2 = this.exportList.get(String.valueOf(platformName) + "32");
            if (pieces2 != null) {
                return pieces2;
            }
        } else if (variant.equals("64")) {
            String[] pieces3 = this.exportList.get(String.valueOf(platformName) + "64");
            if (pieces3 != null) {
                return pieces3;
            }
        } else if (variant.equals("armv6hf")) {
            String[] pieces4 = this.exportList.get(String.valueOf(platformName) + "-armv6hf");
            if (pieces4 != null) {
                return pieces4;
            }
        } else if (variant.equals("arm64") && (pieces = this.exportList.get(String.valueOf(platformName) + "-arm64")) != null) {
            return pieces;
        }
        return this.exportList.get(platformName);
    }

    public File[] getAndroidExports() {
        return this.wrapFiles(this.androidExportList);
    }

    public boolean hasMultipleArch(int platform) {
        return this.multipleArch[platform];
    }

    public boolean supportsArch(int platform, String variant) {
        if (!this.multipleArch[platform]) {
            return true;
        }
        return this.getApplicationExportList(platform, variant) != null;
    }

    public static boolean hasMultipleArch(int platform, List<Library> libraries) {
        return libraries.stream().anyMatch(library -> library.hasMultipleArch(platform));
    }

    public static List<File> discover(File folder) {
        ArrayList<File> libraries = new ArrayList<File>();
        String[] folderNames = folder.list(junkFolderFilter);
        if (folderNames != null) {
            Arrays.sort(folderNames, String.CASE_INSENSITIVE_ORDER);
            String[] stringArray = folderNames;
            int n = folderNames.length;
            int n2 = 0;
            while (n2 < n) {
                String potentialName = stringArray[n2];
                File baseFolder = new File(folder, potentialName);
                File libraryFolder = new File(baseFolder, "library");
                File libraryJar = new File(libraryFolder, String.valueOf(potentialName) + ".jar");
                if (libraryJar.exists()) {
                    String sanityCheck = Sketch.sanitizeName(potentialName);
                    if (sanityCheck.equals(potentialName)) {
                        libraries.add(baseFolder);
                    } else {
                        String mess = "The library \"" + potentialName + "\" cannot be used.\n" + "Library names must contain only basic letters and numbers.\n" + "(ASCII only and no spaces, and it cannot start with a number)";
                        Messages.showMessage("Ignoring bad library name", mess);
                    }
                }
                ++n2;
            }
        }
        return libraries;
    }

    public static List<Library> list(File folder) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        ArrayList<File> librariesFolders = new ArrayList<File>();
        librariesFolders.addAll(Library.discover(folder));
        for (File baseFolder : librariesFolders) {
            libraries.add(new Library(baseFolder));
        }
        return libraries;
    }

    @Override
    public ContributionType getType() {
        return ContributionType.LIBRARY;
    }

    public File getReferenceIndexFile() {
        return this.referenceFile;
    }

    public boolean hasReference() {
        return this.referenceFile.exists();
    }
}

