/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.sun.jna.platform.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Util;
import processing.app.platform.DefaultPlatform;
import processing.core.PApplet;
import processing.core.PConstants;

public class Platform {
    static DefaultPlatform inst;
    static Map<Integer, String> platformNames;
    static Map<String, Integer> platformIndices;
    static int nativeBits;
    protected static File processingRoot;

    static {
        platformNames = new HashMap<Integer, String>();
        platformNames.put(1, "windows");
        platformNames.put(2, "macosx");
        platformNames.put(3, "linux");
        platformIndices = new HashMap<String, Integer>();
        platformIndices.put("windows", 1);
        platformIndices.put("macosx", 2);
        platformIndices.put("linux", 3);
        nativeBits = 32;
        String bits = System.getProperty("sun.arch.data.model");
        if (bits != null) {
            if (bits.equals("64")) {
                nativeBits = 64;
            }
        } else if (System.getProperty("java.vm.name").contains("64")) {
            nativeBits = 64;
        }
    }

    public static void init() {
        try {
            Class<?> platformClass = Class.forName("processing.app.Platform");
            if (Platform.isMacOS()) {
                platformClass = Class.forName("processing.app.platform.MacPlatform");
            } else if (Platform.isWindows()) {
                platformClass = Class.forName("processing.app.platform.WindowsPlatform");
            } else if (Platform.isLinux()) {
                platformClass = Class.forName("processing.app.platform.LinuxPlatform");
            }
            inst = (DefaultPlatform)platformClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Messages.showError("Problem Setting the Platform", "An unknown error occurred while trying to load\nplatform-specific code for your machine.", e);
        }
    }

    public static void initBase(Base base) throws Exception {
        inst.initBase(base);
    }

    public static void setLookAndFeel() throws Exception {
        inst.setLookAndFeel();
    }

    public static File getSettingsFolder() throws Exception {
        return inst.getSettingsFolder();
    }

    public static File getDefaultSketchbookFolder() throws Exception {
        return inst.getDefaultSketchbookFolder();
    }

    public static void saveLanguage(String languageCode) {
        inst.saveLanguage(languageCode);
    }

    public static void openURL(String url) {
        try {
            inst.openURL(url);
        }
        catch (Exception e) {
            Messages.showWarning("Problem Opening URL", "Could not open the URL\n" + url, e);
        }
    }

    public static boolean openFolderAvailable() {
        return inst.openFolderAvailable();
    }

    public static void openFolder(File file) {
        try {
            inst.openFolder(file);
        }
        catch (Exception e) {
            Messages.showWarning("Problem Opening Folder", "Could not open the folder\n" + file.getAbsolutePath(), e);
        }
    }

    public static int getNativeBits() {
        return nativeBits;
    }

    public static String getNativeArch() {
        return System.getProperty("os.arch");
    }

    public static String getVariant() {
        return Platform.getVariant(PApplet.platform, Platform.getNativeArch(), Platform.getNativeBits());
    }

    public static String getVariant(int platform, String arch, int bits) {
        if (platform == 3 && bits == 32 && "arm".equals(Platform.getNativeArch())) {
            return "armv6hf";
        }
        if (platform == 3 && bits == 64 && "aarch64".equals(Platform.getNativeArch())) {
            return "arm64";
        }
        return Integer.toString(bits);
    }

    public static String getName() {
        return PConstants.platformNames[PApplet.platform];
    }

    public static String getName(int which) {
        return platformNames.get(which);
    }

    public static int getIndex(String what) {
        Integer entry = platformIndices.get(what);
        return entry == null ? -1 : entry;
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").indexOf("Mac") != -1;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").indexOf("Linux") != -1;
    }

    public static File getContentFile(String name) {
        if (processingRoot == null) {
            String decodedPath;
            URL pathURL = Base.class.getProtectionDomain().getCodeSource().getLocation();
            try {
                decodedPath = pathURL.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
            if (decodedPath.contains("/app/bin")) {
                File build = new File(decodedPath, "../../build").getAbsoluteFile();
                if (Platform.isMacOS()) {
                    processingRoot = new File(build, "macosx/work/Processing.app/Contents/Java");
                } else if (Platform.isWindows()) {
                    processingRoot = new File(build, "windows/work");
                } else if (Platform.isLinux()) {
                    processingRoot = new File(build, "linux/work");
                }
            } else {
                File jarFolder = new File(decodedPath).getParentFile();
                if (jarFolder.getName().equals("lib")) {
                    processingRoot = jarFolder.getParentFile();
                } else if (Platform.isMacOS()) {
                    processingRoot = jarFolder;
                }
                if (processingRoot == null || !processingRoot.exists()) {
                    System.err.println("Could not find lib folder via " + jarFolder.getAbsolutePath() + ", switching to user.dir");
                    processingRoot = new File("");
                }
            }
        }
        return new File(processingRoot, name);
    }

    public static File getJavaHome() {
        if (Platform.isMacOS()) {
            File[] plugins = Platform.getContentFile("../PlugIns").listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.isDirectory() && name.endsWith(".jdk") && !name.startsWith(".");
                }
            });
            return new File(plugins[0], "Contents/Home/jre");
        }
        return Platform.getContentFile("java");
    }

    public static String getJavaPath() {
        String javaPath = "bin/java" + (Platform.isWindows() ? ".exe" : "");
        File javaFile = new File(Platform.getJavaHome(), javaPath);
        try {
            return javaFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            return javaFile.getAbsolutePath();
        }
    }

    public static boolean deleteFile(File file) throws IOException {
        FileUtils fu = FileUtils.getInstance();
        if (fu.hasTrash()) {
            fu.moveToTrash(new File[]{file});
            return true;
        }
        if (file.isDirectory()) {
            Util.removeDir(file);
            return true;
        }
        return file.delete();
    }

    public static void setenv(String variable, String value) {
        inst.setenv(variable, value);
    }

    public static String getenv(String variable) {
        return inst.getenv(variable);
    }

    public static int unsetenv(String variable) {
        return inst.unsetenv(variable);
    }

    public static int getSystemDPI() {
        return inst.getSystemDPI();
    }
}

