/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import processing.app.Messages;
import processing.app.Platform;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;

public class Util {
    public static int countLines(String what) {
        int count = 1;
        char[] cArray = what.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public static byte[] loadBytesRaw(File file) throws IOException {
        int bytesRead;
        int size = (int)file.length();
        FileInputStream input = new FileInputStream(file);
        byte[] buffer = new byte[size];
        int offset = 0;
        while ((bytesRead = input.read(buffer, offset, size - offset)) != -1) {
            offset += bytesRead;
            if (bytesRead == 0) break;
        }
        input.close();
        input = null;
        return buffer;
    }

    public static StringDict readSettings(File inputFile) {
        if (!inputFile.exists()) {
            Messages.loge(inputFile + " does not exist inside readSettings()");
            return null;
        }
        String[] lines = PApplet.loadStrings((File)inputFile);
        if (lines == null) {
            System.err.println("Could not read " + inputFile);
            return null;
        }
        return Util.readSettings(inputFile.toString(), lines);
    }

    public static StringDict readSettings(String filename, String[] lines) {
        StringDict settings = new StringDict();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int commentMarker = line.indexOf(35);
            if (commentMarker != -1) {
                line = line.substring(0, commentMarker);
            }
            if ((line = line.trim()).length() != 0) {
                int equals = line.indexOf(61);
                if (equals == -1) {
                    if (filename != null) {
                        System.err.println("Ignoring illegal line in " + filename);
                        System.err.println("  " + line);
                    }
                } else {
                    String attr = line.substring(0, equals).trim();
                    String valu = line.substring(equals + 1).trim();
                    settings.set(attr, valu);
                }
            }
            ++n2;
        }
        return settings;
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        int bytesRead;
        BufferedInputStream from = new BufferedInputStream(new FileInputStream(sourceFile));
        BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(targetFile));
        byte[] buffer = new byte[16384];
        while ((bytesRead = from.read(buffer)) != -1) {
            to.write(buffer, 0, bytesRead);
        }
        from.close();
        from = null;
        to.flush();
        to.close();
        to = null;
        targetFile.setLastModified(sourceFile.lastModified());
        targetFile.setExecutable(sourceFile.canExecute());
    }

    public static String loadFile(File file) throws IOException {
        String[] contents = PApplet.loadStrings((File)file);
        if (contents == null) {
            return null;
        }
        return PApplet.join((String[])contents, (String)"\n");
    }

    public static void saveFile(String text, File file) throws IOException {
        boolean result;
        String[] lines = text.split("\\r?\\n");
        File temp = File.createTempFile(file.getName(), null, file.getParentFile());
        try {
            File canon;
            file = canon = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new IOException("Could not resolve canonical representation of " + file.getAbsolutePath());
        }
        PrintWriter writer = PApplet.createWriter((File)temp);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            writer.println(line);
            ++n2;
        }
        boolean error = writer.checkError();
        writer.close();
        if (error) {
            throw new IOException("Error while trying to save " + file);
        }
        if (file.exists() && !(result = file.delete())) {
            throw new IOException("Could not remove old version of " + file.getAbsolutePath());
        }
        result = temp.renameTo(file);
        if (!result) {
            throw new IOException("Could not replace " + file.getAbsolutePath() + " with " + temp.getAbsolutePath());
        }
    }

    public static File createTempFolder(String prefix, String suffix, File directory) throws IOException {
        int fillChars = 3 - prefix.length();
        int i = 0;
        while (i < fillChars) {
            prefix = String.valueOf(prefix) + '_';
            ++i;
        }
        File folder = File.createTempFile(prefix, suffix, directory);
        folder.delete();
        folder.mkdirs();
        return folder;
    }

    public static void copyDir(File sourceDir, File targetDir) throws IOException {
        if (sourceDir.equals(targetDir)) {
            throw new IllegalArgumentException("source and target directories are identical");
        }
        targetDir.mkdirs();
        String[] files = sourceDir.list();
        int i = 0;
        while (i < files.length) {
            if (files[i].charAt(0) != '.') {
                File source = new File(sourceDir, files[i]);
                File target = new File(targetDir, files[i]);
                if (source.isDirectory()) {
                    Util.copyDir(source, target);
                    target.setLastModified(source.lastModified());
                } else {
                    Util.copyFile(source, target);
                }
            }
            ++i;
        }
    }

    public static void copyDirNative(File sourceDir, File targetDir) throws IOException {
        Process process = null;
        if (!Platform.isMacOS() && !Platform.isLinux()) {
            throw new RuntimeException("Not yet implemented on Windows");
        }
        process = Runtime.getRuntime().exec(new String[]{"cp", "-a", sourceDir.getAbsolutePath(), targetDir.getAbsolutePath()});
        try {
            int result = process.waitFor();
            if (result != 0) {
                throw new IOException("Error while copying (result " + result + ")");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean removeDir(File dir) {
        return Util.removeDir(dir, true);
    }

    public static boolean removeDir(File dir, boolean printErrorMessages) {
        boolean deleted;
        File[] files;
        if (!dir.exists()) {
            return true;
        }
        boolean result = true;
        if (!Files.isSymbolicLink(dir.toPath()) && (files = dir.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile()) {
                    boolean deleted2 = child.delete();
                    if (!deleted2 && printErrorMessages) {
                        System.err.println("Could not delete " + child.getAbsolutePath());
                    }
                    result &= deleted2;
                } else if (child.isDirectory()) {
                    result &= Util.removeDir(child, printErrorMessages);
                }
                ++n2;
            }
        }
        if (!(deleted = dir.delete()) && printErrorMessages) {
            System.err.println("Could not delete " + dir.getAbsolutePath());
        }
        return result &= deleted;
    }

    public static long calcSize(File file) {
        return file.isFile() ? file.length() : Util.calcFolderSize(file);
    }

    public static long calcFolderSize(File folder) {
        int size = 0;
        String[] files = folder.list();
        if (files == null) {
            return -1L;
        }
        int i = 0;
        while (i < files.length) {
            if (!(files[i].equals(".") || files[i].equals("..") || files[i].equals(".DS_Store"))) {
                File fella = new File(folder, files[i]);
                size = fella.isDirectory() ? (int)((long)size + Util.calcFolderSize(fella)) : (size += (int)fella.length());
            }
            ++i;
        }
        return size;
    }

    public static String[] listFiles(File folder, boolean relative) {
        return Util.listFiles(folder, relative, null);
    }

    public static String[] listFiles(File folder, boolean relative, String extension) {
        if (extension != null && !extension.startsWith(".")) {
            extension = "." + extension;
        }
        StringList list = new StringList();
        Util.listFilesImpl(folder, relative, extension, list);
        if (relative) {
            String[] outgoing = new String[list.size()];
            int prefixLength = folder.getAbsolutePath().length() + 1;
            int i = 0;
            while (i < outgoing.length) {
                outgoing[i] = list.get(i).substring(prefixLength);
                ++i;
            }
            return outgoing;
        }
        return list.array();
    }

    static void listFilesImpl(File folder, boolean relative, String extension, StringList list) {
        File[] items = folder.listFiles();
        if (items != null) {
            File[] fileArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                File item = fileArray[n2];
                String name = item.getName();
                if (name.charAt(0) != '.') {
                    if (item.isDirectory()) {
                        Util.listFilesImpl(item, relative, extension, list);
                    } else if (extension == null || name.endsWith(extension)) {
                        list.append(item.getAbsolutePath());
                    }
                }
                ++n2;
            }
        }
    }

    public static File[] listJarFiles(File folder) {
        return folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".") && (name.toLowerCase().endsWith(".jar") || name.toLowerCase().endsWith(".zip"));
            }
        });
    }

    public static String contentsToClassPath(File folder) {
        if (folder == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String sep = System.getProperty("path.separator");
        try {
            String path = folder.getCanonicalPath();
            if (!path.endsWith(File.separator)) {
                path = String.valueOf(path) + File.separator;
            }
            String[] list = folder.list();
            int i = 0;
            while (i < list.length) {
                if (!list[i].startsWith(".") && (list[i].toLowerCase().endsWith(".jar") || list[i].toLowerCase().endsWith(".zip"))) {
                    sb.append(sep);
                    sb.append(path);
                    sb.append(list[i]);
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static StringList packageListFromClassPath(String path) {
        StringList list = new StringList();
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        int i = 0;
        while (i < pieces.length) {
            if (pieces[i].length() != 0) {
                if (pieces[i].toLowerCase().endsWith(".jar") || pieces[i].toLowerCase().endsWith(".zip")) {
                    Util.packageListFromZip(pieces[i], list);
                } else {
                    File dir = new File(pieces[i]);
                    if (dir.exists() && dir.isDirectory()) {
                        Util.packageListFromFolder(dir, null, list);
                    }
                }
            }
            ++i;
        }
        StringList outgoing = new StringList(list.size());
        for (String item : list) {
            outgoing.append(item.replace('/', '.'));
        }
        return outgoing;
    }

    private static void packageListFromZip(String filename, StringList list) {
        try {
            ZipFile file = new ZipFile(filename);
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                int slash;
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class") || name.startsWith("META-INF/") || (slash = name.lastIndexOf(47)) == -1) continue;
                String packageName = name.substring(0, slash);
                list.appendUnique(packageName);
            }
            file.close();
        }
        catch (IOException e) {
            System.err.println("Ignoring " + filename + " (" + e.getMessage() + ")");
        }
    }

    private static void packageListFromFolder(File dir, String sofar, StringList list) {
        boolean foundClass = false;
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            if (!files[i].equals(".") && !files[i].equals("..")) {
                File sub = new File(dir, files[i]);
                if (sub.isDirectory()) {
                    String nowfar = sofar == null ? files[i] : String.valueOf(sofar) + "." + files[i];
                    Util.packageListFromFolder(sub, nowfar, list);
                } else if (!foundClass && files[i].endsWith(".class")) {
                    list.appendUnique(sofar);
                    foundClass = true;
                }
            }
            ++i;
        }
    }

    public static void unzip(File zipFile, File dest) {
        try {
            FileInputStream fis = new FileInputStream(zipFile);
            CheckedInputStream checksum = new CheckedInputStream(fis, new Adler32());
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(checksum));
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (name.startsWith("__MACOSX")) continue;
                File currentFile = new File(dest, name);
                if (entry.isDirectory()) {
                    currentFile.mkdirs();
                    continue;
                }
                File parentDir = currentFile.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                currentFile.createNewFile();
                Util.unzipEntry(zis, currentFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void unzipEntry(ZipInputStream zin, File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        byte[] b = new byte[512];
        int len = 0;
        while ((len = zin.read(b)) != -1) {
            out.write(b, 0, len);
        }
        out.flush();
        out.close();
    }

    public static byte[] gzipEncode(byte[] what) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream output = new GZIPOutputStream(baos);
        PApplet.saveStream((OutputStream)output, (InputStream)new ByteArrayInputStream(what));
        output.close();
        return baos.toByteArray();
    }

    public static final boolean containsNonASCII(String what) {
        char[] cArray = what.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < ' ' || c > '\u007f') {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

