/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import processing.app.Base;
import processing.app.Language;
import processing.app.Platform;
import processing.app.Util;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.StatusPanel;
import processing.app.contrib.ToolContribution;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;

public class AvailableContribution
extends Contribution {
    protected final ContributionType type;
    protected final String link;

    public AvailableContribution(ContributionType type, StringDict params) {
        String maxRev;
        String minRev;
        this.type = type;
        this.link = params.get("download");
        this.categories = AvailableContribution.parseCategories(params);
        this.imports = AvailableContribution.parseImports(params);
        this.name = params.get("name");
        this.authors = params.get("authors");
        this.url = params.get("url");
        this.sentence = params.get("sentence");
        this.paragraph = params.get("paragraph");
        String versionStr = params.get("version");
        if (versionStr != null) {
            this.version = PApplet.parseInt((String)versionStr, (int)0);
        }
        this.setPrettyVersion(params.get("prettyVersion"));
        String lastUpdatedStr = params.get("lastUpdated");
        if (lastUpdatedStr != null) {
            try {
                this.lastUpdated = Long.parseLong(lastUpdatedStr);
            }
            catch (NumberFormatException numberFormatException) {
                this.lastUpdated = 0L;
            }
        }
        if ((minRev = params.get("minRevision")) != null) {
            this.minRevision = PApplet.parseInt((String)minRev, (int)0);
        }
        if ((maxRev = params.get("maxRevision")) != null) {
            this.maxRevision = PApplet.parseInt((String)maxRev, (int)0);
        }
    }

    public LocalContribution install(Base base, File contribArchive, boolean confirmReplace, StatusPanel status) {
        File tempFolder = null;
        try {
            tempFolder = this.type.createTempFolder();
        }
        catch (IOException iOException) {
            if (status != null) {
                status.setErrorMessage(Language.text("contrib.errors.temporary_directory"));
            }
            return null;
        }
        Util.unzip(contribArchive, tempFolder);
        File contribFolder = null;
        LocalContribution installedContrib = null;
        contribFolder = this.type.findCandidate(tempFolder);
        if (contribFolder == null) {
            if (status != null) {
                status.setErrorMessage(Language.interpolate("contrib.errors.no_contribution_found", new Object[]{this.type}));
            }
        } else {
            File propFile = new File(contribFolder, (Object)((Object)this.type) + ".properties");
            if (!propFile.exists()) {
                status.setErrorMessage("This contribution is missing " + propFile.getName() + ", please contact the author for a fix.");
            } else if (this.writePropertiesFile(propFile)) {
                LocalContribution newContrib = this.type.load(base, contribFolder);
                File newContribFolder = newContrib.getFolder();
                installedContrib = newContrib.copyAndLoad(base, confirmReplace, status);
                if (newContrib.getType() == ContributionType.MODE) {
                    ((ModeContribution)newContrib).clearClassLoader(base);
                } else if (newContrib.getType() == ContributionType.TOOL) {
                    ((ToolContribution)newContrib).clearClassLoader();
                }
                newContrib = null;
                System.gc();
                if (Platform.isWindows()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                Util.removeDir(newContribFolder, false);
            } else if (status != null) {
                status.setErrorMessage(Language.text("contrib.errors.overwriting_properties"));
            }
        }
        if (tempFolder.exists()) {
            Util.removeDir(tempFolder, false);
        }
        return installedContrib;
    }

    @Override
    public boolean isInstalled() {
        return false;
    }

    @Override
    public ContributionType getType() {
        return this.type;
    }

    public boolean writePropertiesFile(File propFile) {
        try {
            int maxRev;
            int minRev;
            long lastUpdated;
            int version;
            String paragraph;
            String sentence;
            String url;
            StringList categoryList;
            StringDict properties = Util.readSettings(propFile);
            String name = properties.get("name");
            if (name == null || name.isEmpty()) {
                name = this.getName();
            }
            String category = (categoryList = AvailableContribution.parseCategories(properties)).size() == 1 && categoryList.get(0).equals("Unknown") ? this.getCategoryStr() : categoryList.join(",");
            StringList importsList = AvailableContribution.parseImports(properties);
            String authors = properties.get("authors");
            if (authors == null || authors.isEmpty()) {
                authors = this.getAuthorList();
            }
            if ((url = properties.get("url")) == null || url.isEmpty()) {
                url = this.getUrl();
            }
            if ((sentence = properties.get("sentence")) == null || sentence.isEmpty()) {
                sentence = this.getSentence();
            }
            if ((paragraph = properties.get("paragraph")) == null || paragraph.isEmpty()) {
                paragraph = this.getParagraph();
            }
            try {
                version = Integer.parseInt(properties.get("version"));
            }
            catch (NumberFormatException numberFormatException) {
                version = this.getVersion();
                System.err.println("The version number for \u201c" + name + "\u201d is not a number.");
                System.err.println("Please contact the author to fix it according to the guidelines.");
            }
            String prettyVersion = properties.get("prettyVersion");
            if (prettyVersion != null && prettyVersion.isEmpty()) {
                prettyVersion = null;
            }
            String compatibleContribsList = null;
            if (this.getType() == ContributionType.EXAMPLES) {
                compatibleContribsList = properties.get("modes");
            }
            try {
                lastUpdated = Long.parseLong(properties.get("lastUpdated"));
            }
            catch (NumberFormatException numberFormatException) {
                lastUpdated = this.getLastUpdated();
            }
            try {
                minRev = Integer.parseInt(properties.get("minRevision"));
            }
            catch (NumberFormatException numberFormatException) {
                minRev = this.getMinRevision();
            }
            try {
                maxRev = Integer.parseInt(properties.get("maxRevision"));
            }
            catch (NumberFormatException numberFormatException) {
                maxRev = this.getMaxRevision();
            }
            if (propFile.delete() && propFile.createNewFile() && propFile.setWritable(true)) {
                PrintWriter writer = PApplet.createWriter((File)propFile);
                writer.println("name=" + name);
                writer.println("category=" + category);
                writer.println("authors=" + authors);
                writer.println("url=" + url);
                writer.println("sentence=" + sentence);
                writer.println("paragraph=" + paragraph);
                writer.println("version=" + version);
                if (prettyVersion != null) {
                    writer.println("prettyVersion=" + prettyVersion);
                }
                writer.println("lastUpdated=" + lastUpdated);
                writer.println("minRevision=" + minRev);
                writer.println("maxRevision=" + maxRev);
                if ((this.getType() == ContributionType.LIBRARY || this.getType() == ContributionType.MODE) && importsList != null) {
                    writer.println("imports=" + importsList.join(","));
                }
                if (this.getType() == ContributionType.EXAMPLES && compatibleContribsList != null) {
                    writer.println("modes=" + compatibleContribsList);
                }
                writer.flush();
                writer.close();
            }
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

