/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JProgressBar;
import processing.app.contrib.ContribProgressMonitor;

abstract class ContribProgressBar
extends ContribProgressMonitor {
    JProgressBar progressBar;

    public ContribProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    @Override
    public void startTask(String name, int maxValue) {
        this.finished = false;
        this.progressBar.setString(name);
        this.progressBar.setIndeterminate(maxValue == -1);
        this.progressBar.setMaximum(maxValue);
    }

    @Override
    public void setProgress(int value) {
        super.setProgress(value);
        this.progressBar.setValue(value);
    }

    @Override
    public final void finished() {
        super.finished();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ContribProgressBar.this.finishedAction();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            cause.printStackTrace();
        }
    }

    public abstract void finishedAction();

    @Override
    public final void cancel() {
        super.cancel();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ContribProgressBar.this.cancelAction();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            cause.printStackTrace();
        }
    }

    public void cancelAction() {
    }
}

