/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import processing.app.Base;
import processing.app.Language;
import processing.app.Library;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionType;
import processing.app.contrib.DetailPanel;
import processing.app.contrib.ExamplesContribution;
import processing.app.contrib.ListPanel;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.StatusPanel;
import processing.app.contrib.ToolContribution;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;

public class ContributionTab
extends JPanel {
    static final String ANY_CATEGORY = Language.text("contrib.all");
    static final int FILTER_WIDTH = Toolkit.zoom(180);
    ContributionType contribType;
    ManagerFrame contribDialog;
    Contribution.Filter filter;
    JComboBox<String> categoryChooser;
    ListPanel contributionListPanel;
    StatusPanel statusPanel;
    FilterField filterField;
    JLabel categoryLabel;
    JLabel loaderLabel;
    JPanel errorPanel;
    JTextPane errorMessage;
    JButton tryAgainButton;
    JButton closeButton;
    Editor editor;
    String category;
    ContributionListing contribListing;
    JProgressBar progressBar;

    public ContributionTab() {
    }

    public ContributionTab(ManagerFrame dialog, ContributionType type) {
        this.contribDialog = dialog;
        this.contribType = type;
        this.filter = contrib -> contrib.getType() == this.contribType;
        this.contribListing = ContributionListing.getInstance();
        this.statusPanel = new StatusPanel(this, 650);
        this.contributionListPanel = new ListPanel(this, this.filter, false, new ListPanel.ContributionColumn[0]);
        this.contribListing.addListener(this.contributionListPanel);
    }

    public void showFrame(Editor editor, boolean error, boolean loading) {
        this.editor = editor;
        this.setLayout(error, loading);
        this.contributionListPanel.setVisible(!loading);
        this.loaderLabel.setVisible(loading);
        this.errorPanel.setVisible(error);
        this.validate();
        this.repaint();
    }

    protected void setLayout(boolean activateErrorPanel, boolean isLoading) {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setVisible(false);
            this.createComponents();
            this.buildErrorPanel();
            this.loaderLabel = new JLabel(Toolkit.getLibIcon("manager/loader.gif"));
            this.loaderLabel.setOpaque(false);
            this.loaderLabel.setBackground(Color.WHITE);
        }
        int scrollBarWidth = this.contributionListPanel.scrollPane.getVerticalScrollBar().getPreferredSize().width;
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGap(ManagerFrame.STATUS_WIDTH).addComponent(this.filterField, FILTER_WIDTH, FILTER_WIDTH, FILTER_WIDTH).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.categoryChooser, ManagerFrame.AUTHOR_WIDTH, ManagerFrame.AUTHOR_WIDTH, ManagerFrame.AUTHOR_WIDTH).addGap(scrollBarWidth)).addComponent(this.loaderLabel).addComponent(this.contributionListPanel).addComponent(this.errorPanel).addComponent(this.statusPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.categoryChooser).addComponent(this.filterField)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.loaderLabel).addComponent(this.contributionListPanel)).addComponent(this.errorPanel).addComponent(this.statusPanel, -2, -1, -2));
        layout.linkSize(1, this.categoryChooser, this.filterField);
        layout.setHonorsVisibility(this.contributionListPanel, false);
        layout.setHonorsVisibility(this.categoryChooser, false);
        this.setBackground(Color.WHITE);
        this.setBorder(null);
    }

    private void createComponents() {
        this.categoryLabel = new JLabel(Language.text("contrib.category"));
        this.categoryChooser = new JComboBox();
        this.categoryChooser.setMaximumRowCount(20);
        this.categoryChooser.setFont(ManagerFrame.NORMAL_PLAIN);
        this.updateCategoryChooser();
        this.categoryChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ContributionTab.this.category = (String)ContributionTab.this.categoryChooser.getSelectedItem();
                if (ManagerFrame.ANY_CATEGORY.equals(ContributionTab.this.category)) {
                    ContributionTab.this.category = null;
                }
                ContributionTab.this.filterLibraries(ContributionTab.this.category, ContributionTab.this.filterField.filters);
                ContributionTab.this.contributionListPanel.updateColors();
            }
        });
        this.filterField = new FilterField();
    }

    protected void buildErrorPanel() {
        this.errorPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.errorPanel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.errorPanel.setLayout(layout);
        this.errorMessage = new JTextPane();
        this.errorMessage.setEditable(false);
        this.errorMessage.setContentType("text/html");
        this.errorMessage.setText("<html><body><center>Could not connect to the Processing server.<br>Contributions cannot be installed or updated without an Internet connection.<br>Please verify your network connection again, then try connecting again.</center></body></html>");
        DetailPanel.setTextStyle(this.errorMessage, "1em");
        Dimension dim = new Dimension(550, 60);
        this.errorMessage.setMaximumSize(dim);
        this.errorMessage.setMinimumSize(dim);
        this.errorMessage.setOpaque(false);
        this.closeButton = Toolkit.createIconButton("manager/close");
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributionTab.this.contribDialog.makeAndShowTab(false, false);
            }
        });
        this.tryAgainButton = new JButton("Try Again");
        this.tryAgainButton.setFont(ManagerFrame.NORMAL_PLAIN);
        this.tryAgainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributionTab.this.contribDialog.makeAndShowTab(false, true);
                ContributionTab.this.contribDialog.downloadAndUpdateContributionListing(ContributionTab.this.editor.getBase());
            }
        });
        layout.setHorizontalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.errorMessage).addComponent(this.tryAgainButton, StatusPanel.BUTTON_WIDTH, StatusPanel.BUTTON_WIDTH, StatusPanel.BUTTON_WIDTH)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.closeButton));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.errorMessage).addComponent(this.closeButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tryAgainButton));
        this.errorPanel.setBackground(Color.PINK);
        this.errorPanel.validate();
    }

    protected void updateCategoryChooser() {
        if (this.categoryChooser != null) {
            this.categoryChooser.removeAllItems();
            ArrayList<String> categories = new ArrayList<String>(this.contribListing.getCategories(this.filter));
            Collections.sort(categories);
            boolean categoriesFound = false;
            this.categoryChooser.addItem(ManagerFrame.ANY_CATEGORY);
            for (String s : categories) {
                this.categoryChooser.addItem(s);
                if (s.equals("Unknown")) continue;
                categoriesFound = true;
            }
            this.categoryChooser.setVisible(categoriesFound);
        }
    }

    protected void filterLibraries(String category, List<String> filters) {
        this.contributionListPanel.filterLibraries(category, filters);
    }

    protected void updateContributionListing() {
        if (this.editor != null) {
            ArrayList<Contribution> contributions = new ArrayList<Contribution>();
            ArrayList<Library> libraries = new ArrayList<Library>(this.editor.getMode().contribLibraries);
            String sketchbookPath = Base.getSketchbookLibrariesFolder().getAbsolutePath();
            for (Library lib : this.editor.getMode().coreLibraries) {
                if (!lib.getLibraryPath().startsWith(sketchbookPath)) continue;
                libraries.add(lib);
            }
            contributions.addAll(libraries);
            Base base = this.editor.getBase();
            List<ToolContribution> tools = base.getToolContribs();
            contributions.addAll(tools);
            List<ModeContribution> modes = base.getModeContribs();
            contributions.addAll(modes);
            List<ExamplesContribution> examples = base.getExampleContribs();
            contributions.addAll(examples);
            this.contribListing.updateInstalledList(contributions);
        }
    }

    protected void setFilterText(String filter) {
        if (filter == null || filter.isEmpty()) {
            this.filterField.setText("");
        } else {
            this.filterField.setText(filter);
        }
        this.filterField.applyFilter();
    }

    public void updateStatusPanel(DetailPanel contributionPanel) {
        this.statusPanel.update(contributionPanel);
    }

    protected void updateAll() {
        Collection<DetailPanel> collection = this.contributionListPanel.panelByContribution.values();
        for (DetailPanel detailPanel : collection) {
            detailPanel.update();
        }
        this.contributionListPanel.model.fireTableDataChanged();
    }

    protected boolean hasUpdates() {
        return this.contributionListPanel.getRowCount() > 0;
    }

    public boolean filterHasFocus() {
        return this.filterField != null && this.filterField.hasFocus();
    }

    class FilterField
    extends JTextField {
        List<String> filters;

        public FilterField() {
            super("");
            final JLabel filterLabel = new JLabel("Filter");
            filterLabel.setFont(ManagerFrame.NORMAL_PLAIN);
            filterLabel.setOpaque(false);
            this.setFont(ManagerFrame.NORMAL_PLAIN);
            filterLabel.setIcon(Toolkit.getLibIconX("manager/search"));
            final JButton removeFilter = Toolkit.createIconButton("manager/remove");
            removeFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            removeFilter.setBorderPainted(false);
            removeFilter.setContentAreaFilled(false);
            removeFilter.setCursor(Cursor.getDefaultCursor());
            removeFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterField.this.setText("");
                    ((FilterField)FilterField.this).ContributionTab.this.filterField.requestFocusInWindow();
                }
            });
            this.setOpaque(false);
            GroupLayout fl = new GroupLayout(this);
            this.setLayout(fl);
            fl.setHorizontalGroup(fl.createSequentialGroup().addComponent(filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(removeFilter));
            fl.setVerticalGroup(fl.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(fl.createParallelGroup().addComponent(filterLabel).addComponent(removeFilter)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE));
            removeFilter.setVisible(false);
            this.filters = new ArrayList<String>();
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (FilterField.this.getText().isEmpty()) {
                        filterLabel.setVisible(true);
                    }
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    filterLabel.setVisible(false);
                }
            });
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    removeFilter.setVisible(!FilterField.this.getText().isEmpty());
                    FilterField.this.applyFilter();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    removeFilter.setVisible(!FilterField.this.getText().isEmpty());
                    FilterField.this.applyFilter();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    removeFilter.setVisible(!FilterField.this.getText().isEmpty());
                    FilterField.this.applyFilter();
                }
            });
        }

        public void applyFilter() {
            String filter = this.getText();
            filter = filter.toLowerCase();
            filter = filter.replaceAll("[^\\x30-\\x39^\\x61-\\x7a^\\x3a]", " ");
            this.filters = Arrays.asList(filter.split(" "));
            ContributionTab.this.filterLibraries(ContributionTab.this.category, this.filters);
            ContributionTab.this.contributionListPanel.updateColors();
        }
    }
}

