/*
 * Decompiled with CFR 0.152.
 */
package processing.app.exec;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import processing.app.exec.ProcessRegistry;
import processing.app.exec.ProcessResult;
import processing.app.exec.StreamPump;
import processing.core.PApplet;

public class ProcessHelper {
    private final String[] cmd;
    private final File dir;

    public ProcessHelper(String ... cmd) {
        this.cmd = cmd;
        this.dir = null;
    }

    public ProcessHelper(File dir, String ... cmd) {
        this.cmd = cmd;
        this.dir = dir;
    }

    public String toString() {
        return PApplet.join((String[])this.cmd, (String)" ");
    }

    public ProcessResult execute() throws InterruptedException, IOException {
        return this.execute(null);
    }

    public ProcessResult execute(String outgoing) throws InterruptedException, IOException {
        StringWriter outWriter = new StringWriter();
        StringWriter errWriter = new StringWriter();
        long startTime = System.currentTimeMillis();
        String prettyCommand = this.toString();
        Process process = this.dir == null ? Runtime.getRuntime().exec(this.cmd) : Runtime.getRuntime().exec(this.cmd, new String[0], this.dir);
        ProcessRegistry.watch(process);
        if (outgoing != null) {
            OutputStream os = process.getOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
            pw.println(outgoing);
            pw.flush();
            pw.close();
        }
        try {
            String title = prettyCommand;
            new StreamPump(process.getInputStream(), "out: " + title).addTarget(outWriter).start();
            new StreamPump(process.getErrorStream(), "err: " + title).addTarget(errWriter).start();
            try {
                int result = process.waitFor();
                long time = System.currentTimeMillis() - startTime;
                ProcessResult processResult = new ProcessResult(prettyCommand, result, outWriter.toString(), errWriter.toString(), time);
                return processResult;
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted: " + prettyCommand);
                throw e;
            }
        }
        finally {
            process.destroy();
            ProcessRegistry.unwatch(process);
        }
    }

    public static boolean ffs(String ... cmd) {
        ProcessResult result;
        block3: {
            ProcessHelper helper = new ProcessHelper(cmd);
            result = helper.execute();
            if (!result.succeeded()) break block3;
            return true;
        }
        try {
            System.out.println(result.getStdout());
            System.err.println(result.getStderr());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

