/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.Util;
import processing.app.platform.DefaultPlatform;
import processing.app.platform.WindowsRegistry;
import processing.core.PApplet;

public class WindowsPlatform
extends DefaultPlatform {
    static final String APP_NAME = "Processing";
    static final String[] APP_EXTENSIONS = new String[]{".pde", ".pyde"};
    static final String REG_OPEN_COMMAND = String.valueOf(System.getProperty("user.dir").replace('/', '\\')) + "\\" + "Processing".toLowerCase() + ".exe \"%1\"";
    static final String REG_DOC = "Processing.Document";
    static WinLibC clib;
    private static int detected;

    static {
        detected = WindowsPlatform.detectSystemDPI();
    }

    @Override
    public void initBase(Base base) {
        super.initBase(base);
        this.checkAssociations();
        this.checkPath();
    }

    protected void checkAssociations() {
        try {
            if (Preferences.getBoolean("platform.auto_file_type_associations")) {
                String knownCommand = WindowsRegistry.getStringValue(WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER, "Software\\Classes\\Processing.Document\\shell\\open\\command", "");
                if (knownCommand == null || !knownCommand.equals(REG_OPEN_COMMAND)) {
                    this.setAssociations();
                } else {
                    String[] stringArray = APP_EXTENSIONS;
                    int n = APP_EXTENSIONS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String extension = stringArray[n2];
                        if (!WindowsRegistry.valueExists(WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER, "Software\\Classes", extension)) {
                            this.setAssociations();
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setAssociations() throws UnsupportedEncodingException {
        String[] stringArray = APP_EXTENSIONS;
        int n = APP_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (!this.registerExtension(extension)) {
                Messages.log("Could not associate " + extension + "files, " + "turning off auto-associate pref.");
                Preferences.setBoolean("platform.auto_file_type_associations", false);
            }
            ++n2;
        }
    }

    private boolean registerExtension(String extension) throws UnsupportedEncodingException {
        WindowsRegistry.REGISTRY_ROOT_KEY rootKey = WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER;
        return WindowsRegistry.createKey(rootKey, "Software\\Classes", extension) && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\" + extension, "", REG_DOC) && WindowsRegistry.createKey(rootKey, "Software\\Classes", REG_DOC) && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\Processing.Document", "", "Processing Source Code") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document", "shell") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document\\shell", "open") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document\\shell\\open", "command") && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\Processing.Document\\shell\\open\\command", "", REG_OPEN_COMMAND);
    }

    protected void checkPath() {
        String path = System.getProperty("java.library.path");
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        String[] legit = new String[pieces.length];
        int legitCount = 0;
        String[] stringArray = pieces;
        int n = pieces.length;
        int n2 = 0;
        while (n2 < n) {
            File directory;
            String item = stringArray[n2];
            if (item.startsWith("\"")) {
                item = item.substring(1);
            }
            if (item.endsWith("\"")) {
                item = item.substring(0, item.length() - 1);
            }
            if (item.endsWith(File.separator)) {
                item = item.substring(0, item.length() - File.separator.length());
            }
            if ((directory = new File(item)).exists() && item.trim().length() != 0) {
                legit[legitCount++] = item;
            }
            ++n2;
        }
        String newPath = PApplet.join((String[])(legit = PApplet.subset((String[])legit, (int)0, (int)legitCount)), (String)File.pathSeparator);
        if (!newPath.equals(path)) {
            System.setProperty("java.library.path", newPath);
        }
    }

    @Override
    public File getSettingsFolder() throws Exception {
        try {
            File settingsFolder;
            File settingsFolder2;
            String appDataRoaming = WindowsPlatform.getAppDataPath();
            if (appDataRoaming != null && ((settingsFolder2 = new File(appDataRoaming, APP_NAME)).exists() || settingsFolder2.mkdirs())) {
                return settingsFolder2;
            }
            String appDataLocal = WindowsPlatform.getLocalAppDataPath();
            if (appDataLocal != null && ((settingsFolder = new File(appDataLocal, APP_NAME)).exists() || settingsFolder.mkdirs())) {
                return settingsFolder;
            }
            if (appDataRoaming == null && appDataLocal == null) {
                throw new IOException("Could not get the AppData folder");
            }
            throw new IOException("Permissions error: make sure that " + appDataRoaming + " or " + appDataLocal + " is writable.");
        }
        catch (UnsatisfiedLinkError ule) {
            String path = new File("lib").getCanonicalPath();
            String msg = Util.containsNonASCII(path) ? "Please move Processing to a location with only\nASCII characters in the path and try again.\nhttps://github.com/processing/processing/issues/3543" : "Could not find JNA support files, please reinstall Processing.";
            Messages.showError("Windows JNA Problem", msg, ule);
            return null;
        }
    }

    private static String getAppDataPath() throws Exception {
        return Shell32Util.getSpecialFolderPath((int)26, (boolean)true);
    }

    private static String getLocalAppDataPath() throws Exception {
        return Shell32Util.getSpecialFolderPath((int)28, (boolean)true);
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        String documentsPath = WindowsPlatform.getDocumentsPath();
        if (documentsPath != null) {
            return new File(documentsPath, APP_NAME);
        }
        return null;
    }

    private static String getDocumentsPath() throws Exception {
        return Shell32Util.getSpecialFolderPath((int)5, (boolean)true);
    }

    static WinLibC getLibC() {
        if (clib == null) {
            try {
                clib = (WinLibC)Native.loadLibrary((String)"msvcrt", WinLibC.class);
            }
            catch (UnsatisfiedLinkError ule) {
                Messages.showTrace("JNA Error", "JNA could not be loaded. Please report here:\nhttp://github.com/processing/processing/issues/new", ule, true);
            }
        }
        return clib;
    }

    @Override
    public void setenv(String variable, String value) {
        WindowsPlatform.getLibC()._putenv(String.valueOf(variable) + "=" + value);
    }

    @Override
    public String getenv(String variable) {
        return System.getenv(variable);
    }

    @Override
    public int unsetenv(String variable) {
        return WindowsPlatform.getLibC()._putenv(String.valueOf(variable) + "=");
    }

    @Override
    public int getSystemDPI() {
        if (detected == -1) {
            return super.getSystemDPI();
        }
        return detected;
    }

    public static int detectSystemDPI() {
        try {
            ExtUser32.INSTANCE.SetProcessDpiAwareness(1);
        }
        catch (Throwable throwable) {}
        try {
            ExtUser32.INSTANCE.SetThreadDpiAwarenessContext(ExtUser32.DPI_AWARENESS_CONTEXT_SYSTEM_AWARE);
        }
        catch (Throwable throwable) {}
        try {
            return ExtUser32.INSTANCE.GetDpiForSystem();
        }
        catch (Throwable throwable) {
            System.out.println("DPI detection failed, fallback to 96 dpi");
            return -1;
        }
    }

    static interface ExtUser32
    extends StdCallLibrary,
    User32 {
        public static final ExtUser32 INSTANCE = (ExtUser32)Native.loadLibrary((String)"user32", ExtUser32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
        public static final int DPI_AWARENESS_INVALID = -1;
        public static final int DPI_AWARENESS_UNAWARE = 0;
        public static final int DPI_AWARENESS_SYSTEM_AWARE = 1;
        public static final int DPI_AWARENESS_PER_MONITOR_AWARE = 2;
        public static final Pointer DPI_AWARENESS_CONTEXT_UNAWARE = new Pointer(-1L);
        public static final Pointer DPI_AWARENESS_CONTEXT_SYSTEM_AWARE = new Pointer(-2L);
        public static final Pointer DPI_AWARENESS_CONTEXT_PER_MONITOR_AWARE = new Pointer(-3L);

        public int GetDpiForSystem();

        public int SetProcessDpiAwareness(int var1);

        public Pointer SetThreadDpiAwarenessContext(Pointer var1);
    }

    public static interface WinLibC
    extends Library {
        public int _putenv(String var1);
    }
}

