/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.im.InputMethodRequests;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.syntax.Brackets;
import processing.app.syntax.HtmlSelection;
import processing.app.syntax.InputHandler;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TextAreaDefaults;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.Token;
import processing.app.syntax.TokenMarker;
import processing.app.syntax.TokenMarkerState;
import processing.app.syntax.im.InputMethodSupport;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public class JEditTextArea
extends JComponent {
    public static String LEFT_OF_SCROLLBAR = "los";
    public static final int leftHandGutter = 6;
    private InputMethodSupport inputMethodSupport;
    private TextAreaDefaults defaults;
    private Brackets bracketHelper = new Brackets();
    protected static String CENTER = "center";
    protected static String RIGHT = "right";
    protected static String BOTTOM = "bottom";
    protected Timer caretTimer;
    private static final boolean DISABLE_CARET = false;
    protected TextAreaPainter painter;
    protected JPopupMenu popup;
    protected EventListenerList eventListenerList;
    protected MutableCaretEvent caretEvent;
    protected boolean caretBlinks;
    protected boolean caretVisible;
    protected boolean blink;
    protected boolean editable = true;
    protected int firstLine;
    protected int visibleLines;
    protected int electricScroll;
    protected int horizontalOffset;
    protected JScrollBar vertical;
    protected JScrollBar horizontal;
    protected boolean scrollBarsInitialized;
    protected InputHandler inputHandler;
    protected SyntaxDocument document;
    protected DocumentHandler documentHandler;
    protected Segment lineSegment;
    protected int selectionStart;
    protected int selectionStartLine;
    protected int selectionEnd;
    protected int selectionEndLine;
    protected boolean biasLeft;
    protected int newSelectionStart;
    protected int newSelectionEnd;
    protected boolean selectWord;
    protected boolean selectLine;
    protected int selectionAncorStart;
    protected int selectionAncorEnd;
    protected int bracketPosition;
    protected int bracketLine;
    protected int magicCaret;
    protected boolean overwrite;

    public JEditTextArea(TextAreaDefaults defaults, InputHandler inputHandler) {
        this.defaults = defaults;
        this.enableEvents(8L);
        this.caretTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JEditTextArea.this.hasFocus()) {
                    JEditTextArea.this.blinkCaret();
                }
            }
        });
        this.caretTimer.setInitialDelay(500);
        this.caretTimer.start();
        this.painter = this.createPainter(defaults);
        this.documentHandler = new DocumentHandler();
        this.eventListenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.lineSegment = new Segment();
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.blink = true;
        this.setLayout(new ScrollLayout());
        this.add(CENTER, this.painter);
        this.vertical = new JScrollBar(1);
        this.add(RIGHT, this.vertical);
        this.horizontal = new JScrollBar(0);
        this.add(BOTTOM, this.horizontal);
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.painter.addComponentListener(new ComponentHandler());
        this.painter.addMouseListener(new MouseHandler());
        this.painter.addMouseMotionListener(new DragHandler());
        this.addFocusListener(new FocusHandler());
        this.setFocusTraversalKeysEnabled(false);
        this.setInputHandler(inputHandler);
        this.setDocument(defaults.document);
        this.caretVisible = defaults.caretVisible;
        this.caretBlinks = defaults.caretBlinks;
        this.electricScroll = defaults.electricScroll;
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (JEditTextArea.this.scrollBarsInitialized && e.getScrollType() == 0) {
                    boolean isHorizontal;
                    int scrollAmount = e.getUnitsToScroll();
                    boolean bl = isHorizontal = Platform.isMacOS() && e.isShiftDown();
                    if (isHorizontal) {
                        JEditTextArea.this.horizontal.setValue(JEditTextArea.this.horizontal.getValue() + scrollAmount);
                    } else {
                        JEditTextArea.this.vertical.setValue(JEditTextArea.this.vertical.getValue() + scrollAmount);
                    }
                }
            }
        });
    }

    protected TextAreaPainter createPainter(TextAreaDefaults defaults) {
        return new TextAreaPainter(this, defaults);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (Preferences.getBoolean("editor.input_method_support")) {
            if (this.inputMethodSupport == null) {
                this.inputMethodSupport = new InputMethodSupport(this);
            }
            return this.inputMethodSupport;
        }
        return null;
    }

    public int getScrollPosition() {
        return this.getVerticalScrollPosition();
    }

    public void setScrollPosition(int what) {
        this.setVerticalScrollPosition(what);
    }

    public int getVerticalScrollPosition() {
        return this.vertical.getValue();
    }

    public void setVerticalScrollPosition(int what) {
        this.vertical.setValue(what);
    }

    public int getHorizontalScrollPosition() {
        return this.horizontal.getValue();
    }

    public void setHorizontalScrollPosition(int what) {
        this.horizontal.setValue(what);
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public TextAreaDefaults getDefaults() {
        return this.defaults;
    }

    public final InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean caretBlinks) {
        this.caretBlinks = caretBlinks;
        if (!caretBlinks) {
            this.blink = false;
        }
        this.painter.invalidateSelectedLines();
    }

    public final boolean isCaretVisible() {
        return (!this.caretBlinks || this.blink) && this.caretVisible;
    }

    public void setCaretVisible(boolean caretVisible) {
        this.caretVisible = caretVisible;
        this.blink = true;
        this.painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.painter.invalidateSelectedLines();
        } else {
            this.blink = true;
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int electricScroll) {
        this.electricScroll = electricScroll;
    }

    public void updateScrollBars() {
        if (this.vertical != null && this.visibleLines != 0) {
            this.vertical.setValues(this.firstLine, this.visibleLines, 0, this.getLineCount());
            this.vertical.setUnitIncrement(2);
            this.vertical.setBlockIncrement(this.visibleLines);
        }
        if (this.horizontal != null && this.painter.getWidth() != 0) {
            int lineCount = this.getLineCount();
            int maxLineLength = 0;
            int i = 0;
            while (i < lineCount) {
                int lineLength = this.getLineLength(i);
                if (lineLength > maxLineLength) {
                    maxLineLength = lineLength;
                }
                ++i;
            }
            int charWidth = this.painter.getFontMetrics().charWidth('w');
            int width = maxLineLength * charWidth;
            int painterWidth = this.painter.getScrollWidth();
            if (this.horizontalOffset < 0) {
                this.horizontal.setValues(-this.horizontalOffset, painterWidth, -6, width);
            } else {
                this.horizontal.setValues(-6, painterWidth, -6, width);
            }
            this.horizontal.setUnitIncrement(charWidth);
            this.horizontal.setBlockIncrement(width / 2);
        }
    }

    public final int getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(int firstLine) {
        if (firstLine < 0 || firstLine > this.getLineCount()) {
            throw new IllegalArgumentException("First line out of range: " + firstLine + " [0, " + this.getLineCount() + "]");
        }
        if (firstLine == this.firstLine) {
            return;
        }
        this.firstLine = firstLine;
        if (firstLine != this.vertical.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
    }

    public final int getLastLine() {
        return this.getFirstLine() + this.getVisibleLines();
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int height = this.painter.getHeight();
        int lineHeight = this.painter.getFontMetrics().getHeight();
        this.visibleLines = height / lineHeight;
        this.updateScrollBars();
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int horizontalOffset) {
        if (horizontalOffset == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = horizontalOffset;
        if (horizontalOffset != this.horizontal.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
    }

    public boolean setOrigin(int firstLine, int horizontalOffset) {
        boolean changed = false;
        if (horizontalOffset != this.horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
            changed = true;
        }
        if (firstLine != this.firstLine) {
            this.firstLine = firstLine;
            changed = true;
        }
        if (changed) {
            this.updateScrollBars();
            this.painter.repaint();
        }
        return changed;
    }

    public boolean scrollToCaret() {
        int line = this.getCaretLine();
        int lineStart = this.getLineStartOffset(line);
        int offset = Math.max(0, Math.min(this.getLineLength(line) - 1, this.getCaretPosition() - lineStart));
        return this.scrollTo(line, offset);
    }

    public boolean scrollTo(int line, int offset) {
        if (this.visibleLines == 0) {
            this.setFirstLine(Math.max(0, line - this.electricScroll));
            return true;
        }
        int newFirstLine = this.firstLine;
        int newHorizontalOffset = this.horizontalOffset;
        if (line < this.firstLine + this.electricScroll) {
            newFirstLine = Math.max(0, line - this.electricScroll);
        } else if (line + this.electricScroll >= this.firstLine + this.visibleLines) {
            newFirstLine = line - this.visibleLines + this.electricScroll + 1;
            if (newFirstLine + this.visibleLines >= this.getLineCount()) {
                newFirstLine = this.getLineCount() - this.visibleLines;
            }
            if (newFirstLine < 0) {
                newFirstLine = 0;
            }
        }
        int x = this._offsetToX(line, offset);
        int width = this.painter.getFontMetrics().charWidth('w');
        if (x < 0) {
            newHorizontalOffset = Math.max(0, this.horizontalOffset - x + width + 5);
        } else if (x + width >= this.painter.getWidth()) {
            newHorizontalOffset = this.horizontalOffset + (this.painter.getWidth() - x) - width - 5;
        }
        return this.setOrigin(newFirstLine, newHorizontalOffset);
    }

    public int lineToY(int line) {
        FontMetrics fm = this.painter.getFontMetrics();
        return (line - this.firstLine) * fm.getHeight() - (fm.getLeading() + fm.getMaxDescent());
    }

    public int yToLine(int y) {
        FontMetrics fm = this.painter.getFontMetrics();
        int height = fm.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, y / height + this.firstLine));
    }

    public final int offsetToX(int line, int offset) {
        this.painter.currentLineTokens = null;
        return this._offsetToX(line, offset);
    }

    public int _offsetToX(int line, int offset) {
        Token tokens;
        TokenMarkerState tokenMarker = this.getTokenMarker();
        FontMetrics fm = this.painter.getFontMetrics();
        this.getLineText(line, this.lineSegment);
        int segmentOffset = this.lineSegment.offset;
        int x = this.horizontalOffset;
        if (tokenMarker == null) {
            this.lineSegment.count = offset;
            return x + Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
        }
        if (this.painter.currentLineIndex == line && this.painter.currentLineTokens != null) {
            tokens = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = line;
            tokens = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, line);
        }
        SyntaxStyle[] styles = this.painter.getStyles();
        byte id;
        while ((id = tokens.id) != 127) {
            fm = id == 0 ? this.painter.getFontMetrics() : this.painter.getFontMetrics(styles[id]);
            int length = tokens.length;
            if (offset + segmentOffset < this.lineSegment.offset + length) {
                this.lineSegment.count = offset - (this.lineSegment.offset - segmentOffset);
                return x + Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
            }
            this.lineSegment.count = length;
            x += Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
            this.lineSegment.offset += length;
            tokens = tokens.next;
        }
        return x;
    }

    public int xToOffset(int line, int x) {
        Token tokens;
        TokenMarkerState tokenMarker = this.getTokenMarker();
        FontMetrics fm = this.painter.getFontMetrics();
        this.getLineText(line, this.lineSegment);
        char[] segmentArray = this.lineSegment.array;
        int segmentOffset = this.lineSegment.offset;
        int segmentCount = this.lineSegment.count;
        int width = this.horizontalOffset;
        if (tokenMarker == null) {
            int i = 0;
            while (i < segmentCount) {
                char c = segmentArray[i + segmentOffset];
                int charWidth = c == '\t' ? (int)this.painter.nextTabStop(width, i) - width : fm.charWidth(c);
                if (this.painter.isBlockCaretEnabled() ? x - charWidth <= width : x - charWidth / 2 <= width) {
                    return i;
                }
                width += charWidth;
                ++i;
            }
            return segmentCount;
        }
        if (this.painter.currentLineIndex == line && this.painter.currentLineTokens != null) {
            tokens = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = line;
            tokens = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, line);
        }
        int offset = 0;
        SyntaxStyle[] styles = this.painter.getStyles();
        byte id;
        while ((id = tokens.id) != 127) {
            fm = id == 0 ? this.painter.getFontMetrics() : this.painter.getFontMetrics(styles[id]);
            int length = tokens.length;
            int i = 0;
            while (i < length) {
                if (segmentOffset + offset + i >= segmentArray.length) {
                    return segmentArray.length - segmentOffset - 1;
                }
                char c = segmentArray[segmentOffset + offset + i];
                int charWidth = c == '\t' ? (int)this.painter.nextTabStop(width, offset + i) - width : fm.charWidth(c);
                if (this.painter.isBlockCaretEnabled() ? x - charWidth <= width : x - charWidth / 2 <= width) {
                    return offset + i;
                }
                width += charWidth;
                ++i;
            }
            offset += length;
            tokens = tokens.next;
        }
        return offset;
    }

    public int xyToOffset(int x, int y) {
        int line = this.yToLine(y);
        int start = this.getLineStartOffset(line);
        return start + this.xToOffset(line, x);
    }

    public final SyntaxDocument getDocument() {
        return this.document;
    }

    public void setDocument(SyntaxDocument document) {
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = document;
        document.addDocumentListener(this.documentHandler);
        this.bracketHelper.invalidate();
        this.select(0, 0);
        this.updateScrollBars();
        this.painter.repaint();
    }

    public void setDocument(SyntaxDocument document, int start, int stop, int scroll) {
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = document;
        document.addDocumentListener(this.documentHandler);
        this.bracketHelper.invalidate();
        this.select(start, stop);
        this.updateScrollBars();
        this.setVerticalScrollPosition(scroll);
        this.painter.repaint();
    }

    public final TokenMarkerState getTokenMarker() {
        return this.document.getTokenMarker();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        this.document.setTokenMarker(tokenMarker);
    }

    public final int getDocumentLength() {
        return this.document.getLength();
    }

    public final int getLineCount() {
        return this.document.getDefaultRootElement().getElementCount();
    }

    public final int getLineOfOffset(int offset) {
        return this.document.getDefaultRootElement().getElementIndex(offset);
    }

    public int getLineStartOffset(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        return lineElement == null ? -1 : lineElement.getStartOffset();
    }

    public int getLineStartNonWhiteSpaceOffset(int line) {
        int offset = this.getLineStartOffset(line);
        int length = this.getLineLength(line);
        String str = this.getText(offset, length);
        int i = 0;
        while (i < str.length()) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return offset + i;
            }
            ++i;
        }
        return offset + length;
    }

    public int getLineStopOffset(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        return lineElement == null ? -1 : lineElement.getEndOffset();
    }

    public int getLineStopNonWhiteSpaceOffset(int line) {
        int offset = this.getLineStopOffset(line);
        int length = this.getLineLength(line);
        String str = this.getText(offset - length - 1, length);
        int i = 0;
        while (i < length) {
            if (!Character.isWhitespace(str.charAt(length - i - 1))) {
                return offset - i;
            }
            ++i;
        }
        return offset - length;
    }

    public int getLineSelectionStopOffset(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        return lineElement == null ? -1 : Math.min(lineElement.getEndOffset(), this.getDocumentLength());
    }

    public int getLineLength(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        return lineElement == null ? -1 : lineElement.getEndOffset() - lineElement.getStartOffset() - 1;
    }

    public String getText() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            return null;
        }
    }

    public void setText(String text) {
        try {
            try {
                this.document.beginCompoundEdit();
                this.document.remove(0, this.document.getLength());
                this.document.insertString(0, text, null);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
                this.document.endCompoundEdit();
            }
        }
        finally {
            this.document.endCompoundEdit();
        }
    }

    public final String getText(int start, int len) {
        try {
            return this.document.getText(start, len);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            return null;
        }
    }

    public final void getText(int start, int len, Segment segment) {
        try {
            this.document.getText(start, len, segment);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            System.err.format("Bad Location: %d for start %d and length %d", bl.offsetRequested(), start, len);
            segment.count = 0;
            segment.offset = 0;
        }
    }

    public final String getLineText(int lineIndex) {
        int start = this.getLineStartOffset(lineIndex);
        return this.getText(start, this.getLineStopOffset(lineIndex) - start - 1);
    }

    public final void getLineText(int lineIndex, Segment segment) {
        int start = this.getLineStartOffset(lineIndex);
        this.getText(start, this.getLineStopOffset(lineIndex) - start - 1, segment);
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionStart(int line) {
        if (line == this.selectionStartLine) {
            return this.selectionStart;
        }
        return this.getLineStartOffset(line);
    }

    public final int getSelectionStartLine() {
        return this.selectionStartLine;
    }

    public final void setSelectionStart(int selectionStart) {
        this.select(selectionStart, this.selectionEnd);
    }

    public final int getSelectionStop() {
        return this.selectionEnd;
    }

    public int getSelectionStop(int line) {
        if (line == this.selectionEndLine) {
            return this.selectionEnd;
        }
        return this.getLineStopOffset(line) - 1;
    }

    public final int getSelectionStopLine() {
        return this.selectionEndLine;
    }

    public final void setSelectionEnd(int selectionEnd) {
        this.select(this.selectionStart, selectionEnd);
    }

    public final boolean isSelectionActive() {
        return this.selectionStart != this.selectionEnd;
    }

    public final int getCaretPosition() {
        return this.biasLeft ? this.selectionStart : this.selectionEnd;
    }

    public final int getCaretLine() {
        return this.biasLeft ? this.selectionStartLine : this.selectionEndLine;
    }

    public final int getMarkPosition() {
        return this.biasLeft ? this.selectionEnd : this.selectionStart;
    }

    public final int getMarkLine() {
        return this.biasLeft ? this.selectionEndLine : this.selectionStartLine;
    }

    public final void setCaretPosition(int caret) {
        this.select(caret, caret);
    }

    public final void selectAll() {
        this.select(0, this.getDocumentLength());
    }

    public final void selectNone() {
        this.select(this.getCaretPosition(), this.getCaretPosition());
    }

    public void select(int start, int end2) {
        boolean newBias;
        int newEnd;
        int newStart;
        if (start <= end2) {
            newStart = start;
            newEnd = end2;
            newBias = false;
        } else {
            newStart = end2;
            newEnd = start;
            newBias = true;
        }
        if ((newStart < 0 || newEnd > this.getDocumentLength()) && start != end2) {
            throw new IllegalArgumentException("Bounds out of range: " + newStart + "," + newEnd + " [" + this.getDocumentLength() + "]");
        }
        if (newStart != this.selectionStart || newEnd != this.selectionEnd || newBias != this.biasLeft) {
            int newStartLine = this.getLineOfOffset(newStart);
            int newEndLine = this.getLineOfOffset(newEnd);
            if (this.painter.isBracketHighlightEnabled()) {
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
                this.updateBracketHighlight(end2);
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
            }
            this.painter.invalidateLineRange(this.selectionStartLine, this.selectionEndLine);
            this.painter.invalidateLineRange(newStartLine, newEndLine);
            this.document.addUndoableEdit(new CaretUndo(this.selectionStart, this.selectionEnd));
            this.selectionStart = newStart;
            this.selectionEnd = newEnd;
            this.selectionStartLine = newStartLine;
            this.selectionEndLine = newEndLine;
            this.biasLeft = newBias;
            this.fireCaretEvent();
        }
        this.blink = true;
        this.caretTimer.restart();
        this.magicCaret = -1;
        this.scrollToCaret();
    }

    private CharacterKinds CharacterKind(char ch, String noWordSep) {
        if (Character.isLetterOrDigit(ch) || ch == '_' || noWordSep.indexOf(ch) != -1) {
            return CharacterKinds.Word;
        }
        if (Character.isWhitespace(ch)) {
            return CharacterKinds.Whitespace;
        }
        return CharacterKinds.Other;
    }

    protected void setNewSelectionWord(int line, int offset) {
        if (this.getLineLength(line) == 0) {
            this.newSelectionEnd = this.newSelectionStart = this.getLineStartOffset(line);
            return;
        }
        String noWordSep = (String)this.document.getProperty("noWordSep");
        if (noWordSep == null) {
            noWordSep = "";
        }
        String lineText = this.getLineText(line);
        int wordStart = 0;
        int wordEnd = lineText.length();
        int charPos = PApplet.constrain((int)(offset - 1), (int)0, (int)(lineText.length() - 1));
        char ch = lineText.charAt(charPos);
        CharacterKinds thisWord = this.CharacterKind(ch, noWordSep);
        int i = offset - 1;
        while (i >= 0) {
            ch = lineText.charAt(i);
            if (this.CharacterKind(ch, noWordSep) != thisWord) {
                wordStart = i + 1;
                break;
            }
            --i;
        }
        i = offset;
        while (i < lineText.length()) {
            ch = lineText.charAt(i);
            if (this.CharacterKind(ch, noWordSep) != thisWord) {
                wordEnd = i;
                break;
            }
            ++i;
        }
        int lineStart = this.getLineStartOffset(line);
        this.newSelectionStart = lineStart + wordStart;
        this.newSelectionEnd = lineStart + wordEnd;
    }

    public final String getSelectedText() {
        if (this.selectionStart == this.selectionEnd) {
            return null;
        }
        return this.getText(this.selectionStart, this.selectionEnd - this.selectionStart);
    }

    public void setSelectedText(String selectedText) {
        this.setSelectedText(selectedText, false);
    }

    public void setSelectedText(String selectedText, boolean recordCompoundEdit) {
        if (!this.editable) {
            throw new InternalError("Text component read only");
        }
        if (recordCompoundEdit) {
            this.document.beginCompoundEdit();
        }
        try {
            try {
                this.document.remove(this.selectionStart, this.selectionEnd - this.selectionStart);
                if (selectedText != null) {
                    this.document.insertString(this.selectionStart, selectedText, null);
                }
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
                throw new InternalError("Cannot replace selection");
            }
        }
        finally {
            if (recordCompoundEdit) {
                this.document.endCompoundEdit();
            }
        }
        this.setCaretPosition(this.selectionEnd);
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean editable) {
        this.editable = editable;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public final int getMagicCaretPosition() {
        return this.magicCaret;
    }

    public final void setMagicCaretPosition(int magicCaret) {
        this.magicCaret = magicCaret;
    }

    public void overwriteSetSelectedText(String str) {
        if (!this.overwrite || this.selectionStart != this.selectionEnd) {
            boolean isSelectAndReplaceOp = this.selectionStart != this.selectionEnd;
            this.setSelectedText(str, isSelectAndReplaceOp);
            return;
        }
        int caret = this.getCaretPosition();
        int caretLineEnd = this.getLineStopOffset(this.getCaretLine());
        if (caretLineEnd - caret <= str.length()) {
            this.setSelectedText(str, false);
            return;
        }
        try {
            this.document.remove(caret, str.length());
            this.document.insertString(caret, str, null);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean overwrite2) {
        this.overwrite = overwrite2;
        this.painter.invalidateSelectedLines();
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public final void addCaretListener(CaretListener listener) {
        this.eventListenerList.add(CaretListener.class, listener);
    }

    public final void removeCaretListener(CaretListener listener) {
        this.eventListenerList.remove(CaretListener.class, listener);
    }

    public void cut() {
        if (this.editable) {
            this.copy();
            this.setSelectedText("");
        }
    }

    public void copy() {
        if (this.selectionStart != this.selectionEnd) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            String selection = this.getSelectedText();
            if (selection != null) {
                int repeatCount = this.inputHandler.getRepeatCount();
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < repeatCount) {
                    sb.append(selection);
                    ++i;
                }
                clipboard.setContents(new StringSelection(sb.toString()), null);
            }
        }
    }

    public void copyAsHTML() {
        HtmlSelection formatted = new HtmlSelection("<html><body><pre>\n" + this.getTextAsHtml(null) + "\n</pre></body></html>");
        Clipboard clipboard = Toolkit.getSystemClipboard();
        clipboard.setContents(formatted, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }

    public String getTextAsHtml(SyntaxDocument doc) {
        StringBuilder cf = new StringBuilder();
        int selStart = this.getSelectionStart();
        int selStop = this.getSelectionStop();
        int startLine = this.getSelectionStartLine();
        int stopLine = this.getSelectionStopLine();
        if (doc != null) {
            startLine = 0;
            stopLine = doc.getDefaultRootElement().getElementCount() - 1;
        } else if (selStart == selStop) {
            startLine = 0;
            stopLine = this.getLineCount() - 1;
        } else if (this.getLineStartOffset(stopLine) == selStop) {
            --stopLine;
        }
        if (doc == null) {
            doc = this.getDocument();
        }
        int i = startLine;
        while (i <= stopLine) {
            this.emitAsHTML(cf, i, doc);
            ++i;
        }
        return cf.toString();
    }

    private void emitAsHTML(StringBuilder cf, int line, SyntaxDocument doc) {
        Segment segment = new Segment();
        try {
            Element element = doc.getDefaultRootElement().getElement(line);
            int start = element.getStartOffset();
            int stop = element.getEndOffset();
            doc.getText(start, stop - start - 1, segment);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        char[] segmentArray = segment.array;
        int limit = segment.getEndIndex();
        int segmentOffset = segment.offset;
        int segmentCount = segment.count;
        TokenMarkerState tokenMarker = doc.getTokenMarker();
        if (tokenMarker == null) {
            int j = 0;
            while (j < segmentCount) {
                char c = segmentArray[j + segmentOffset];
                this.appendAsHTML(cf, c);
                ++j;
            }
        } else {
            Token tokens = tokenMarker.markTokens(segment, line);
            int offset = 0;
            SyntaxStyle[] styles = this.painter.getStyles();
            while (true) {
                byte id;
                if ((id = tokens.id) == 127) {
                    if (segmentOffset + offset < limit) {
                        this.appendAsHTML(cf, segmentArray[segmentOffset + offset]);
                    } else {
                        cf.append('\n');
                    }
                    return;
                }
                if (id != 0) {
                    cf.append("<span style=\"color: #");
                    cf.append(PApplet.hex((int)(styles[id].getColor().getRGB() & 0xFFFFFF), (int)6));
                    cf.append(";\">");
                    if (styles[id].isBold()) {
                        cf.append("<b>");
                    }
                }
                int length = tokens.length;
                int j = 0;
                while (j < length) {
                    char c = segmentArray[segmentOffset + offset + j];
                    if (offset == 0 && c == ' ') {
                        cf.append("&nbsp;");
                    } else {
                        this.appendAsHTML(cf, c);
                    }
                    if (j == length - 1 && id != 0 && styles[id].isBold()) {
                        cf.append("</b>");
                    }
                    if (j == length - 1 && id != 0) {
                        cf.append("</span>");
                    }
                    ++j;
                }
                offset += length;
                tokens = tokens.next;
            }
        }
    }

    private void appendAsHTML(StringBuilder buffer, char c) {
        if (c == '<') {
            buffer.append("&lt;");
        } else if (c == '>') {
            buffer.append("&gt;");
        } else if (c == '&') {
            buffer.append("&amp;");
        } else if (c == '\'') {
            buffer.append("&apos;");
        } else if (c == '\"') {
            buffer.append("&quot;");
        } else if (c > '\u007f') {
            buffer.append("&#" + c + ";");
        } else {
            buffer.append(c);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void paste() {
        block12: {
            if (this.editable) {
                clipboard = this.getToolkit().getSystemClipboard();
                try {
                    selection = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                    if (selection.contains("\r\n")) {
                        selection = selection.replaceAll("\r\n", "\n");
                    } else if (selection.contains("\r")) {
                        selection = selection.replace('\r', '\n');
                    }
                    if (selection.contains("\t")) {
                        tabSize = Preferences.getInteger("editor.tabs.size");
                        c = new char[tabSize];
                        Arrays.fill(c, ' ');
                        tabString = new String(c);
                        selection = selection.replaceAll("\t", tabString);
                    }
                    if ((selection = selection.replace('\u00a0', ' ')).indexOf(0) != -1) {
                        selection = selection.replaceAll("\u0000", "");
                    }
                    repeatCount = this.inputHandler.getRepeatCount();
                    sb = new StringBuilder();
                    i = 0;
                    while (i < repeatCount) {
                        sb.append(selection);
                        ++i;
                    }
                    selection = sb.toString();
                    this.setSelectedText(selection);
                    break block12;
                }
                catch (Exception v0) {
                    this.getToolkit().beep();
                    System.err.println("Clipboard does not contain a string");
                    var6_11 = flavors = clipboard.getAvailableDataFlavors();
                    var5_10 = flavors.length;
                    var4_7 = 0;
                    ** while (var4_7 < var5_10)
                }
lbl-1000:
                // 1 sources

                {
                    f = var6_11[var4_7];
                    try {
                        o = clipboard.getContents(this).getTransferData(f);
                        System.out.println(f + " = " + o);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++var4_7;
                    continue;
                }
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.caretTimer.stop();
    }

    @Override
    public void processKeyEvent(KeyEvent event) {
        super.processKeyEvent(event);
        if (this.inputHandler != null) {
            switch (event.getID()) {
                case 400: {
                    this.inputHandler.keyTyped(event);
                    break;
                }
                case 401: {
                    this.inputHandler.keyPressed(event);
                    break;
                }
                case 402: {
                    this.inputHandler.keyReleased(event);
                }
            }
        }
    }

    protected void fireCaretEvent() {
        Object[] listeners = this.eventListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == CaretListener.class) {
                ((CaretListener)listeners[i + 1]).caretUpdate(this.caretEvent);
            }
            --i;
        }
    }

    protected void updateBracketHighlight(int newCaretPosition) {
        if (newCaretPosition == 0) {
            this.bracketLine = -1;
            this.bracketPosition = -1;
            return;
        }
        try {
            int offset = this.bracketHelper.findMatchingBracket(this.document.getText(0, this.document.getLength()), newCaretPosition - 1);
            if (offset != -1) {
                this.bracketLine = this.getLineOfOffset(offset);
                this.bracketPosition = offset - this.getLineStartOffset(this.bracketLine);
                return;
            }
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent evt) {
        this.bracketHelper.invalidate();
        DocumentEvent.ElementChange ch = evt.getChange(this.document.getDefaultRootElement());
        int count = ch == null ? 0 : ch.getChildrenAdded().length - ch.getChildrenRemoved().length;
        int line = this.getLineOfOffset(evt.getOffset());
        if (count == 0) {
            this.painter.invalidateLine(line);
        } else if (line < this.firstLine) {
            this.setFirstLine(line);
        } else {
            this.painter.invalidateLineRange(line, this.firstLine + this.visibleLines);
            this.updateScrollBars();
        }
    }

    class AdjustHandler
    implements AdjustmentListener {
        AdjustHandler() {
        }

        @Override
        public void adjustmentValueChanged(final AdjustmentEvent evt) {
            if (!JEditTextArea.this.scrollBarsInitialized) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (evt.getAdjustable() == ((AdjustHandler)AdjustHandler.this).JEditTextArea.this.vertical) {
                        JEditTextArea.this.setFirstLine(((AdjustHandler)AdjustHandler.this).JEditTextArea.this.vertical.getValue());
                    } else {
                        JEditTextArea.this.setHorizontalOffset(-((AdjustHandler)AdjustHandler.this).JEditTextArea.this.horizontal.getValue());
                    }
                }
            });
        }
    }

    class CaretUndo
    extends AbstractUndoableEdit {
        private int start;
        private int end;

        CaretUndo(int start, int end2) {
            this.start = start;
            this.end = end2;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public String getPresentationName() {
            return "caret move";
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            JEditTextArea.this.select(this.start, this.end);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            JEditTextArea.this.select(this.start, this.end);
        }

        @Override
        public boolean addEdit(UndoableEdit edit) {
            if (edit instanceof CaretUndo) {
                CaretUndo cedit = (CaretUndo)edit;
                this.start = cedit.start;
                this.end = cedit.end;
                cedit.die();
                return true;
            }
            return false;
        }
    }

    private static enum CharacterKinds {
        Word,
        Whitespace,
        Other;

    }

    class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            JEditTextArea.this.recalculateVisibleLines();
            JEditTextArea.this.scrollBarsInitialized = true;
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            JEditTextArea.this.documentChanged(evt);
            int offset = evt.getOffset();
            int length = evt.getLength();
            int newStart = JEditTextArea.this.selectionStart > offset || JEditTextArea.this.selectionStart == JEditTextArea.this.selectionEnd && JEditTextArea.this.selectionStart == offset ? JEditTextArea.this.selectionStart + length : JEditTextArea.this.selectionStart;
            int newEnd = JEditTextArea.this.selectionEnd >= offset ? JEditTextArea.this.selectionEnd + length : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(newStart, newEnd);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            JEditTextArea.this.documentChanged(evt);
            int offset = evt.getOffset();
            int length = evt.getLength();
            int newStart = JEditTextArea.this.selectionStart > offset ? (JEditTextArea.this.selectionStart > offset + length ? JEditTextArea.this.selectionStart - length : offset) : JEditTextArea.this.selectionStart;
            int newEnd = JEditTextArea.this.selectionEnd > offset ? (JEditTextArea.this.selectionEnd > offset + length ? JEditTextArea.this.selectionEnd - length : offset) : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(newStart, newEnd);
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }
    }

    class DragHandler
    implements MouseMotionListener {
        DragHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (JEditTextArea.this.popup != null && JEditTextArea.this.popup.isVisible()) {
                return;
            }
            if (!JEditTextArea.this.selectWord && !JEditTextArea.this.selectLine) {
                try {
                    JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), JEditTextArea.this.xyToOffset(evt.getX(), evt.getY()));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Messages.loge("xToOffset problem", e);
                }
            } else {
                int line = JEditTextArea.this.yToLine(evt.getY());
                if (JEditTextArea.this.selectWord) {
                    JEditTextArea.this.setNewSelectionWord(line, JEditTextArea.this.xToOffset(line, evt.getX()));
                } else {
                    JEditTextArea.this.newSelectionStart = JEditTextArea.this.getLineStartOffset(line);
                    JEditTextArea.this.newSelectionEnd = JEditTextArea.this.getLineSelectionStopOffset(line);
                }
                if (JEditTextArea.this.newSelectionStart < JEditTextArea.this.selectionAncorStart) {
                    JEditTextArea.this.select(JEditTextArea.this.newSelectionStart, JEditTextArea.this.selectionAncorEnd);
                } else if (JEditTextArea.this.newSelectionEnd > JEditTextArea.this.selectionAncorEnd) {
                    JEditTextArea.this.select(JEditTextArea.this.selectionAncorStart, JEditTextArea.this.newSelectionEnd);
                } else {
                    JEditTextArea.this.select(JEditTextArea.this.newSelectionStart, JEditTextArea.this.newSelectionEnd);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            JEditTextArea.this.setCaretVisible(true);
        }

        @Override
        public void focusLost(FocusEvent evt) {
            JEditTextArea.this.setCaretVisible(false);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            boolean windowsRightClick;
            if (!JEditTextArea.this.hasFocus() && !JEditTextArea.this.requestFocusInWindow()) {
                return;
            }
            boolean bl = windowsRightClick = Platform.isWindows() && event.getButton() == 3;
            if ((event.isPopupTrigger() || windowsRightClick) && JEditTextArea.this.popup != null) {
                int offset = JEditTextArea.this.xyToOffset(event.getX(), event.getY());
                int selectionStart = JEditTextArea.this.getSelectionStart();
                int selectionStop = JEditTextArea.this.getSelectionStop();
                if (offset < selectionStart || offset >= selectionStop) {
                    JEditTextArea.this.select(offset, offset);
                }
                JEditTextArea.this.popup.show(JEditTextArea.this.painter, event.getX(), event.getY());
                return;
            }
            int line = JEditTextArea.this.yToLine(event.getY());
            int offset = JEditTextArea.this.xToOffset(line, event.getX());
            int dot = JEditTextArea.this.getLineStartOffset(line) + offset;
            JEditTextArea.this.selectLine = false;
            JEditTextArea.this.selectWord = false;
            switch (event.getClickCount()) {
                case 1: {
                    this.doSingleClick(event, line, offset, dot);
                    break;
                }
                case 2: {
                    try {
                        this.doDoubleClick(event, line, offset, dot);
                    }
                    catch (BadLocationException bl2) {
                        bl2.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    this.doTripleClick(event, line, offset, dot);
                }
            }
        }

        private void doSingleClick(MouseEvent evt, int line, int offset, int dot) {
            if ((evt.getModifiers() & 1) != 0) {
                JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), dot);
            } else {
                JEditTextArea.this.setCaretPosition(dot);
            }
        }

        private void doDoubleClick(MouseEvent evt, int line, int offset, int dot) throws BadLocationException {
            if (JEditTextArea.this.getLineLength(line) != 0) {
                try {
                    String text = JEditTextArea.this.document.getText(0, JEditTextArea.this.document.getLength());
                    int bracket = JEditTextArea.this.bracketHelper.findMatchingBracket(text, Math.max(0, dot - 1));
                    if (bracket != -1) {
                        int mark = JEditTextArea.this.getMarkPosition();
                        if (bracket > mark) {
                            ++bracket;
                            --mark;
                        }
                        JEditTextArea.this.select(mark, bracket);
                        return;
                    }
                }
                catch (BadLocationException bl) {
                    bl.printStackTrace();
                }
                JEditTextArea.this.setNewSelectionWord(line, offset);
                JEditTextArea.this.select(JEditTextArea.this.newSelectionStart, JEditTextArea.this.newSelectionEnd);
                JEditTextArea.this.selectWord = true;
                JEditTextArea.this.selectionAncorStart = JEditTextArea.this.selectionStart;
                JEditTextArea.this.selectionAncorEnd = JEditTextArea.this.selectionEnd;
            }
        }

        private void doTripleClick(MouseEvent evt, int line, int offset, int dot) {
            JEditTextArea.this.selectLine = true;
            JEditTextArea.this.select(JEditTextArea.this.getLineStartOffset(line), JEditTextArea.this.getLineSelectionStopOffset(line));
            JEditTextArea.this.selectionAncorStart = JEditTextArea.this.selectionStart;
            JEditTextArea.this.selectionAncorEnd = JEditTextArea.this.selectionEnd;
        }
    }

    class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(JEditTextArea.this);
        }

        @Override
        public int getDot() {
            return JEditTextArea.this.getCaretPosition();
        }

        @Override
        public int getMark() {
            return JEditTextArea.this.getMarkPosition();
        }
    }

    class ScrollLayout
    implements LayoutManager {
        private Component center;
        private Component right;
        private Component bottom;
        private Vector leftOfScrollBar = new Vector();

        ScrollLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name.equals(CENTER)) {
                this.center = comp;
            } else if (name.equals(RIGHT)) {
                this.right = comp;
            } else if (name.equals(BOTTOM)) {
                this.bottom = comp;
            } else if (name.equals(LEFT_OF_SCROLLBAR)) {
                this.leftOfScrollBar.addElement(comp);
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (this.center == comp) {
                this.center = null;
            }
            if (this.right == comp) {
                this.right = null;
            }
            if (this.bottom == comp) {
                this.bottom = null;
            } else {
                this.leftOfScrollBar.removeElement(comp);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension centerPref = this.center.getPreferredSize();
            dim.width += centerPref.width;
            dim.height += centerPref.height;
            Dimension rightPref = this.right.getPreferredSize();
            dim.width += rightPref.width;
            Dimension bottomPref = this.bottom.getPreferredSize();
            dim.height += bottomPref.height;
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension centerPref = this.center.getMinimumSize();
            dim.width += centerPref.width;
            dim.height += centerPref.height;
            Dimension rightPref = this.right.getMinimumSize();
            dim.width += rightPref.width;
            Dimension bottomPref = this.bottom.getMinimumSize();
            dim.height += bottomPref.height;
            dim.height += 5;
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Insets insets = parent.getInsets();
            int itop = insets.top;
            int ileft = insets.left;
            int ibottom = insets.bottom;
            int iright = insets.right;
            int rightWidth = this.right.getPreferredSize().width;
            int bottomHeight = this.bottom.getPreferredSize().height;
            int centerWidth = size.width - rightWidth - ileft - iright;
            int centerHeight = size.height - bottomHeight - itop - ibottom;
            this.center.setBounds(ileft, itop, centerWidth, centerHeight);
            this.right.setBounds(ileft + centerWidth, itop, rightWidth, centerHeight);
            Enumeration status = this.leftOfScrollBar.elements();
            while (status.hasMoreElements()) {
                Component comp = (Component)status.nextElement();
                Dimension dim = comp.getPreferredSize();
                comp.setBounds(ileft, itop + centerHeight, dim.width, bottomHeight);
                ileft += dim.width;
            }
            this.bottom.setBounds(ileft, itop + centerHeight, size.width - rightWidth - ileft - iright, bottomHeight);
        }
    }
}

