/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import processing.app.Base;
import processing.app.Language;
import processing.app.tools.CharacterSelector;
import processing.app.tools.SampleComponent;
import processing.app.tools.Tool;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;
import processing.core.PFont;

public class CreateFont
extends JFrame
implements Tool {
    Base base;
    JList<String> fontSelector;
    JTextField sizeSelector;
    JButton charsetButton;
    JCheckBox smoothBox;
    JComponent sample;
    JButton okButton;
    JTextField filenameField;
    Map<String, Font> table;
    boolean smooth = true;
    Font font;
    String[] list;
    int selection = -1;
    CharacterSelector charSelector;

    public CreateFont() {
        super(Language.text("create_font"));
    }

    @Override
    public String getMenuTitle() {
        return Language.text("menu.tools.create_font");
    }

    @Override
    public void init(Base base) {
        this.base = base;
        Container paine = this.getContentPane();
        paine.setLayout(new BorderLayout());
        JPanel pain = new JPanel();
        pain.setBorder(new EmptyBorder(13, 13, 13, 13));
        paine.add((Component)pain, "Center");
        pain.setLayout(new BoxLayout(pain, 1));
        String labelText = Language.text("create_font.label");
        JTextArea textarea = new JTextArea(labelText);
        textarea.setBorder(new EmptyBorder(10, 10, 20, 10));
        textarea.setBackground(null);
        textarea.setEditable(false);
        textarea.setHighlighter(null);
        textarea.setFont(new Font("Dialog", 0, 12));
        pain.add(textarea);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        String[] fontList = new String[fonts.length];
        this.table = new HashMap<String, Font>();
        int index = 0;
        int i = 0;
        while (i < fonts.length) {
            try {
                fontList[index++] = fonts[i].getPSName();
                this.table.put(fonts[i].getPSName(), fonts[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.list = new String[index];
        System.arraycopy(fontList, 0, this.list, 0, index);
        this.fontSelector = new JList<String>(this.list);
        this.fontSelector.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CreateFont.this.selection = CreateFont.this.fontSelector.getSelectedIndex();
                    CreateFont.this.okButton.setEnabled(true);
                    CreateFont.this.update();
                }
            }
        });
        this.fontSelector.setSelectionMode(0);
        this.fontSelector.setVisibleRowCount(12);
        JScrollPane fontScroller = new JScrollPane(this.fontSelector);
        pain.add(fontScroller);
        Dimension d1 = new Dimension(13, 13);
        pain.add(new Box.Filler(d1, d1, d1));
        this.sample = new SampleComponent(this);
        this.sample.setFont(new Font("Dialog", 0, 12));
        pain.add(this.sample);
        Dimension d2 = new Dimension(6, 6);
        pain.add(new Box.Filler(d2, d2, d2));
        JPanel panel = new JPanel();
        panel.add(new JLabel(String.valueOf(Language.text("create_font.size")) + ":"));
        this.sizeSelector = new JTextField(" 48 ");
        this.sizeSelector.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreateFont.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreateFont.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        panel.add(this.sizeSelector);
        this.smoothBox = new JCheckBox(Language.text("create_font.smooth"));
        this.smoothBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFont.this.smooth = CreateFont.this.smoothBox.isSelected();
                CreateFont.this.update();
            }
        });
        this.smoothBox.setSelected(this.smooth);
        panel.add(this.smoothBox);
        this.charsetButton = new JButton(Language.text("create_font.characters"));
        this.charsetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFont.this.charSelector.setVisible(true);
            }
        });
        panel.add(this.charsetButton);
        pain.add(panel);
        JPanel filestuff = new JPanel();
        filestuff.add(new JLabel(String.valueOf(Language.text("create_font.filename")) + ":"));
        this.filenameField = new JTextField(20);
        filestuff.add(this.filenameField);
        filestuff.add(new JLabel(".vlw"));
        pain.add(filestuff);
        JPanel buttons = new JPanel();
        JButton cancelButton = new JButton(Language.text("prompt.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFont.this.setVisible(false);
            }
        });
        this.okButton = new JButton(Language.text("prompt.ok"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFont.this.build();
            }
        });
        this.okButton.setEnabled(false);
        buttons.add(cancelButton);
        buttons.add(this.okButton);
        pain.add(buttons);
        JRootPane root = this.getRootPane();
        root.setDefaultButton(this.okButton);
        ActionListener disposer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateFont.this.setVisible(false);
            }
        };
        Toolkit.registerWindowCloseKeys(root, disposer);
        Toolkit.setIcon(this);
        this.pack();
        this.setResizable(false);
        this.sample.setFont(new Font(this.list[0], 0, 48));
        this.fontSelector.setSelectedIndex(0);
        this.setLocationRelativeTo(null);
        this.charSelector = new CharacterSelector();
    }

    @Override
    public void run() {
        this.setVisible(true);
    }

    public void update() {
        int fontsize = 0;
        try {
            fontsize = Integer.parseInt(this.sizeSelector.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {}
        if (fontsize > 0 && fontsize < 256 && this.selection != -1) {
            Font instance = this.table.get(this.list[this.selection]);
            this.font = instance.deriveFont((float)fontsize);
            this.sample.setFont(this.font);
            String filenameSuggestion = this.list[this.selection].replace(' ', '_');
            filenameSuggestion = String.valueOf(filenameSuggestion) + "-" + fontsize;
            this.filenameField.setText(filenameSuggestion);
        }
    }

    public void build() {
        int fontsize = 0;
        try {
            fontsize = Integer.parseInt(this.sizeSelector.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {}
        if (fontsize <= 0) {
            JOptionPane.showMessageDialog(this, "Bad font size, try again.", "Badness", 2);
            return;
        }
        String filename = this.filenameField.getText().trim();
        if (filename.length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a file name for the font.", "Lameness", 2);
            return;
        }
        if (!filename.endsWith(".vlw")) {
            filename = String.valueOf(filename) + ".vlw";
        }
        try {
            Font instance = this.table.get(this.list[this.selection]);
            this.font = instance.deriveFont(0, fontsize);
            PFont f = new PFont(this.font, this.smooth, this.charSelector.getCharacters());
            Editor editor = this.base.getActiveEditor();
            File folder = editor.getSketch().prepareDataFolder();
            f.save((OutputStream)new FileOutputStream(new File(folder, filename)));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "An error occurred while creating font.", "No font for you", 2);
            e.printStackTrace();
        }
        this.setVisible(false);
    }
}

