/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;

public class SplashWindow
extends Window {
    private static SplashWindow instance;
    private Image image;
    private boolean paintCalled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SplashWindow(Frame parent, Image image, boolean hidpi) {
        super(parent);
        this.image = image;
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
        if (mt.isErrorID(0)) {
            this.setSize(0, 0);
            System.err.println("Warning: SplashWindow couldn't load splash image.");
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.paintCalled = true;
                this.notifyAll();
            }
            return;
        }
        int imgWidth = image.getWidth(this);
        int imgHeight = image.getHeight(this);
        if (hidpi) {
            imgWidth /= 2;
            imgHeight /= 2;
        }
        this.setSize(imgWidth, imgHeight);
        this.setLocationRelativeTo(null);
        MouseAdapter disposeOnClick = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent evt) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(disposeOnClick);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void splash(Image image, boolean hidpi) {
        if (instance != null) return;
        if (image == null) return;
        Frame f = new Frame();
        instance = new SplashWindow(f, image, hidpi);
        instance.setVisible(true);
        if (EventQueue.isDispatchThread()) return;
        if (Runtime.getRuntime().availableProcessors() != 1) return;
        SplashWindow splashWindow = instance;
        synchronized (splashWindow) {
            while (true) {
                if (SplashWindow.instance.paintCalled) {
                    return;
                }
                try {
                    instance.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static void splash(URL imageURL, boolean hidpi) {
        if (imageURL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(imageURL), hidpi);
        }
    }

    public static void disposeSplash() {
        if (instance != null) {
            instance.getOwner().dispose();
            instance = null;
        }
    }

    public static void invokeMain(String className, String[] args) {
        try {
            Class.forName(className).getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            InternalError error = new InternalError("Failed to invoke main method");
            error.initCause(e);
            throw error;
        }
    }
}

