/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui.datatransfer;

import ch.randelshofer.gui.datatransfer.AbstractTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class PlainTextTransferable
extends AbstractTransferable {
    private String plainText;

    public PlainTextTransferable(String string) {
        this(PlainTextTransferable.getDefaultFlavors(), string);
    }

    public PlainTextTransferable(DataFlavor dataFlavor, String string) {
        this(new DataFlavor[]{dataFlavor}, string);
    }

    public PlainTextTransferable(DataFlavor[] dataFlavorArray, String string) {
        super(dataFlavorArray);
        this.plainText = string;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        String string = this.plainText = this.plainText == null ? "" : this.plainText;
        if (String.class.equals(dataFlavor.getRepresentationClass())) {
            return this.plainText;
        }
        if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
            return new StringReader(this.plainText);
        }
        if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
            String string2 = dataFlavor.getParameter("charset");
            return new ByteArrayInputStream(this.plainText.getBytes(string2 == null ? "UTF-8" : string2));
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    protected static DataFlavor[] getDefaultFlavors() {
        try {
            return new DataFlavor[]{new DataFlavor("text/plain;class=java.lang.String"), new DataFlavor("text/plain;class=java.io.Reader"), new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream")};
        }
        catch (ClassNotFoundException classNotFoundException) {
            InternalError internalError = new InternalError("error initializing PlainTextTransferable");
            internalError.initCause(classNotFoundException);
            throw internalError;
        }
    }
}

