*** Settings ***
Documentation     Tests are not run using Python 3.6 because `typing.get_type_hints` handles
...               Unions incorrectly with it making test results too different compared to others.
Force Tags        require-py3.7
Suite Setup       Run Libdoc And Parse Output    ${TESTDATADIR}/DataTypesLibrary.py
Resource          libdoc_resource.robot

*** Test Cases ***
Enum
    DataType Enum Should Be    0
    ...    AssertionOperator
    ...    This is some Doc\n\nThis has was defined by assigning to __doc__.
    ...    {"name": "equal","value": "=="}
    ...    {"name": "==","value": "=="}
    ...    {"name": "<","value": "<"}
    ...    {"name": ">","value": ">"}
    ...    {"name": "<=","value": "<="}
    ...    {"name": ">=","value": ">="}
    DataType Enum Should Be    1
    ...    Small
    ...    This is the Documentation.\n\nThis was defined within the class definition.
    ...    {"name": "one","value": "1"}
    ...    {"name": "two","value": "2"}
    ...    {"name": "three","value": "3"}
    ...    {"name": "four","value": "4"}

TypedDict
    ${required}     Get Element Count    ${LIBDOC}    xpath=dataTypes/typedDicts/typedDict/items/item[@required]
    IF   $required == 0
        DataType TypedDict Should Be    0
        ...    GeoLocation
        ...    Defines the geolocation.\n\n- ``latitude`` Latitude between -90 and 90.\n- ``longitude`` Longitude between -180 and 180.\n- ``accuracy`` *Optional* Non-negative accuracy value. Defaults to 0.\n\nExample usage: ``{'latitude': 59.95, 'longitude': 30.31667}``
        ...    {"key": "longitude", "type": "float"}
        ...    {"key": "latitude", "type": "float"}
        ...    {"key": "accuracy", "type": "float"}
    ELSE
        DataType TypedDict Should Be    0
        ...    GeoLocation
        ...    Defines the geolocation.\n\n- ``latitude`` Latitude between -90 and 90.\n- ``longitude`` Longitude between -180 and 180.\n- ``accuracy`` *Optional* Non-negative accuracy value. Defaults to 0.\n\nExample usage: ``{'latitude': 59.95, 'longitude': 30.31667}``
        ...    {"key": "longitude", "type": "float", "required": "true"}
        ...    {"key": "latitude", "type": "float", "required": "true"}
        ...    {"key": "accuracy", "type": "float", "required": "false"}
    END

Custom
    DataType Custom Should Be    0
    ...    CustomType
    ...    Converter method doc is used when defined.
    DataType Custom Should Be    1
    ...    CustomType2
    ...    Class doc is used when converter method has no doc.

Standard
    DataType Standard Should Be    0
    ...    boolean
    ...    Strings ``TRUE``, ``YES``, ``ON`` and ``1`` are converted to Boolean ``True``,

Accepted types
    Accepted Types Should Be    1     Standard     boolean
    ...    string    integer    float    None
    Accepted Types Should Be    2     Custom       CustomType
    ...    string    integer
    Accepted Types Should Be    3     Custom       CustomType2
    Accepted Types Should Be    6     TypedDict    GeoLocation
    ...    string
    Accepted Types Should Be    0     Enum         AssertionOperator
    ...    string
    Accepted Types Should Be    10    Enum         Small
    ...    string    integer

Usages
    Usages Should Be    1     Standard     boolean
    ...    Funny Unions
    Usages Should Be    2     Custom       CustomType
    ...    Custom
    Usages Should be    6     TypedDict    GeoLocation
    ...    Funny Unions    Set Location
    Usages Should Be    10    Enum         Small
    ...    __init__    Funny Unions

Typedoc links in arguments
    Typedoc links should be    0    1    AssertionOperator    None
    Typedoc links should be    0    2    str:string
    Typedoc links should be    1    0    CustomType
    Typedoc links should be    1    1    CustomType2
    Typedoc links should be    2    0    bool:boolean    int:integer    float    str:string    AssertionOperator    Small    GeoLocation    None
    Typedoc links should be    4    0    List[str]:list
    Typedoc links should be    4    1    Dict[str, int]:dictionary
    Typedoc links should be    4    2    Any:
    Typedoc links should be    4    3    List[Any]:list
